/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ToStringRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "ToStringRenderer";
    private boolean USE_CLASS_FILTERS = false;
    private ClassFilter[] myClassFilters = ClassFilter.EMPTY_ARRAY;

    public ToStringRenderer() {
        this.setEnabled(true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "toString";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public ToStringRenderer clone() {
        ToStringRenderer cloned = (ToStringRenderer)super.clone();
        ClassFilter[] classFilters = this.myClassFilters.length > 0 ? new ClassFilter[this.myClassFilters.length] : ClassFilter.EMPTY_ARRAY;
        for (int idx = 0; idx < classFilters.length; ++idx) {
            classFilters[idx] = this.myClassFilters[idx].clone();
        }
        cloned.myClassFilters = classFilters;
        return cloned;
    }

    @Override
    public String calcLabel(final ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, final DescriptorLabelListener labelListener) throws EvaluateException {
        final Value value = valueDescriptor.getValue();
        BatchEvaluator.getBatchEvaluator(evaluationContext.getDebugProcess()).invoke(new ToStringCommand(evaluationContext, value){

            @Override
            public void evaluationResult(String message) {
                valueDescriptor.setValueLabel(StringUtil.notNullize((String)message));
                labelListener.labelChanged();
            }

            @Override
            public void evaluationError(String message) {
                String msg = value != null ? message + " " + DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{value.type().name()}) : message;
                valueDescriptor.setValueLabelFailed(new EvaluateException(msg, null));
                labelListener.labelChanged();
            }
        });
        return XDebuggerUIConstants.COLLECTING_DATA_MESSAGE;
    }

    public boolean isUseClassFilters() {
        return this.USE_CLASS_FILTERS;
    }

    public void setUseClassFilters(boolean value) {
        this.USE_CLASS_FILTERS = value;
    }

    @Override
    public boolean isApplicable(Type type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        if ("java.lang.String".equals(type.name())) {
            return false;
        }
        if (!ToStringRenderer.overridesToString(type)) {
            return false;
        }
        return !this.USE_CLASS_FILTERS || this.isFiltered(type);
    }

    private static boolean overridesToString(Type type) {
        if (type instanceof ClassType) {
            List<Method> methods = ((ClassType)type).methodsByName("toString", "()Ljava/lang/String;");
            for (Method method : methods) {
                if (method.declaringType().name().equals("java.lang.Object")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebugProcessImpl debugProcess = (DebugProcessImpl)evaluationContext.getDebugProcess();
        DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, builder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        Value parentValue = ((ValueDescriptor)node.getParent().getDescriptor()).getValue();
        DebugProcessImpl debugProcess = (DebugProcessImpl)context.getDebugProcess();
        return DebugProcessImpl.getDefaultRenderer(parentValue).getChildValueExpression(node, context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        DebugProcessImpl debugProcess = (DebugProcessImpl)evaluationContext.getDebugProcess();
        return DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, parentDescriptor);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String value = JDOMExternalizerUtil.readField((Element)element, (String)"USE_CLASS_FILTERS");
        this.USE_CLASS_FILTERS = "true".equalsIgnoreCase(value);
        this.myClassFilters = DebuggerUtilsEx.readFilters(element.getChildren("filter"));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_CLASS_FILTERS", (String)(this.USE_CLASS_FILTERS ? "true" : "false"));
        DebuggerUtilsEx.writeFilters(element, "filter", this.myClassFilters);
    }

    public ClassFilter[] getClassFilters() {
        return this.myClassFilters;
    }

    public void setClassFilters(ClassFilter[] classFilters) {
        this.myClassFilters = classFilters != null ? classFilters : ClassFilter.EMPTY_ARRAY;
    }

    private boolean isFiltered(Type t) {
        if (t instanceof ReferenceType) {
            for (ClassFilter classFilter : this.myClassFilters) {
                if (!classFilter.isEnabled() || DebuggerUtils.getSuperType((Type)t, (String)classFilter.getPattern()) == null) continue;
                return true;
            }
        }
        return DebuggerUtilsEx.isFiltered(t.name(), this.myClassFilters);
    }
}

