/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedDetectedFrameworkDescription<F extends Facet, C extends FacetConfiguration>
extends DetectedFrameworkDescription {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FacetBasedDetectedFrameworkDescription");
    private final FacetBasedFrameworkDetector<F, C> myDetector;
    private final C myConfiguration;
    private final Set<VirtualFile> myRelatedFiles;
    private final FacetType<F, C> myFacetType;

    public FacetBasedDetectedFrameworkDescription(FacetBasedFrameworkDetector<F, C> detector, @NotNull C configuration, Set<VirtualFile> files) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription", "<init>"));
        }
        this.myDetector = detector;
        this.myConfiguration = configuration;
        this.myRelatedFiles = files;
        this.myFacetType = detector.getFacetType();
    }

    @NotNull
    public Collection<? extends VirtualFile> getRelatedFiles() {
        Set<VirtualFile> set = this.myRelatedFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription", "getRelatedFiles"));
        }
        return set;
    }

    public C getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public String getSetupText() {
        String string = "'" + this.myFacetType.getPresentableName() + "' facet will be added to '" + this.getModuleName() + "' module";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription", "getSetupText"));
        }
        return string;
    }

    @NotNull
    public FrameworkDetector getDetector() {
        FacetBasedFrameworkDetector<F, C> facetBasedFrameworkDetector = this.myDetector;
        if (facetBasedFrameworkDetector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription", "getDetector"));
        }
        return facetBasedFrameworkDetector;
    }

    protected abstract String getModuleName();

    public boolean canSetupFramework(@NotNull Collection<? extends DetectedFrameworkDescription> allDetectedFrameworks) {
        if (allDetectedFrameworks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDetectedFrameworks", "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription", "canSetupFramework"));
        }
        FacetTypeId underlyingId = this.myFacetType.getUnderlyingFacetType();
        if (underlyingId == null) {
            return true;
        }
        Collection<Facet> facets = this.getExistentFacets(underlyingId);
        for (Facet facet : facets) {
            if (!this.myDetector.isSuitableUnderlyingFacetConfiguration(facet.getConfiguration(), this.myConfiguration, this.myRelatedFiles)) continue;
            return true;
        }
        for (DetectedFrameworkDescription detectedFrameworkDescription : allDetectedFrameworks) {
            if (!(detectedFrameworkDescription instanceof FacetBasedDetectedFrameworkDescription)) continue;
            FacetBasedDetectedFrameworkDescription description = (FacetBasedDetectedFrameworkDescription)detectedFrameworkDescription;
            if (!underlyingId.equals(description.myFacetType.getId()) || !this.myDetector.isSuitableUnderlyingFacetConfiguration(description.getConfiguration(), this.myConfiguration, this.myRelatedFiles)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<? extends Facet> getExistentFacets(FacetTypeId<?> var1);

    protected void doSetup(ModifiableModelsProvider modifiableModelsProvider, final Module module) {
        ModifiableFacetModel model = modifiableModelsProvider.getFacetModifiableModel(module);
        String name = UniqueNameGenerator.generateUniqueName((String)this.myFacetType.getDefaultFacetName(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return FacetManager.getInstance((Module)module).findFacet(FacetBasedDetectedFrameworkDescription.this.myFacetType.getId(), s) == null;
            }
        });
        Facet facet = FacetManager.getInstance((Module)module).createFacet(this.myFacetType, name, this.myConfiguration, this.findUnderlyingFacet(module));
        model.addFacet(facet);
        modifiableModelsProvider.commitFacetModifiableModel(module, model);
        ModifiableRootModel rootModel = modifiableModelsProvider.getModuleModifiableModel(module);
        this.myDetector.setupFacet(facet, rootModel);
        modifiableModelsProvider.commitModuleModifiableModel(rootModel);
    }

    @Nullable
    private Facet findUnderlyingFacet(Module module) {
        FacetTypeId underlyingTypeId = this.myFacetType.getUnderlyingFacetType();
        if (underlyingTypeId == null) {
            return null;
        }
        Collection parentFacets = FacetManager.getInstance((Module)module).getFacetsByType(underlyingTypeId);
        for (Facet facet : parentFacets) {
            if (!this.myDetector.isSuitableUnderlyingFacetConfiguration(facet.getConfiguration(), this.myConfiguration, this.myRelatedFiles)) continue;
            return facet;
        }
        LOG.error("Cannot find suitable underlying facet in " + parentFacets);
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FacetBasedDetectedFrameworkDescription)) {
            return false;
        }
        FacetBasedDetectedFrameworkDescription other = (FacetBasedDetectedFrameworkDescription)((Object)obj);
        return this.getModuleName().equals(other.getModuleName()) && this.myFacetType.equals(other.myFacetType) && this.myRelatedFiles.equals(other.myRelatedFiles);
    }

    public int hashCode() {
        return this.getModuleName().hashCode() + 31 * this.myFacetType.hashCode() + 239 * this.myRelatedFiles.hashCode();
    }
}

