/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.SelectInTargetBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WrappingVirtualFile;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureSelectInTarget
extends SelectInTargetBase
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file2 = context.getVirtualFile();
        if (file2 instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file2).getWrappedObject(context.getProject());
            return o instanceof Facet;
        }
        return fileIndex.isInContent(file2) || fileIndex.isInLibraryClasses(file2) || fileIndex.isInLibrarySource(file2) || StdFileTypes.IDEA_MODULE.equals(file2.getFileType()) && ProjectStructureSelectInTarget.findModuleByModuleFile(context.getProject(), file2) != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        Module module;
        Facet facet;
        final Project project = context.getProject();
        VirtualFile file2 = context.getVirtualFile();
        if (file2 instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file2).getWrappedObject(project);
            facet = o instanceof Facet ? (Facet)o : null;
            module = facet == null ? null : facet.getModule();
        } else {
            Module moduleByIml = file2.getFileType().equals(StdFileTypes.IDEA_MODULE) ? ProjectStructureSelectInTarget.findModuleByModuleFile(project, file2) : null;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            module = moduleByIml != null ? moduleByIml : fileIndex.getModuleForFile(file2);
            Facet facet2 = facet = fileIndex.isInSourceContent(file2) ? null : ProjectStructureSelectInTarget.findFacet(project, file2);
        }
        if (module != null || facet != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (facet != null) {
                        ModulesConfigurator.showFacetSettingsDialog(facet, null);
                    } else {
                        ProjectSettingsService.getInstance(project).openModuleSettings(module);
                    }
                }
            });
            return;
        }
        final OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)file2, (Project)project);
        if (orderEntry != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectSettingsService.getInstance(project).openLibraryOrSdkSettings(orderEntry);
                }
            });
        }
    }

    @Nullable
    private static Module findModuleByModuleFile(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectStructureSelectInTarget", "findModuleByModuleFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/impl/ProjectStructureSelectInTarget", "findModuleByModuleFile"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!ModuleUtilCore.isModuleFile((Module)module, (VirtualFile)file2)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    private static Facet findFacet(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectStructureSelectInTarget", "findFacet"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/impl/ProjectStructureSelectInTarget", "findFacet"));
        }
        for (FacetTypeId id : FacetTypeRegistry.getInstance().getFacetTypeIds()) {
            Facet facet;
            if (!ProjectStructureSelectInTarget.hasFacetWithRoots(project, id) || (facet = FacetFinder.getInstance((Project)project).findFacet(file2, id)) == null) continue;
            return facet;
        }
        return null;
    }

    private static <F extends Facet> boolean hasFacetWithRoots(@NotNull Project project, @NotNull FacetTypeId<F> id) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectStructureSelectInTarget", "hasFacetWithRoots"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/impl/ProjectStructureSelectInTarget", "hasFacetWithRoots"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(id);
            Iterator iterator = facets.iterator();
            if (!iterator.hasNext()) continue;
            return iterator.next() instanceof FacetRootsProvider;
        }
        return false;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.project.settings", (Object[])new Object[0]);
    }

    public float getWeight() {
        return 10.0f;
    }
}

