/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{ProjectKeys.MODULE, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list = Arrays.asList(KEYS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "getKeys"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result2 = new SmartList();
        ExternalSystemViewDefaultContributor.addModuleNodes(externalProjectsView, dataNodes, result2);
        TasksNode tasksNode = new TasksNode(externalProjectsView, dataNodes.get((Object)ProjectKeys.TASK));
        if (externalProjectsView.useTasksNode()) {
            result2.add(tasksNode);
        } else {
            ContainerUtil.addAll((Collection)result2, (Object[])tasksNode.getChildren());
        }
        ExternalSystemViewDefaultContributor.addDependenciesNode(externalProjectsView, dataNodes, result2);
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "createNodes"));
        }
        return smartList;
    }

    private static void addDependenciesNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<ExternalSystemNode<?>> result2) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "addDependenciesNode"));
        }
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "addDependenciesNode"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "addDependenciesNode"));
        }
        Collection moduleDeps = dataNodes.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection libDeps = dataNodes.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!moduleDeps.isEmpty() || !libDeps.isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            for (DataNode dataNode : moduleDeps) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                depNode.add(new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode));
            }
            for (DataNode dataNode : libDeps) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                LibraryDependencyDataExternalSystemNode libraryDependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                depNode.add(libraryDependencyDataExternalSystemNode);
                libraryDependencyDataExternalSystemNode.setErrorLevel(((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved() ? ExternalProjectsStructure.ErrorLevel.ERROR : ExternalProjectsStructure.ErrorLevel.NONE);
            }
            result2.add(depNode);
        }
    }

    private static void addModuleNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<ExternalSystemNode<?>> result2) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "addModuleNodes"));
        }
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "addModuleNodes"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor", "addModuleNodes"));
        }
        Collection moduleDataNodes = dataNodes.get((Object)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            for (DataNode dataNode : moduleDataNodes) {
                ModuleData data = (ModuleData)dataNode.getData();
                ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(data.getLinkedExternalProjectPath());
                boolean isRoot = projectSettings != null && data.getLinkedExternalProjectPath().equals(projectSettings.getExternalProjectPath());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, isRoot);
                result2.add(moduleNode);
            }
        }
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends ExternalSystemNode<LibraryDependencyData> {
        public LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData data = (LibraryDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null, data.getScope().getDisplayName());
            }
        }

        public String getName() {
            LibraryDependencyData data = (LibraryDependencyData)this.getData();
            return data != null ? data.getExternalName() : "";
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return new Navigatable(){
                @Nullable
                private OrderEntry myOrderEntry;

                public void navigate(boolean requestFocus) {
                    if (this.myOrderEntry != null) {
                        ProjectSettingsService.getInstance(LibraryDependencyDataExternalSystemNode.this.myProject).openLibraryOrSdkSettings(this.myOrderEntry);
                    }
                }

                public boolean canNavigate() {
                    this.myOrderEntry = LibraryDependencyDataExternalSystemNode.this.getOrderEntry();
                    return this.myOrderEntry != null;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }

        @Nullable
        private OrderEntry getOrderEntry() {
            LibraryDependencyData data = (LibraryDependencyData)this.getData();
            if (data == null) {
                return null;
            }
            Project project = this.getProject();
            if (project == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project).findIdeModuleOrderEntry((DependencyData)data);
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends ExternalSystemNode<ModuleDependencyData> {
        public ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData data = (ModuleDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null, data.getScope().getDisplayName());
            }
        }

        public String getName() {
            ModuleDependencyData data = (ModuleDependencyData)this.getData();
            return data != null ? data.getExternalName() : "";
        }

        public boolean isAlwaysLeaf() {
            return true;
        }
    }

    @Order(value=2)
    private static class MyDependenciesNode
    extends ExternalSystemNode {
        public MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        public String getName() {
            return "Dependencies";
        }
    }
}

