/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.autodetect.FormatterBasedLineIndentInfoBuilder;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetector;
import com.intellij.psi.codeStyle.autodetect.IndentUsageInfo;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatistics;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatisticsImpl;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentOptionsDetectorImpl
implements IndentOptionsDetector {
    private static Logger LOG = Logger.getInstance((String)"#com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptionsDetector");
    private static final double RATE_THRESHOLD = 0.8;
    private static final int MAX_INDENT_TO_DETECT = 8;
    private final PsiFile myFile;
    private final Project myProject;
    private final Document myDocument;

    public IndentOptionsDetectorImpl(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "<init>"));
        }
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentOptions(this.myFile.getFileType()).clone();
        List<LineIndentInfo> linesInfo = this.calcLineIndentInfo();
        if (linesInfo != null) {
            IndentUsageStatisticsImpl stats = new IndentUsageStatisticsImpl(linesInfo);
            this.adjustIndentOptions(indentOptions, stats);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "getIndentOptions"));
        }
        return indentOptions2;
    }

    private List<LineIndentInfo> calcLineIndentInfo() {
        if (this.myDocument == null) {
            return null;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        FormattingModelBuilder modelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)this.myFile);
        if (modelBuilder == null) {
            return null;
        }
        FormattingModel model = modelBuilder.createModel((PsiElement)this.myFile, settings);
        Block rootBlock = model.getRootBlock();
        return new FormatterBasedLineIndentInfoBuilder(this.myDocument, rootBlock).build();
    }

    private void adjustIndentOptions(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @NotNull IndentUsageStatistics stats) {
        if (indentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "adjustIndentOptions"));
        }
        if (stats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stats", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "adjustIndentOptions"));
        }
        if (IndentOptionsDetectorImpl.isTabsUsed(stats)) {
            this.adjustForTabUsage(indentOptions);
        } else if (IndentOptionsDetectorImpl.isSpacesUsed(stats)) {
            indentOptions.USE_TAB_CHARACTER = false;
            int newIndentSize = IndentOptionsDetectorImpl.getPositiveIndentSize(stats);
            if (newIndentSize > 0 && indentOptions.INDENT_SIZE != newIndentSize) {
                indentOptions.INDENT_SIZE = newIndentSize;
                LOG.debug("Detected indent size: " + newIndentSize + " for file " + this.myFile);
            }
        }
    }

    private static boolean isSpacesUsed(IndentUsageStatistics stats) {
        int total;
        int spaces = stats.getTotalLinesWithLeadingSpaces();
        return (double)spaces / (double)(total = stats.getTotalLinesWithLeadingSpaces() + stats.getTotalLinesWithLeadingTabs()) > 0.8;
    }

    private static boolean isTabsUsed(IndentUsageStatistics stats) {
        return stats.getTotalLinesWithLeadingTabs() > stats.getTotalLinesWithLeadingSpaces();
    }

    private void adjustForTabUsage(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "adjustForTabUsage"));
        }
        if (indentOptions.USE_TAB_CHARACTER) {
            return;
        }
        int continuationRatio = indentOptions.INDENT_SIZE == 0 ? 1 : indentOptions.CONTINUATION_INDENT_SIZE / indentOptions.INDENT_SIZE;
        indentOptions.USE_TAB_CHARACTER = true;
        indentOptions.INDENT_SIZE = indentOptions.TAB_SIZE;
        indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.TAB_SIZE * continuationRatio;
        LOG.debug("Using tabs for: " + this.myFile);
    }

    private static int getPositiveIndentSize(@NotNull IndentUsageStatistics stats) {
        double usageRate;
        if (stats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stats", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "getPositiveIndentSize"));
        }
        int totalIndentSizesDetected = stats.getTotalIndentSizesDetected();
        if (totalIndentSizesDetected == 0) {
            return -1;
        }
        IndentUsageInfo maxUsedIndentInfo = stats.getKMostUsedIndentInfo(0);
        int maxUsedIndentSize = maxUsedIndentInfo.getIndentSize();
        if (maxUsedIndentSize == 0) {
            if (totalIndentSizesDetected < 2) {
                return -1;
            }
            maxUsedIndentInfo = stats.getKMostUsedIndentInfo(1);
            maxUsedIndentSize = maxUsedIndentInfo.getIndentSize();
        }
        if (maxUsedIndentSize <= 8 && (usageRate = (double)maxUsedIndentInfo.getTimesUsed() / (double)stats.getTotalLinesWithLeadingSpaces()) > 0.8) {
            return maxUsedIndentSize;
        }
        return -1;
    }
}

