/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveUtil {
    public static PsiClass getContextClass(PsiElement element) {
        for (PsiElement scope = element.getContext(); scope != null; scope = scope.getContext()) {
            if (!(scope instanceof PsiClass)) continue;
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiElement findParentContextOfClass(PsiElement element, Class aClass, boolean strict) {
        PsiElement scope;
        PsiElement psiElement = scope = strict ? element.getContext() : element;
        while (scope != null && !aClass.isInstance(scope)) {
            scope = scope.getContext();
        }
        return scope;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "isAccessible"));
        }
        return JavaResolveUtil.isAccessible(member, memberClass, modifierList, place, accessObjectClass, fileResolveScope, place.getContainingFile());
    }

    public static boolean isAccessible(@NotNull PsiMember member, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope, @Nullable PsiFile placeFile) {
        PsiClass clazz;
        PsiFile file2;
        PsiClass containingClass;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "isAccessible"));
        }
        if (modifierList == null || JavaResolveUtil.isInJavaDoc(place)) {
            return true;
        }
        if (placeFile instanceof JavaCodeFragment) {
            JavaCodeFragment fragment = (JavaCodeFragment)placeFile;
            JavaCodeFragment.VisibilityChecker visibilityChecker = fragment.getVisibilityChecker();
            if (visibilityChecker != null) {
                JavaCodeFragment.VisibilityChecker.Visibility visibility = visibilityChecker.isDeclarationVisible((PsiElement)member, place);
                if (visibility == JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE) {
                    return true;
                }
                if (visibility == JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE) {
                    return false;
                }
            }
        } else if (JavaResolveUtil.ignoreReferencedElementAccessibility(placeFile)) {
            return true;
        }
        if (accessObjectClass != null && !JavaResolveUtil.isAccessible((PsiMember)accessObjectClass, containingClass = accessObjectClass.getContainingClass(), accessObjectClass.getModifierList(), place, null, null, placeFile)) {
            return false;
        }
        PsiFile psiFile = file2 = placeFile == null ? null : FileContextUtil.getContextFile((PsiElement)placeFile);
        if (PsiImplUtil.isInServerPage((PsiElement)file2) && PsiImplUtil.isInServerPage((PsiElement)member.getContainingFile())) {
            return true;
        }
        int effectiveAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        if (JavaResolveUtil.ignoreReferencedElementAccessibility(file2) || effectiveAccessLevel == 4) {
            return true;
        }
        PsiManager manager = member.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (effectiveAccessLevel == 3) {
            if (facade.arePackagesTheSame((PsiElement)member, place)) {
                return true;
            }
            if (memberClass == null) {
                return false;
            }
            for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
                if (!(placeParent instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)placeParent), (PsiClass)memberClass, (boolean)true) || !(member instanceof PsiClass) && !modifierList.hasModifierProperty("static") && accessObjectClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)accessObjectClass, (PsiClass)((PsiClass)placeParent), (boolean)true)) continue;
                return true;
            }
            return false;
        }
        if (effectiveAccessLevel == 1) {
            if (memberClass == null) {
                return true;
            }
            if (accessObjectClass != null) {
                PsiClass topAccessClass;
                PsiClass topMemberClass = JavaResolveUtil.getTopLevelClass((PsiElement)memberClass, accessObjectClass);
                if (!manager.areElementsEquivalent((PsiElement)topMemberClass, (PsiElement)(topAccessClass = JavaResolveUtil.getTopLevelClass((PsiElement)accessObjectClass, memberClass)))) {
                    return false;
                }
                if (accessObjectClass instanceof PsiAnonymousClass && accessObjectClass.isInheritor(memberClass, true) && place instanceof PsiMethodCallExpression) {
                    return false;
                }
            }
            if (fileResolveScope == null) {
                PsiClass placeTopLevelClass = JavaResolveUtil.getTopLevelClass(place, null);
                PsiClass memberTopLevelClass = JavaResolveUtil.getTopLevelClass((PsiElement)memberClass, null);
                return manager.areElementsEquivalent((PsiElement)placeTopLevelClass, (PsiElement)memberTopLevelClass);
            }
            return fileResolveScope instanceof PsiClass && !((PsiClass)fileResolveScope).isInheritor(memberClass, true);
        }
        if (!facade.arePackagesTheSame((PsiElement)member, place)) {
            return false;
        }
        PsiClass placeClass = JavaResolveUtil.getContextClass(place);
        if (memberClass == null || placeClass == null) {
            return true;
        }
        if (memberClass.isInterface() || placeClass.isInterface()) {
            return true;
        }
        PsiClass psiClass = clazz = accessObjectClass != null ? accessObjectClass : placeClass.getSuperClass();
        if (clazz != null && clazz.isInheritor(memberClass, true)) {
            PsiClass superClass = clazz;
            while (!manager.areElementsEquivalent((PsiElement)superClass, (PsiElement)memberClass)) {
                if (superClass == null || !facade.arePackagesTheSame((PsiElement)superClass, (PsiElement)memberClass)) {
                    return false;
                }
                superClass = superClass.getSuperClass();
            }
        }
        return true;
    }

    private static boolean ignoreReferencedElementAccessibility(PsiFile placeFile) {
        return placeFile instanceof FileResolveScopeProvider && ((FileResolveScopeProvider)placeFile).ignoreReferencedElementAccessibility() && !PsiImplUtil.isInServerPage((PsiElement)placeFile);
    }

    public static boolean isInJavaDoc(PsiElement place) {
        for (PsiElement scope = place; scope != null; scope = scope.getContext()) {
            if (scope instanceof PsiDocComment) {
                return true;
            }
            if (!(scope instanceof PsiMember) && !(scope instanceof PsiMethodCallExpression) && !(scope instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    private static PsiClass getTopLevelClass(@NotNull PsiElement place, PsiClass memberClass) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "getTopLevelClass"));
        }
        PsiClass lastClass = null;
        Boolean isAtLeast17 = null;
        for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
            if (!(placeParent instanceof PsiClass) || placeParent instanceof PsiAnonymousClass) continue;
            boolean isTypeParameter = placeParent instanceof PsiTypeParameter;
            if (isTypeParameter && isAtLeast17 == null) {
                isAtLeast17 = JavaVersionService.getInstance().isAtLeast(placeParent, JavaSdkVersion.JDK_1_7);
            }
            if (isTypeParameter && !isAtLeast17.booleanValue()) continue;
            PsiClass aClass = (PsiClass)placeParent;
            if (memberClass != null && aClass.isInheritor(memberClass, true)) {
                return aClass;
            }
            lastClass = aClass;
        }
        return lastClass;
    }

    public static boolean processImplicitlyImportedPackages(PsiScopeProcessor processor2, ResolveState state, PsiElement place, PsiManager manager) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
        if (defaultPackage != null && !defaultPackage.processDeclarations(processor2, state, null, place)) {
            return false;
        }
        PsiPackage langPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("java.lang");
        return langPackage == null || langPackage.processDeclarations(processor2, state, null, place);
    }

    public static void substituteResults(final @NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult[] result2) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "substituteResults"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "substituteResults"));
        }
        if (result2.length > 0 && result2[0].getElement() instanceof PsiClass) {
            for (int i = 0; i < result2.length; ++i) {
                CandidateInfo resolveResult = (CandidateInfo)result2[i];
                final PsiElement resultElement = resolveResult.getElement();
                if (!(resultElement instanceof PsiClass) || !((PsiClass)resultElement).hasTypeParameters()) continue;
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                result2[i] = new CandidateInfo(resolveResult, substitutor){

                    @NotNull
                    public PsiSubstitutor getSubstitutor() {
                        PsiType[] parameters = ref.getTypeParameters();
                        PsiSubstitutor psiSubstitutor = super.getSubstitutor().putAll((PsiClass)resultElement, parameters);
                        if (psiSubstitutor == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/JavaResolveUtil$1", "getSubstitutor"));
                        }
                        return psiSubstitutor;
                    }
                };
            }
        }
    }

    @NotNull
    public static <T extends PsiPolyVariantReference> JavaResolveResult[] resolveWithContainingFile(@NotNull T ref, @NotNull ResolveCache.PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "resolveWithContainingFile"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "resolveWithContainingFile"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "resolveWithContainingFile"));
        }
        boolean valid = containingFile.isValid();
        if (!valid) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "resolveWithContainingFile"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        Project project = containingFile.getProject();
        ResolveResult[] results = ResolveCache.getInstance(project).resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, containingFile);
        JavaResolveResult[] javaResolveResultArray = results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/JavaResolveUtil", "resolveWithContainingFile"));
        }
        return javaResolveResultArray;
    }
}

