/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class InvertBooleanHandler
implements RefactoringActionHandler {
    public static final String INVERT_BOOLEAN_HELP_ID = "refactoring.invertBoolean";
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"invert.boolean.title");
    private static final Logger LOG = Logger.getInstance((String)("#" + InvertBooleanHandler.class.getName()));

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/invertBoolean/InvertBooleanHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiElement namedElement = InvertBooleanHandler.adjustElement(element, project, editor);
        if (namedElement == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)REFACTORING_NAME, (String)INVERT_BOOLEAN_HELP_ID);
            return;
        }
        new InvertBooleanDialog(namedElement).show();
    }

    public static PsiElement adjustElement(PsiElement element, Project project, Editor editor) {
        for (InvertBooleanDelegate delegate : (InvertBooleanDelegate[])Extensions.getExtensions(InvertBooleanDelegate.EP_NAME)) {
            if (!delegate.isVisibleOnElement(element)) continue;
            return delegate.adjustElement(element, project, editor);
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/invertBoolean/InvertBooleanHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/invertBoolean/InvertBooleanHandler", "invoke"));
        }
        LOG.assertTrue(elements.length == 1);
        PsiElement element = InvertBooleanHandler.adjustElement(elements[0], project, null);
        if (element == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)REFACTORING_NAME, (String)INVERT_BOOLEAN_HELP_ID);
            return;
        }
        new InvertBooleanDialog(element).show();
    }
}

