/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImpl;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SSBasedInspection
extends LocalInspectionTool {
    private static final Object LOCK = new Object();
    static final String SHORT_NAME = "SSBasedInspection";
    private List<Configuration> myConfigurations = new ArrayList<Configuration>();
    private final Set<String> myProblemsReported = new HashSet<String>(1);

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "writeSettings"));
        }
        ConfigurationManager.writeConfigurations(node, this.myConfigurations, Collections.<Configuration>emptyList());
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "readSettings"));
        }
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        ConfigurationManager.readConfigurations(node, this.myConfigurations, new ArrayList<Configuration>());
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = SSRBundle.message("SSRInspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "buildVisitor"));
        }
        final MatcherImpl.CompiledOptions compiledOptions = SSBasedInspectionCompiledPatternsCache.getCompiledOptions(holder.getProject());
        if (compiledOptions == null) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){
            final List<Pair<MatchContext, Configuration>> contexts;
            final Matcher matcher;
            final PairProcessor<MatchResult, Configuration> processor;
            {
                this.contexts = compiledOptions.getMatchContexts();
                this.matcher = new Matcher(holder.getManager().getProject());
                this.processor = new PairProcessor<MatchResult, Configuration>(){

                    public boolean process(MatchResult matchResult, Configuration configuration) {
                        PsiElement element = matchResult.getMatch();
                        String name = configuration.getName();
                        LocalQuickFix fix = SSBasedInspection.createQuickFix(holder.getManager().getProject(), matchResult, configuration);
                        holder.registerProblem(holder.getManager().createProblemDescriptor(element, name, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                        return true;
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitElement(PsiElement element) {
                Object object = LOCK;
                synchronized (object) {
                    if (LexicalNodesFilter.getInstance().accepts(element)) {
                        return;
                    }
                    SsrFilteringNodeIterator matchedNodes = new SsrFilteringNodeIterator(element);
                    for (Pair<MatchContext, Configuration> pair : this.contexts) {
                        block7: {
                            Configuration configuration = (Configuration)pair.second;
                            MatchContext context = (MatchContext)pair.first;
                            if (!MatcherImpl.checkIfShouldAttemptToMatch(context, matchedNodes)) continue;
                            int nodeCount = context.getPattern().getNodeCount();
                            try {
                                this.matcher.processMatchesInElement(context, configuration, new CountingNodeIterator(nodeCount, matchedNodes), this.processor);
                            }
                            catch (StructuralSearchException e) {
                                if (!SSBasedInspection.this.myProblemsReported.add(configuration.getName())) break block7;
                                Notifications.Bus.notify((Notification)new Notification(SSRBundle.message("structural.search.title", new Object[0]), SSRBundle.message("template.problem", configuration.getName()), e.getMessage(), NotificationType.ERROR), (Project)element.getProject());
                            }
                        }
                        matchedNodes.reset();
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static LocalQuickFix createQuickFix(Project project, MatchResult matchResult, Configuration configuration) {
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)configuration;
        final Replacer replacer = new Replacer(project, replaceConfiguration.getOptions());
        final ReplacementInfo replacementInfo = replacer.buildReplacement(matchResult);
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SSRBundle.message("SSRInspection.replace.with", replacementInfo.getReplacement());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$2", "getName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$2", "applyFix"));
                }
                PsiElement element = descriptor.getPsiElement();
                if (element != null && FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
                    replacer.replace(replacementInfo);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = SSRBundle.message("SSRInspection.family.name", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/highlightTemplate/SSBasedInspection$2", "getFamilyName"));
                }
                return string;
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SSBasedInspectionOptions(this.myConfigurations){

            @Override
            public void configurationsChanged(SearchContext searchContext) {
                super.configurationsChanged(searchContext);
                SSBasedInspectionCompiledPatternsCache.precompileConfigurations(searchContext.getProject(), SSBasedInspection.this);
                InspectionProfileManager.getInstance().fireProfileChanged(null);
            }
        }.getComponent();
    }

    public void setConfigurations(List<Configuration> configurations, Project project) {
        this.myConfigurations = configurations;
        SSBasedInspectionCompiledPatternsCache.setCompiledOptions(project, configurations);
    }

    public List<Configuration> getConfigurations() {
        return this.myConfigurations;
    }
}

