/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public class BalloonLayoutImpl
implements BalloonLayout {
    private final JLayeredPane myLayeredPane;
    private final Insets myInsets;
    private final List<Balloon> myBalloons;
    private final Alarm myRelayoutAlarm;
    private final Runnable myRelayoutRunnable;
    private final JRootPane myParent;

    public BalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        if (insets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        this.myBalloons = new ArrayList<Balloon>();
        this.myRelayoutAlarm = new Alarm();
        this.myRelayoutRunnable = new Runnable(){

            @Override
            public void run() {
                BalloonLayoutImpl.this.relayout();
            }
        };
        this.myParent = parent;
        this.myLayeredPane = parent.getLayeredPane();
        this.myInsets = insets;
        this.myLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/BalloonLayoutImpl$2", "componentResized"));
                }
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
    }

    public void add(final Balloon balloon) {
        this.myBalloons.add(balloon);
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                BalloonLayoutImpl.this.myBalloons.remove(balloon);
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
        this.relayout();
        balloon.show(this.myLayeredPane);
    }

    public boolean isEmpty() {
        return this.myBalloons.isEmpty();
    }

    public void queueRelayout() {
        this.myRelayoutAlarm.cancelAllRequests();
        this.myRelayoutAlarm.addRequest(this.myRelayoutRunnable, 200);
    }

    private void relayout() {
        Dimension size = this.myLayeredPane.getSize();
        JBInsets.removeFrom((Dimension)size, (Insets)this.myInsets);
        Rectangle layoutRec = new Rectangle(new Point(this.myInsets.left, this.myInsets.top), size);
        List<ArrayList<Balloon>> columns = this.createColumns(layoutRec);
        while (columns.size() > 1) {
            this.myBalloons.remove(0);
            columns = this.createColumns(layoutRec);
        }
        List<Integer> columnWidths = BalloonLayoutImpl.computeWidths(columns);
        ToolWindowsPane pane = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        Object component = pane != null ? pane : this.myParent;
        int paneOnScreen = ((Component)component).isShowing() ? ((Component)component).getLocationOnScreen().y : 0;
        int layerOnScreen = this.myLayeredPane.isShowing() ? this.myLayeredPane.getLocationOnScreen().y : 0;
        int toolbarsOffset = paneOnScreen - layerOnScreen;
        JComponent layeredPane = pane != null ? pane.getMyLayeredPane() : null;
        int eachColumnX = (layeredPane == null ? this.myLayeredPane.getWidth() : layeredPane.getX() + layeredPane.getWidth()) - 4;
        for (int i = 0; i < columns.size(); ++i) {
            ArrayList<Balloon> eachColumn = columns.get(i);
            Integer eachWidth = columnWidths.get(i);
            eachColumnX -= eachWidth.intValue();
            int eachY = toolbarsOffset + 2;
            for (Balloon eachBalloon : eachColumn) {
                Rectangle eachRec = new Rectangle();
                Dimension eachPrefSize = eachBalloon.getPreferredSize();
                eachRec.setSize(eachPrefSize);
                if (((BalloonImpl)eachBalloon).hasShadow()) {
                    int shadowSize = ((BalloonImpl)eachBalloon).getShadowBorderSize();
                    eachRec.width += 2 * shadowSize;
                    eachRec.height += 2 * shadowSize;
                }
                eachRec.setLocation(eachColumnX + eachWidth - eachRec.width, eachY += 2);
                eachBalloon.setBounds(eachRec);
                eachY += eachRec.height;
            }
        }
    }

    private static List<Integer> computeWidths(List<ArrayList<Balloon>> columns) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (ArrayList<Balloon> eachColumn : columns) {
            int maxWidth = 0;
            for (Balloon each : eachColumn) {
                maxWidth = Math.max(each.getPreferredSize().width, maxWidth);
            }
            columnWidths.add(maxWidth);
        }
        return columnWidths;
    }

    private List<ArrayList<Balloon>> createColumns(Rectangle layoutRec) {
        ArrayList<ArrayList<Balloon>> columns = new ArrayList<ArrayList<Balloon>>();
        ArrayList<Balloon> eachColumn = new ArrayList<Balloon>();
        columns.add(eachColumn);
        int eachColumnHeight = 0;
        for (Balloon each : this.myBalloons) {
            Dimension eachSize = each.getPreferredSize();
            if ((double)(eachColumnHeight + eachSize.height) > layoutRec.getHeight()) {
                eachColumn = new ArrayList();
                columns.add(eachColumn);
                eachColumnHeight = 0;
            }
            eachColumn.add(each);
            eachColumnHeight += eachSize.height;
        }
        return columns;
    }
}

