/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class MergingBackgroundExecutor<T> {
    private static final Logger LOG = Logger.getInstance(MergingBackgroundExecutor.class);
    private final int myMaxThreads;
    private final Consumer<T> myConsumer;
    private final BlockingQueue<T> myQueue;
    private final AtomicInteger myRunningThreads;

    public MergingBackgroundExecutor(int maxThreads, @NotNull Consumer<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergingBackgroundExecutor", "<init>"));
        }
        this.myQueue = new LinkedBlockingDeque<T>();
        this.myRunningThreads = new AtomicInteger(0);
        this.myMaxThreads = maxThreads;
        this.myConsumer = consumer;
    }

    protected void executeOnPooledThread(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/MergingBackgroundExecutor", "executeOnPooledThread"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
    }

    public void queue(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/MergingBackgroundExecutor", "queue"));
        }
        if (!this.myQueue.offer(t)) {
            LOG.error("Unable to enqueue an element, queue size: " + this.myQueue.size());
            return;
        }
        if (MergingBackgroundExecutor.incrementIfSmaller(this.myRunningThreads, this.myMaxThreads)) {
            this.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    do {
                        try {
                            MergingBackgroundExecutor.this.processQueue();
                        }
                        finally {
                            MergingBackgroundExecutor.this.myRunningThreads.decrementAndGet();
                        }
                    } while (!MergingBackgroundExecutor.this.myQueue.isEmpty() && MergingBackgroundExecutor.incrementIfSmaller(MergingBackgroundExecutor.this.myRunningThreads, MergingBackgroundExecutor.this.myMaxThreads));
                }
            });
        }
    }

    private static boolean incrementIfSmaller(@NotNull AtomicInteger i, int max) {
        int value;
        if (i == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "com/intellij/util/MergingBackgroundExecutor", "incrementIfSmaller"));
        }
        do {
            if ((value = i.get()) < max) continue;
            return false;
        } while (!i.compareAndSet(value, value + 1));
        return true;
    }

    private void processQueue() {
        Object t;
        while ((t = this.myQueue.poll()) != null) {
            this.myConsumer.consume(t);
        }
    }

    @NotNull
    public static MergingBackgroundExecutor<Runnable> newRunnableExecutor(int maxThreads) {
        MergingBackgroundExecutor<Runnable> mergingBackgroundExecutor = new MergingBackgroundExecutor<Runnable>(maxThreads, new Consumer<Runnable>(){

            public void consume(Runnable runnable2) {
                runnable2.run();
            }
        });
        if (mergingBackgroundExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MergingBackgroundExecutor", "newRunnableExecutor"));
        }
        return mergingBackgroundExecutor;
    }
}

