/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PrefixlessWebServerRootsProvider;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0011\u0001A\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)S\u0002B\u0006\t\u00045\u0011A\u0012\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011)\u0013\u0003B\u0006\t\n5\u0011A\u0012\u0001\r\u00033\rAQ!D\u0001\u0019\fe\u0019\u0001rA\u0007\u00021\u0011I2\u0001\u0003\u0004\u000e\u0003a5\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/PrefixlessWebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;"}, moduleName="compiler-impl")
public final class ArtifactWebServerRootsProvider
extends PrefixlessWebServerRootsProvider {
    @Override
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project, @NotNull FileResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)project).getArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            VirtualFile root;
            Artifact artifact = artifactArray[i];
            VirtualFile virtualFile = artifact.getOutputFile();
            if (virtualFile == null) {
                continue;
            }
            VirtualFile virtualFile2 = root = virtualFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"root");
            return FileResolver.DefaultImpls.resolve$default(resolver, path, virtualFile2, null, false, 12);
        }
        return null;
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)project).getArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            VirtualFile root;
            Artifact artifact = artifactArray[i];
            if (artifact.getOutputFile() == null) {
                continue;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)true)) continue;
            File file3 = null;
            VirtualFile virtualFile = root;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
            return new PathInfo(file3, file2, virtualFile, null, false, 24, null);
        }
        return null;
    }
}

