/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBufUtf8Writer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.IntRange;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiConditional;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiFsize;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiProcessorKt;
import org.jetbrains.builtInWebServer.ssi.SsiStopProcessingException;
import org.jetbrains.builtInWebServer.ssi.Strftime;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"e\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011K)\u0011\u0001C\u0004\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AI\"\u0002\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005Aa!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001#B\u0001\u0005\u0003\u0015\t\u0001\u0012C\u0003\u0002\t\u0007)\u0011\u0001#\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tA\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Q\u0005\u0005\u0003\u0003\u0011\u0013i\u0011\u0001g\u0001\u001a\u0007!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u000f)\u0003\u0002\u0002\u0002\t\u00105\t\u00014A\r\u0004\u0011!i\u0011\u0001'\u0005&\u0011\u0011\u0011\u0001\"C\u0007\u00021\u0007I2\u0001\u0003\u0005\u000e\u0003aEQ\u0005\u0003\u0003\u0002\u0011'i\u0011\u0001g\u0002\u001a\u0007!QQ\"\u0001M\u000bK=!!\u0001C\u0006\u000e\t%\u0011\u0011\"\u0001M\u00041/I2\u0001C\u0004\u000e\u0003aU\u0011d\u0001\u0005\r\u001b\u0005Aj!*\f\u0005\u0006!eQ\"B\u0005\u0003\u0013\u0005A:\u0001$\u0001\u0019\u001be\u0019\u0001bB\u0007\u00021+I2\u0001\u0003\u0007\u000e\u0003a5\u0011d\u0001E\u000e\u001b\u0005Aj!U\u0002\u0002\u00119)s\u0002#\b\u000e\u0003ay\u0011d\u0001E\u0010\u001b\u0005A\u0002#G\u0002\t\"5\t\u0001$E\r\u0004\u0011Gi\u0011\u0001\u0007\n*\u001b\u0011\t\u0005\u0002#\u0002\u000e\u000f%\u0011\u0011\"\u0001M\u0004\u0013\tI\u0011\u0001\u0007\u0003\u0019\u0007E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "", "allowExec", "", "(Z)V", "commands", "", "", "Lorg/jetbrains/builtInWebServer/ssi/SsiCommand;", "charCmp", "buf", "", "index", "", "command", "isQuote", "c", "", "isSpace", "parseCommand", "instruction", "Ljava/lang/StringBuilder;", "parseParamNames", "", "start", "parseParamValues", "", "count", "(Ljava/lang/StringBuilder;II)[Ljava/lang/String;", "process", "", "ssiExternalResolver", "Lorg/jetbrains/builtInWebServer/ssi/SsiExternalResolver;", "file", "Ljava/io/File;", "writer", "Lio/netty/buffer/ByteBufUtf8Writer;"}, moduleName="built-in-server")
public final class SsiProcessor {
    private final Map<String, SsiCommand> commands = (Map)new THashMap();

    public final long process(@NotNull SsiExternalResolver ssiExternalResolver, @NotNull File file2, @NotNull ByteBufUtf8Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)ssiExternalResolver, (String)"ssiExternalResolver");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        char[] fileContents = FileUtilRt.loadFileText((File)file2);
        long lastModifiedDate = file2.lastModified();
        SsiProcessingState ssiProcessingState = new SsiProcessingState(ssiExternalResolver, lastModifiedDate);
        int index = 0;
        boolean inside = false;
        StringBuilder command = new StringBuilder();
        writer.ensureWritable((int)file2.length());
        try {
            while (index < fileContents.length) {
                char c = fileContents[index];
                if (inside) {
                    if (c == SsiProcessorKt.getCOMMAND_END().charAt(0)) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileContents, (String)"fileContents");
                        if (this.charCmp(fileContents, index, SsiProcessorKt.getCOMMAND_END())) {
                            long newLastModified;
                            inside = false;
                            index += SsiProcessorKt.getCOMMAND_END().length();
                            String commandName = this.parseCommand(command);
                            if (SsiProcessorKt.getLOG().isDebugEnabled()) {
                                SsiProcessorKt.getLOG().debug("SSIProcessor.process -- processing command: " + commandName);
                            }
                            List<String> paramNames = this.parseParamNames(command, commandName.length());
                            String[] paramValues = this.parseParamValues(command, commandName.length(), paramNames.size());
                            String configErrMsg = ssiProcessingState.configErrorMessage;
                            Locale locale = Locale.ENGLISH;
                            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                            SsiCommand ssiCommand = this.commands.get(StringsKt.toLowerCase((String)commandName, (Locale)locale));
                            String errorMessage = null;
                            if (ssiCommand == null) {
                                errorMessage = "Unknown command: " + commandName;
                            } else if (paramValues == null) {
                                errorMessage = "Error parsing directive parameters.";
                            } else if (paramNames.size() != ((Object[])paramValues).length) {
                                errorMessage = "Parameter names count does not match parameter values count on command: " + commandName;
                            } else if ((!ssiProcessingState.conditionalState.processConditionalCommandsOnly || ssiCommand instanceof SsiConditional) && (newLastModified = ssiCommand.process(ssiProcessingState, commandName, paramNames, paramValues, writer)) > lastModifiedDate) {
                                lastModifiedDate = newLastModified;
                            }
                            if (errorMessage == null) continue;
                            SsiProcessorKt.getLOG().warn(errorMessage);
                            writer.write(configErrMsg);
                            continue;
                        }
                    }
                    command.append(c);
                    ++index;
                    continue;
                }
                if (c == SsiProcessorKt.getCOMMAND_START().charAt(0)) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileContents, (String)"fileContents");
                    if (this.charCmp(fileContents, index, SsiProcessorKt.getCOMMAND_START())) {
                        inside = true;
                        index += SsiProcessorKt.getCOMMAND_START().length();
                        command.setLength(0);
                        continue;
                    }
                }
                if (!ssiProcessingState.conditionalState.processConditionalCommandsOnly) {
                    writer.append(c);
                }
                ++index;
            }
        }
        catch (SsiStopProcessingException e) {
            // empty catch block
        }
        return lastModifiedDate;
    }

    @NotNull
    protected final List<String> parseParamNames(@NotNull StringBuilder command, int start) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        int bIdx = start;
        SmartList values = new SmartList();
        boolean inside = false;
        StringBuilder builder = new StringBuilder();
        while (bIdx < command.length()) {
            if (inside) {
                while (bIdx < command.length() && command.charAt(bIdx) != '=') {
                    builder.append(command.charAt(bIdx));
                    ++bIdx;
                }
                values.add((Object)builder.toString());
                builder.setLength(0);
                inside = false;
                int quotes = 0;
                boolean escaped = false;
                while (bIdx < command.length() && quotes != 2) {
                    char c = command.charAt(bIdx);
                    if (c == '\\' && !escaped) {
                        escaped = true;
                        ++bIdx;
                        continue;
                    }
                    if (c == '\"' && !escaped) {
                        ++quotes;
                    }
                    escaped = false;
                    ++bIdx;
                }
                continue;
            }
            while (bIdx < command.length() && this.isSpace(command.charAt(bIdx))) {
                ++bIdx;
            }
            if (bIdx >= command.length()) break;
            inside = true;
        }
        return (List)values;
    }

    @Nullable
    protected final String[] parseParamValues(@NotNull StringBuilder command, int start, int count) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        int valueIndex = 0;
        boolean inside = false;
        String[] values = new String[count];
        StringBuilder builder = new StringBuilder();
        char endQuote = (char)0;
        for (int bIdx = start; bIdx < command.length(); ++bIdx) {
            if (!inside) {
                while (bIdx < command.length() && !this.isQuote(command.charAt(bIdx))) {
                    ++bIdx;
                }
                if (bIdx >= command.length()) break;
                inside = true;
                endQuote = command.charAt(bIdx);
                continue;
            }
            boolean escaped = false;
            while (bIdx < command.length()) {
                char c = command.charAt(bIdx);
                if (c == '\\' && !escaped) {
                    escaped = true;
                    ++bIdx;
                    continue;
                }
                if (c == endQuote && !escaped) break;
                if (c == '$' && escaped) {
                    builder.append('\\');
                }
                escaped = false;
                builder.append(c);
                ++bIdx;
            }
            if (bIdx == command.length()) {
                return null;
            }
            values[valueIndex++] = builder.toString();
            builder.setLength(0);
            inside = false;
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseCommand(StringBuilder instruction) {
        int firstLetter = -1;
        int lastLetter = -1;
        int n = 0;
        int n2 = instruction.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                char c;
                if (Character.isLetter(c = instruction.charAt((int)i))) {
                    if (firstLetter == -1) {
                        firstLetter = i;
                    }
                    lastLetter = i;
                } else if (!this.isSpace(c) || lastLetter > -1) break;
                if (i == n2) break;
                ++i;
            }
        }
        return firstLetter == -1 ? "" : instruction.substring(firstLetter, lastLetter + 1);
    }

    protected final boolean charCmp(@NotNull char[] buf, int index, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return CharArrayUtil.regionMatches((char[])buf, (int)index, (int)(index + command.length()), (CharSequence)command);
    }

    protected final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    protected final boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    public SsiProcessor(boolean allowExec) {
        this.commands.put("config", new SsiCommand(){

            /*
             * WARNING - void declaration
             */
            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
                Intrinsics.checkParameterIsNotNull(paramNames, (String)"paramNames");
                Intrinsics.checkParameterIsNotNull((Object)paramValues, (String)"paramValues");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                IntRange intRange = CollectionsKt.getIndices((Collection)paramNames);
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                if (n <= n2) {
                    while (true) {
                        void i;
                        String paramName = paramNames.get((int)i);
                        String paramValue = paramValues[i];
                        String substitutedValue = state.substituteVariables(paramValue);
                        if (StringsKt.equals((String)paramName, (String)"errmsg", (boolean)true)) {
                            state.configErrorMessage = substitutedValue;
                        } else if (StringsKt.equals((String)paramName, (String)"sizefmt", (boolean)true)) {
                            state.configSizeFmt = substitutedValue;
                        } else if (StringsKt.equals((String)paramName, (String)"timefmt", (boolean)true)) {
                            state.setConfigTimeFormat(substitutedValue, false);
                        } else {
                            SsiProcessorKt.getLOG().info("#config--Invalid attribute: " + paramName);
                            writer.write(state.configErrorMessage);
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                return 0L;
            }
        });
        this.commands.put("echo", new SsiCommand(){

            /*
             * WARNING - void declaration
             */
            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                String variableValue;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
                Intrinsics.checkParameterIsNotNull(paramNames, (String)"paramNames");
                Intrinsics.checkParameterIsNotNull((Object)paramValues, (String)"paramValues");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                String encoding = "entity";
                String originalValue = null;
                String errorMessage = state.configErrorMessage;
                IntRange intRange = CollectionsKt.getIndices((Collection)paramNames);
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                if (n <= n2) {
                    while (true) {
                        void i;
                        String paramName = paramNames.get((int)i);
                        String paramValue = paramValues[i];
                        if (StringsKt.equals((String)paramName, (String)"var", (boolean)true)) {
                            originalValue = paramValue;
                        } else if (StringsKt.equals((String)paramName, (String)"encoding", (boolean)true)) {
                            if (StringsKt.equals((String)paramValue, (String)"url", (boolean)true) || StringsKt.equals((String)paramValue, (String)"entity", (boolean)true) || StringsKt.equals((String)paramValue, (String)"none", (boolean)true)) {
                                encoding = paramValue;
                            } else {
                                SsiProcessorKt.getLOG().info("#echo--Invalid encoding: " + paramValue);
                                writer.write(errorMessage);
                            }
                        } else {
                            SsiProcessorKt.getLOG().info("#echo--Invalid attribute: " + paramName);
                            writer.write(errorMessage);
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                String string2 = originalValue;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((string = (variableValue = state.getVariableValue(string2, encoding))) == null) {
                    string = "(none)";
                }
                writer.write(string);
                return System.currentTimeMillis();
            }
        });
        this.commands.put("include", new SsiCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
                Intrinsics.checkParameterIsNotNull(paramNames, (String)"paramNames");
                Intrinsics.checkParameterIsNotNull((Object)paramValues, (String)"paramValues");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                long lastModified = 0L;
                String configErrorMessage = state.configErrorMessage;
                IntRange intRange = CollectionsKt.getIndices((Collection)paramNames);
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                if (n <= n2) {
                    while (true) {
                        void i;
                        String paramName;
                        if (StringsKt.equals((String)(paramName = paramNames.get((int)i)), (String)"file", (boolean)true) || StringsKt.equals((String)paramName, (String)"virtual", (boolean)true)) {
                            String substitutedValue = state.substituteVariables(paramValues[i]);
                            try {
                                boolean virtual = StringsKt.equals((String)paramName, (String)"virtual", (boolean)true);
                                lastModified = state.ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                                File file2 = state.ssiExternalResolver.findFile(substitutedValue, virtual);
                                if (file2 == null) {
                                    SsiProcessorKt.getLOG().warn("#include-- Couldn't find file: " + substitutedValue);
                                    return 0L;
                                }
                                FileInputStream in = new FileInputStream(file2);
                                try {
                                    writer.write(in, (int)file2.length());
                                }
                                finally {
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                SsiProcessorKt.getLOG().warn("#include--Couldn't include file: " + substitutedValue, (Throwable)e);
                                writer.write(configErrorMessage);
                            }
                        } else {
                            SsiProcessorKt.getLOG().info("#include--Invalid attribute: " + paramName);
                            writer.write(configErrorMessage);
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                return lastModified;
            }
        });
        this.commands.put("flastmod", new SsiCommand(){

            /*
             * WARNING - void declaration
             */
            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
                Intrinsics.checkParameterIsNotNull(paramNames, (String)"paramNames");
                Intrinsics.checkParameterIsNotNull((Object)paramValues, (String)"paramValues");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                long lastModified = 0L;
                String configErrMsg = state.configErrorMessage;
                IntRange intRange = CollectionsKt.getIndices((Collection)paramNames);
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                if (n <= n2) {
                    while (true) {
                        void i;
                        String paramName = paramNames.get((int)i);
                        String paramValue = paramValues[i];
                        String substitutedValue = state.substituteVariables(paramValue);
                        if (StringsKt.equals((String)paramName, (String)"file", (boolean)true) || StringsKt.equals((String)paramName, (String)"virtual", (boolean)true)) {
                            boolean virtual = StringsKt.equals((String)paramName, (String)"virtual", (boolean)true);
                            lastModified = state.ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                            Strftime strftime = new Strftime(state.configTimeFmt, Locale.US);
                            writer.write(strftime.format(new Date(lastModified)));
                        } else {
                            SsiProcessorKt.getLOG().info("#flastmod--Invalid attribute: " + paramName);
                            writer.write(configErrMsg);
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                return lastModified;
            }
        });
        this.commands.put("fsize", new SsiFsize());
        this.commands.put("printenv", new SsiCommand(){

            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
                Intrinsics.checkParameterIsNotNull(paramNames, (String)"paramNames");
                Intrinsics.checkParameterIsNotNull((Object)paramValues, (String)"paramValues");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                long lastModified = 0L;
                if (paramNames.isEmpty()) {
                    LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
                    variableNames.add("DATE_GMT");
                    variableNames.add("DATE_LOCAL");
                    variableNames.add("LAST_MODIFIED");
                    state.ssiExternalResolver.addVariableNames((Collection<String>)variableNames);
                    for (String variableName : variableNames) {
                        String variableValue = state.getVariableValue(variableName);
                        if (variableValue == null) {
                            variableValue = "(none)";
                        }
                        writer.append(variableName).append('=').append(variableValue).append('\n');
                        lastModified = System.currentTimeMillis();
                    }
                } else {
                    writer.write(state.configErrorMessage);
                }
                return lastModified;
            }
        });
        this.commands.put("set", new SsiCommand(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
                Intrinsics.checkParameterIsNotNull(paramNames, (String)"paramNames");
                Intrinsics.checkParameterIsNotNull((Object)paramValues, (String)"paramValues");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                long lastModified = 0L;
                String errorMessage = state.configErrorMessage;
                String variableName = null;
                IntRange intRange = CollectionsKt.getIndices((Collection)paramNames);
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                if (n <= n2) {
                    while (true) {
                        void i;
                        String paramName = paramNames.get((int)i);
                        String paramValue = paramValues[i];
                        if (StringsKt.equals((String)paramName, (String)"var", (boolean)true)) {
                            variableName = paramValue;
                        } else {
                            if (!StringsKt.equals((String)paramName, (String)"value", (boolean)true)) {
                                SsiProcessorKt.getLOG().info("#set--Invalid attribute: " + paramName);
                                writer.write(errorMessage);
                                throw (Throwable)new SsiStopProcessingException();
                            }
                            if (variableName == null) {
                                SsiProcessorKt.getLOG().info("#set--no variable specified");
                                writer.write(errorMessage);
                                throw (Throwable)new SsiStopProcessingException();
                            }
                            String substitutedValue = state.substituteVariables(paramValue);
                            state.ssiExternalResolver.setVariableValue(variableName, substitutedValue);
                            lastModified = System.currentTimeMillis();
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                return lastModified;
            }
        });
        SsiConditional ssiConditional = new SsiConditional();
        this.commands.put("if", ssiConditional);
        this.commands.put("elif", ssiConditional);
        this.commands.put("endif", ssiConditional);
        this.commands.put("else", ssiConditional);
    }
}

