/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.element;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.java.generate.element.AbstractElement;
import org.jetbrains.java.generate.element.ClassElement;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.element.MethodElement;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class ElementFactory {
    private static final Logger log = Logger.getInstance((String)"#ElementFactory");

    private ElementFactory() {
    }

    public static ClassElement newClassElement(PsiClass clazz) {
        ClassElement ce = new ClassElement();
        ce.setName(clazz.getName());
        ce.setQualifiedName(clazz.getQualifiedName());
        PsiClass superClass = clazz.getSuperClass();
        if (superClass != null && !"java.lang.Object".equals(superClass.getQualifiedName())) {
            ce.setSuperName(superClass.getName());
        }
        ce.setImplementNames(PsiAdapter.getImplementsClassnames(clazz));
        ce.setEnum(clazz.isEnum());
        ce.setDeprecated(clazz.isDeprecated());
        ce.setException(PsiAdapter.isExceptionClass(clazz));
        ce.setAbstract(clazz.hasModifierProperty("abstract"));
        ce.setTypeParams(clazz.getTypeParameters().length);
        return ce;
    }

    public static FieldElement newFieldElement(PsiField field, boolean useAccessor) {
        PsiModifierList modifiers;
        FieldElement fe = new FieldElement();
        fe.setName(field.getName());
        PsiMethod getterForField = useAccessor ? PropertyUtil.findGetterForField((PsiField)field) : null;
        fe.setAccessor(getterForField != null ? getterForField.getName() + "()" : field.getName());
        if (PsiAdapter.isConstantField(field)) {
            fe.setConstant(true);
        }
        if (PsiAdapter.isEnumField(field)) {
            fe.setEnum(true);
        }
        if ((modifiers = field.getModifierList()) != null) {
            if (modifiers.hasModifierProperty("transient")) {
                fe.setModifierTransient(true);
            }
            if (modifiers.hasModifierProperty("volatile")) {
                fe.setModifierVolatile(true);
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)field.getProject()).getElementFactory();
        PsiType type = field.getType();
        ElementFactory.setElementInfo(fe, factory, type, modifiers);
        return fe;
    }

    public static MethodElement newMethodElement(PsiMethod method) {
        MethodElement me = new MethodElement();
        PsiType type = method.getReturnType();
        PsiModifierList modifiers = method.getModifierList();
        if (type == null) {
            log.warn("This method does not have a valid return type: " + method.getName() + ", returnType=" + type);
            return me;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        ElementFactory.setElementInfo(me, factory, type, modifiers);
        String fieldName = PsiAdapter.getGetterFieldName(method);
        me.setName(fieldName == null ? method.getName() : fieldName);
        me.setFieldName(fieldName);
        me.setMethodName(method.getName());
        me.setGetter(PsiAdapter.isGetterMethod(method));
        me.setDeprecated(method.isDeprecated());
        me.setReturnTypeVoid(PsiAdapter.isTypeOfVoid(method.getReturnType()));
        if (modifiers.hasModifierProperty("abstract")) {
            me.setModifierAbstract(true);
        }
        if (modifiers.hasModifierProperty("synchronized")) {
            me.setModifierSynchronized(true);
        }
        return me;
    }

    private static void setElementInfo(AbstractElement element, PsiElementFactory factory, PsiType type, PsiModifierList modifiers) {
        element.setTypeName(PsiAdapter.getTypeClassName(type));
        element.setTypeQualifiedName(PsiAdapter.getTypeQualifiedClassName(type));
        element.setType(type.getCanonicalText());
        if (PsiAdapter.isObjectArrayType(type)) {
            element.setObjectArray(true);
            element.setArray(true);
            if (PsiAdapter.isStringArrayType(type)) {
                element.setStringArray(true);
            }
        } else if (PsiAdapter.isPrimitiveArrayType(type)) {
            element.setPrimitiveArray(true);
            element.setArray(true);
        }
        if (PsiAdapter.isCollectionType(factory, type)) {
            element.setCollection(true);
        }
        if (PsiAdapter.isListType(factory, type)) {
            element.setList(true);
        }
        if (PsiAdapter.isSetType(factory, type)) {
            element.setSet(true);
        }
        if (PsiAdapter.isMapType(factory, type)) {
            element.setMap(true);
        }
        if (PsiAdapter.isPrimitiveType(type)) {
            element.setPrimitive(true);
        }
        if (PsiAdapter.isObjectType(factory, type)) {
            element.setObject(true);
        }
        if (PsiAdapter.isStringType(factory, type)) {
            element.setString(true);
        }
        if (PsiAdapter.isNumericType(factory, type)) {
            element.setNumeric(true);
        }
        if (PsiAdapter.isDateType(factory, type)) {
            element.setDate(true);
        }
        if (PsiAdapter.isCalendarType(factory, type)) {
            element.setCalendar(true);
        }
        if (PsiAdapter.isBooleanType(factory, type)) {
            element.setBoolean(true);
        }
        if (PsiType.VOID.equals((Object)type)) {
            element.setVoid(true);
        }
        if (PsiType.LONG.equals((Object)type)) {
            element.setLong(true);
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            element.setFloat(true);
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            element.setDouble(true);
        }
        if (PsiType.BYTE.equals((Object)type)) {
            element.setByte(true);
        }
        if (PsiType.CHAR.equals((Object)type)) {
            element.setChar(true);
        }
        if (PsiType.SHORT.equals((Object)type)) {
            element.setShort(true);
        }
        element.setNestedArray(PsiAdapter.isNestedArray(type));
        if (modifiers != null) {
            if (modifiers.hasModifierProperty("static")) {
                element.setModifierStatic(true);
            }
            if (modifiers.hasModifierProperty("final")) {
                element.setModifierFinal(true);
            }
            if (modifiers.hasModifierProperty("public")) {
                element.setModifierPublic(true);
            } else if (modifiers.hasModifierProperty("protected")) {
                element.setModifierProtected(true);
            } else if (modifiers.hasModifierProperty("packageLocal")) {
                element.setModifierPackageLocal(true);
            } else if (modifiers.hasModifierProperty("private")) {
                element.setModifierPrivate(true);
            }
        }
    }
}

