/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\t\u000e\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005Aa!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0002\t\u0007!1\u0003\u0004\u0001\u001a\u0003a\u0005Q4a\u0007\u000f\u001e\u0005\u0016\u0011kA\u0001\t\u0003\u0015zA!\u0001\u0005\n\u001b\u0005A\u001a\"\u0007\u0004\t\u00155!\u0011BA\u0005\u00021'A\"!G\u0002\t\u00165\t\u00014C\u0013\b\u0011-i\u0011\u0001g\u0006\u001a\u0007!aQ\"\u0001M\nK\u0011!!\u0001#\u0007\u000e\u0003ai\u0011\u0006\u0004\u0003T\u0011!\rQ\u0002B\u0005\u0003\u0013\u0005A*\u0001\u0007\u0002R\u0007\ri!\u0001B\u0002\t\b%bAa\u0015\u0005\t\t5!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0004\u001b\t!I\u0001c\u0002*\u0013\u0011\u0019\u0006\u0002C\u0003\u000e\u0003a-\u0011kA\u0002\u000e\u0005\u00111\u0001RB\u0015\n\tMC\u0001bB\u0007\u00021\u001f\t6aA\u0007\u0003\t!A\t\u0002"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "", "()V", "cachedTokens", "", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "getCachedTokens", "()Ljava/util/List;", "filteredTokens", "getFilteredTokens", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "originalTextRange", "Lkotlin/IntRange;", "getOriginalTextRange", "()Lkotlin/IntRange;", "getIndexForIterator", "", "indices", "startIndex", "getRawCharAt", "", "index", "verify", "", "Iterator", "ListIterator", "TokenInfo"}, moduleName="intellij-markdown")
public abstract class TokensCache {
    @NotNull
    public abstract List<TokenInfo> getCachedTokens();

    @NotNull
    public abstract List<TokenInfo> getFilteredTokens();

    @NotNull
    public abstract CharSequence getOriginalText();

    @NotNull
    public abstract IntRange getOriginalTextRange();

    public final char getRawCharAt(int index) {
        if (index < ((Number)this.getOriginalTextRange().getStart()).intValue()) {
            return (char)0;
        }
        if (index > ((Number)this.getOriginalTextRange().getEndInclusive()).intValue()) {
            return (char)0;
        }
        return this.getOriginalText().charAt(index);
    }

    protected final void verify() {
        int i;
        int n;
        IntRange intRange = CollectionsKt.getIndices((Collection)this.getCachedTokens());
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                PreconditionsKt.assert((this.getCachedTokens().get(i).getRawIndex() == i ? 1 : 0) != 0);
                if (i == n) break;
                ++i;
            }
        }
        IntRange intRange2 = CollectionsKt.getIndices((Collection)this.getFilteredTokens());
        i = intRange2.getFirst();
        if (i <= (n = intRange2.getLast())) {
            while (true) {
                PreconditionsKt.assert((this.getFilteredTokens().get(i).getNormIndex() == i ? 1 : 0) != 0);
                if (i == n) break;
                ++i;
            }
        }
    }

    private final int getIndexForIterator(List<Integer> indices, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= indices.size()) {
            return this.getFilteredTokens().size();
        }
        return ((Number)indices.get(startIndex)).intValue();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\u0011\u0011)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u0013A\u0002A\r\u00041\u0003I\u0013\u0001G\u0001\"\"%=\u00012A\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005A\u001b\t!#\u0003\t\u00075\t\u0001T\u0001)\u0004\u0003E\u001b\u0011\u0001c\u0002&\r\u0011Y\u0001\u0002B\u0007\u00041\u0003I\u0013\u0001G\u0001&\u0013\u0011Y\u0001\u0012B\u0007\u0003\u0019\u0003AR!G\u0002\t\f5\t\u0001TA\u0013\u0007\t-Aa!D\u0002\u0019\u0002%\n\u0001$A\u0015\u000b\t\u0005C\u00012A\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u0005E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$ListIterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "indices", "", "", "listIndex", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;Ljava/util/List;I)V", "advance", "rawLookup", "Lorg/intellij/markdown/IElementType;", "steps", "rollback"}, moduleName="intellij-markdown")
    public final class ListIterator
    extends Iterator {
        private final List<Integer> indices;
        private final int listIndex;

        @Override
        @NotNull
        public Iterator advance() {
            return new ListIterator(this.indices, this.listIndex + 1);
        }

        @Override
        @NotNull
        public Iterator rollback() {
            return new ListIterator(this.indices, this.listIndex - 1);
        }

        @Override
        @Nullable
        public IElementType rawLookup(int steps) {
            if (steps > 0 && this.advance().getIndex() != super.advance().getIndex() || steps < 0 && this.rollback().getIndex() != super.rollback().getIndex()) {
                return null;
            }
            return super.rawLookup(steps);
        }

        public ListIterator(List<Integer> indices, int listIndex) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            super(TokensCache.this.getIndexForIterator(indices, listIndex));
            this.indices = indices;
            this.listIndex = listIndex;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\tA\u0001B\u0003\u0002\u0011\u001d)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!1Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0011Y%\u0001\u0004\u0001\u001a\u0003a\u0005\u0011\u0005CE\u0005\u0011\u0005i\u0011\u0001g\u0001Q\u0007\u0003\t6!\u0001\u0005\u0003K\u0019!1\u0002c\u0005\u000e\u0007a\u0001\u0011&\u0001\r\u000bK!!1\u0002#\u0006\u000e\u0003aY\u0011d\u0001E\f\u001b\u0005A\u001a!\n\u0005\u0005\u0003!aQ\"\u0001M\r3\rAQ\"D\u0001\u0019\u0004\u0015JAa\u0003E\u000e\u001b\ta\t\u0001\u0007\u0005\u001a\u0007!]Q\"\u0001M\u0002K\u001dAa\"D\u0001\u0019\u0004e\u0019\u0001rC\u0007\u00021\u0007)c\u0001B\u0006\t\u001e5\u0019\u0001\u0004A\u0015\u00021))C\u0001B\u0006\t\u001f5\t\u0001DB\u0015\u000b\t\rC\u0001RA\u0007\u00021\u0007a2%U\u0002\u0004\u001b\t!1\u0001c\u0002*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011A\u0001\u0002E\u0004S)!1\t\u0003E\u0005\u001b\u0005A\u001a\u0001H\u0012R\u0007\ri!\u0001B\u0003\t\b%RAa\u0011\u0005\t\f5\t\u0001D\u0002\u000f$#\u000e\u0019QB\u0001C\u0007\u0011\u001dI3\u0002B\"\t\u0011\u001fi!\u0001$\u0001\u0019\u0011q\u0019\u0013kA\u0002\u000e\u0005\u0011E\u0001\"\u0003"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "", "index", "", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;I)V", "end", "getEnd", "()I", "getIndex", "start", "getStart", "text", "", "getText", "()Ljava/lang/String;", "type", "Lorg/intellij/markdown/IElementType;", "getType", "()Lorg/intellij/markdown/IElementType;", "advance", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "charLookup", "", "steps", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "rawSteps", "rawLookup", "rawStart", "rollback", "toString"}, moduleName="intellij-markdown")
    public class Iterator {
        private final int index;

        @Nullable
        public final IElementType getType() {
            return this.info(0).getType();
        }

        @NotNull
        public final String getText() {
            return ((Object)TokensCache.this.getOriginalText().subSequence(this.info(0).getTokenStart(), this.info(0).getTokenEnd())).toString();
        }

        public final int getStart() {
            return this.info(0).getTokenStart();
        }

        public final int getEnd() {
            return this.info(0).getTokenEnd();
        }

        @NotNull
        public Iterator advance() {
            return new Iterator(this.index + 1);
        }

        @NotNull
        public Iterator rollback() {
            return new Iterator(this.index - 1);
        }

        private final TokenInfo info(int rawSteps) {
            int rawIndex;
            if (this.index < 0) {
                return new TokenInfo(null, ((Number)TokensCache.this.getOriginalTextRange().getStart()).intValue(), ((Number)TokensCache.this.getOriginalTextRange().getStart()).intValue(), 0, 0);
            }
            if (this.index > TokensCache.this.getFilteredTokens().size()) {
                return new TokenInfo(null, ((Number)TokensCache.this.getOriginalTextRange().getEndInclusive()).intValue() + 1, ((Number)TokensCache.this.getOriginalTextRange().getEndInclusive()).intValue() + 1, 0, 0);
            }
            int n = rawIndex = this.index < TokensCache.this.getFilteredTokens().size() ? TokensCache.this.getFilteredTokens().get(this.index).getRawIndex() + rawSteps : TokensCache.this.getCachedTokens().size() + rawSteps;
            if (rawIndex < 0) {
                return new TokenInfo(null, ((Number)TokensCache.this.getOriginalTextRange().getStart()).intValue(), ((Number)TokensCache.this.getOriginalTextRange().getStart()).intValue(), 0, 0);
            }
            if (rawIndex >= TokensCache.this.getCachedTokens().size()) {
                return new TokenInfo(null, ((Number)TokensCache.this.getOriginalTextRange().getEndInclusive()).intValue() + 1, ((Number)TokensCache.this.getOriginalTextRange().getEndInclusive()).intValue() + 1, 0, 0);
            }
            return TokensCache.this.getCachedTokens().get(rawIndex);
        }

        @Nullable
        public IElementType rawLookup(int steps) {
            return this.info(steps).getType();
        }

        public final int rawStart(int steps) {
            return this.info(steps).getTokenStart();
        }

        public char charLookup(int steps) {
            if (steps == 1) {
                return TokensCache.this.getRawCharAt(this.getEnd());
            }
            if (steps == -1) {
                return TokensCache.this.getRawCharAt(this.getStart() - 1);
            }
            int pos = steps > 0 ? this.rawStart(steps) : this.rawStart(steps + 1) - 1;
            return TokensCache.this.getRawCharAt(pos);
        }

        @NotNull
        public String toString() {
            return "Iterator: " + this.index + ": " + this.getType();
        }

        public final int getIndex() {
            return this.index;
        }

        public Iterator(int index) {
            this.index = index;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!q!B\u0001\t\u000f1\u0001\u0011$\u0001M\u0001C_IA\u0001C\u0001\u000e\u00051\u0005\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0003\u0013\rA9!D\u0001\u0019\u0006%\u0019\u0001\u0002B\u0007\u00021\u000b\t6!\u0001E\u0005K\u0011!1\u0002c\u0005\u000e\u0003aQ\u0011&\u0004\u0003D9!!Q\"\u0001M\u0003#\u000e9Q\u0001A\u0007\u0003\t\u0015AY!\u0005\u0002\u0005\r!5\u0011F\u0003\u0003D\u0011!\u001dQ\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t\u001dAY!\u000b\u0006\u0005\u0007\"A1!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011=\u00012B\u0015\u000b\t\rC\u0001BA\u0007\u00021\u000b\t6\u0001B\u0003\u0001\u001b\t!\u0001\u0002c\u0003*\u0017\u0011\u0019\u0005\u0002C\u0001\u000e\u00051\u0005\u00014A)\u0004\t\u0015\u0001QB\u0001C\t\u0011%\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "", "type", "Lorg/intellij/markdown/IElementType;", "tokenStart", "", "tokenEnd", "rawIndex", "normIndex", "(Lorg/intellij/markdown/IElementType;IIII)V", "getNormIndex", "()I", "setNormIndex", "(I)V", "getRawIndex", "getTokenEnd", "getTokenStart", "getType", "()Lorg/intellij/markdown/IElementType;", "toString", ""}, moduleName="intellij-markdown")
    public static final class TokenInfo {
        @Nullable
        private final IElementType type;
        private final int tokenStart;
        private final int tokenEnd;
        private final int rawIndex;
        private int normIndex;

        @NotNull
        public String toString() {
            return "TokenInfo: " + String.valueOf(this.type) + " [" + this.tokenStart + ", " + this.tokenEnd + ")";
        }

        @Nullable
        public final IElementType getType() {
            return this.type;
        }

        public final int getTokenStart() {
            return this.tokenStart;
        }

        public final int getTokenEnd() {
            return this.tokenEnd;
        }

        public final int getRawIndex() {
            return this.rawIndex;
        }

        public final int getNormIndex() {
            return this.normIndex;
        }

        public final void setNormIndex(int n) {
            this.normIndex = n;
        }

        public TokenInfo(@Nullable IElementType type, int tokenStart, int tokenEnd, int rawIndex, int normIndex) {
            this.type = type;
            this.tokenStart = tokenStart;
            this.tokenEnd = tokenEnd;
            this.rawIndex = rawIndex;
            this.normIndex = normIndex;
        }
    }
}

