/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import java.io.IOException;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.GeneratedLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0011)\u0011\u0001\"\u0003\u0006\u00031\tQ!\u0001E\u0007\u000b\u0005!\t\"B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011\u0005)\u0011\u0001b\u0001\u0005\u00171\u0001\u0001\u0013F\r\u00021\u0003i\n\u0011FQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\u0007!\tR\"\u0001M\u0012K\u0015!\u0011\u0001\u0003\n\u000e\u00051\u0005\u0001\u0004C\u0013\u0005\t\u0005A)#D\u0001\u0019'\u0015\"A!\u0001E\u0014\u001b\u0005A\u001a#J\t\t)5\t\u0001dE\r\u0004\u0011%i\u0011\u0001'\u0005\u001a\t\u0011\t\u0001BB\u0007\u00021\rIB\u0001B\u0001\t\b5\t\u0001dA\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001SI!1\t\bE\u0004\u001b\u0005A2!G\u0002\t\u00065\t\u0001d\u0001\u0011\"#\u000e9Q\u0001A\u0007\u0003\t\u0011AI!\u0005\u0002\u0005\u000b!-\u0011F\u0005\u0003D9!1Q\"\u0001\r\u00043\rA)!D\u0001\u0019\u0007\u0001\n\u0013kA\u0004\u0006\u00015\u0011AQ\u0002E\u0005#\t!q\u0001c\u0003*\u0011\u0011\tE\u0004c\u0004\u000e\u00051\u0005\u0001\u0004C)\u0004\u0003\u0015\u0001\u0011F\u0005\u0003D9!IQ\"\u0001M\t3\rA)!D\u0001\u0019\u0012\u0001\n\u0013kA\u0004\u0006\u00015\u0011A1\u0003\u0005\u000b#\t!)\u0002C\u0006*%\u0011\u0019E\u0004c\u0006\u000e\u0003a\u0019\u0011d\u0001E\u0003\u001b\u0005A2\u0001I\u0011R\u0007\u001d)\u0001!\u0004\u0002\u0005\u0019!%\u0011C\u0001C\r\u0011\u0017I#\u0003B\"\u001d\u00115i\u0011\u0001G\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004A\u0005\n6aB\u0003\u0001\u001b\t!Y\u0002#\u0003\u0012\u0005\u0011q\u00012B\u0015\u0015\t\rc\u0002RD\u0007\u0003\u0019\u0003A\u0002\"\u0007\u0003\t\u00065\u0011A\u0012\u0001\r\tA\u0005\n6aB\u0003\u0001\u001b\t!q\u0002c\b\u0012\u0005\u0011\u0001\u0002\u0012\u0005"}, strings={"Lorg/intellij/markdown/lexer/MarkdownLexer;", "", "baseLexer", "Lorg/intellij/markdown/lexer/GeneratedLexer;", "(Lorg/intellij/markdown/lexer/GeneratedLexer;)V", "<set-?>", "", "bufferEnd", "getBufferEnd", "()I", "setBufferEnd", "(I)V", "bufferStart", "getBufferStart", "setBufferStart", "nextType", "Lorg/intellij/markdown/IElementType;", "", "originalText", "getOriginalText", "()Ljava/lang/CharSequence;", "setOriginalText", "(Ljava/lang/CharSequence;)V", "tokenEnd", "getTokenEnd", "setTokenEnd", "tokenStart", "getTokenStart", "setTokenStart", "type", "getType", "()Lorg/intellij/markdown/IElementType;", "setType", "(Lorg/intellij/markdown/IElementType;)V", "advance", "", "advanceBase", "calcNextType", "", "locateToken", "start", "Companion"}, moduleName="intellij-markdown")
public class MarkdownLexer {
    @Nullable
    private IElementType type;
    private IElementType nextType;
    @NotNull
    private CharSequence originalText;
    private int bufferStart;
    private int bufferEnd;
    private int tokenStart;
    private int tokenEnd;
    private final GeneratedLexer baseLexer;
    private static final Set<IElementType> TOKENS_TO_MERGE;
    public static final Companion Companion;

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    private final void setType(IElementType iElementType) {
        this.type = iElementType;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    private final void setOriginalText(CharSequence charSequence) {
        this.originalText = charSequence;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    private final void setBufferStart(int n) {
        this.bufferStart = n;
    }

    public final int getBufferEnd() {
        return this.bufferEnd;
    }

    private final void setBufferEnd(int n) {
        this.bufferEnd = n;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    private final void setTokenStart(int n) {
        this.tokenStart = n;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    private final void setTokenEnd(int n) {
        this.tokenEnd = n;
    }

    public final void start(@NotNull CharSequence originalText, int bufferStart, int bufferEnd) {
        Intrinsics.checkParameterIsNotNull((Object)originalText, (String)"originalText");
        this.originalText = originalText;
        this.bufferStart = bufferStart;
        this.bufferEnd = bufferEnd;
        this.baseLexer.reset(originalText, bufferStart, bufferEnd, 0);
        this.type = this.advanceBase();
        this.tokenStart = this.baseLexer.getTokenStart();
        this.calcNextType();
    }

    public static /* bridge */ /* synthetic */ void start$default(MarkdownLexer markdownLexer, CharSequence charSequence, int n, int n2, int n3) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        markdownLexer.start(charSequence, n, n2);
    }

    public final boolean advance() {
        return this.locateToken();
    }

    private final boolean locateToken() {
        this.type = this.nextType;
        this.tokenStart = this.tokenEnd;
        if (this.type == null) {
            return false;
        }
        this.calcNextType();
        return true;
    }

    private final void calcNextType() {
        IElementType it;
        do {
            this.tokenEnd = this.baseLexer.getTokenEnd();
            this.nextType = this.advanceBase();
            IElementType $receiver$iv = this.type;
            it = $receiver$iv;
        } while (Intrinsics.areEqual((Object)this.nextType, (Object)it) && it != null && MarkdownLexer.Companion.getTOKENS_TO_MERGE().contains(it));
    }

    private final IElementType advanceBase() {
        try {
            return this.baseLexer.advance();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw (Throwable)((Object)new AssertionError((Object)"This could not be!"));
        }
    }

    public MarkdownLexer(@NotNull GeneratedLexer baseLexer) {
        Intrinsics.checkParameterIsNotNull((Object)baseLexer, (String)"baseLexer");
        this.baseLexer = baseLexer;
        this.originalText = "";
    }

    static {
        Companion = org.intellij.markdown.lexer.MarkdownLexer$Companion.INSTANCE;
        TOKENS_TO_MERGE = SetsKt.setOf((Object[])new IElementType[]{MarkdownTokenTypes.Companion.getTEXT(), MarkdownTokenTypes.Companion.getWHITE_SPACE(), MarkdownTokenTypes.Companion.getCODE_LINE(), MarkdownTokenTypes.Companion.getLINK_ID(), MarkdownTokenTypes.Companion.getLINK_TITLE(), MarkdownTokenTypes.Companion.getURL(), MarkdownTokenTypes.Companion.getAUTOLINK(), MarkdownTokenTypes.Companion.getEMAIL_AUTOLINK(), MarkdownTokenTypes.Companion.getBAD_CHARACTER()});
    }

    public static final /* synthetic */ void access$setNextType$p(MarkdownLexer $this, @Nullable IElementType iElementType) {
        $this.nextType = iElementType;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tR!\u0001\u0007\u0002\u000b\u0005!\u0011\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003%rA!\u0011\u0005\t\u00045!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0007!\u001d\u0001"}, strings={"Lorg/intellij/markdown/lexer/MarkdownLexer$Companion;", "", "()V", "TOKENS_TO_MERGE", "", "Lorg/intellij/markdown/IElementType;", "getTOKENS_TO_MERGE", "()Ljava/util/Set;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Set<IElementType> getTOKENS_TO_MERGE() {
            return TOKENS_TO_MERGE;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

