/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.NanoXmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.FxmlDataExternalizer;
import org.jetbrains.plugins.javaFX.FxmlDataIndexer;
import org.jetbrains.plugins.javaFX.JavaFxControllerClassIndex;

public class JavaFxCustomComponentsIndex
extends FileBasedIndexExtension<String, Set<String>> {
    @NonNls
    public static final ID<String, Set<String>> KEY = ID.create((String)"javafx.custom.component");
    private final KeyDescriptor<String> myKeyDescriptor = new EnumeratorStringDescriptor();
    private final FileBasedIndex.InputFilter myInputFilter = new JavaFxControllerClassIndex.MyInputFilter();
    private final FxmlDataIndexer myDataIndexer = new FxmlDataIndexer(){

        @Override
        protected IXMLBuilder createParseHandler(final String path, final Map<String, Set<String>> map) {
            return new NanoXmlUtil.IXMLBuilderAdapter(){
                public boolean myFxRootUsed = false;

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (!this.myFxRootUsed) {
                        throw new FxmlDataIndexer.StopException();
                    }
                    if (value != null && "type".equals(key)) {
                        HashSet<String> paths = (HashSet<String>)map.get(value);
                        if (paths == null) {
                            paths = new HashSet<String>();
                            map.put(value, paths);
                        }
                        paths.add(path);
                    }
                }

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    this.myFxRootUsed = "fx:root".equals(nsPrefix + ":" + name);
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    throw new FxmlDataIndexer.StopException();
                }
            };
        }
    };
    private final FxmlDataExternalizer myDataExternalizer = new FxmlDataExternalizer();

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        FxmlDataIndexer fxmlDataIndexer = this.myDataIndexer;
        if (fxmlDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxCustomComponentsIndex", "getIndexer"));
        }
        return fxmlDataIndexer;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        FxmlDataExternalizer fxmlDataExternalizer = this.myDataExternalizer;
        if (fxmlDataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxCustomComponentsIndex", "getValueExternalizer"));
        }
        return fxmlDataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxCustomComponentsIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = KEY;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxCustomComponentsIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        KeyDescriptor<String> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxCustomComponentsIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    public static <T> List<T> findCustomFxml(final Project project, final @NotNull String className, final Function<VirtualFile, T> f, final GlobalSearchScope scope) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/JavaFxCustomComponentsIndex", "findCustomFxml"));
        }
        return (List)ApplicationManager.getApplication().runReadAction(new Computable<List<T>>(){

            public List<T> compute() {
                Collection files;
                try {
                    files = FileBasedIndex.getInstance().getContainingFiles(KEY, (Object)className, GlobalSearchScope.projectScope((Project)project).intersectWith(scope));
                }
                catch (IndexNotReadyException e) {
                    return Collections.emptyList();
                }
                if (files.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<Object> result = new ArrayList<Object>();
                for (VirtualFile file : files) {
                    Object fFile;
                    if (!file.isValid() || (fFile = f.fun((Object)file)) == null) continue;
                    result.add(fFile);
                }
                return result;
            }
        });
    }
}

