/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@Tag(value="build-property")
public final class BuildFileProperty
implements JDOMExternalizable {
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    private String myPropertyName;
    private String myPropertyValue;

    public BuildFileProperty() {
        this("", "");
    }

    public BuildFileProperty(String propertyName, String propertyValue) {
        this.setPropertyName(propertyName);
        this.myPropertyValue = propertyValue;
    }

    @Attribute(value="name")
    public String getPropertyName() {
        return this.myPropertyName;
    }

    public void setPropertyName(String propertyName) {
        this.myPropertyName = propertyName.trim();
    }

    @Attribute(value="value")
    public String getPropertyValue() {
        return this.myPropertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public void readExternal(Element element) {
        this.myPropertyName = element.getAttributeValue(NAME);
        this.myPropertyValue = element.getAttributeValue(VALUE);
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME, this.getPropertyName());
        element.setAttribute(VALUE, this.getPropertyValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildFileProperty that = (BuildFileProperty)o;
        return Comparing.equal((String)this.myPropertyName, (String)that.myPropertyName) && Comparing.equal((String)this.myPropertyValue, (String)that.myPropertyValue);
    }

    public int hashCode() {
        return 31 * (this.myPropertyName != null ? this.myPropertyName.hashCode() : 0) + (this.myPropertyValue != null ? this.myPropertyValue.hashCode() : 0);
    }
}

