/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.api.IImageFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Graphics2DDelegate;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeImageFactory
implements IImageFactory {
    private static final Logger LOG = Logger.getInstance(FakeImageFactory.class);
    private Graphics myGraphics;
    private int myRequestedHeight;
    private int myRequestedWidth;

    public void setGraphics(@NotNull Graphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/swing/layoutlib/FakeImageFactory", "setGraphics"));
        }
        this.myGraphics = graphics;
    }

    public int getRequestedHeight() {
        return this.myRequestedHeight;
    }

    public int getRequestedWidth() {
        return this.myRequestedWidth;
    }

    public BufferedImage getImage(final int w, final int h) {
        return new BufferedImage(1, 1, 2){

            @Override
            public Graphics2D createGraphics() {
                FakeImageFactory.this.myRequestedHeight = h;
                FakeImageFactory.this.myRequestedWidth = w;
                final Shape originalClip = FakeImageFactory.this.myGraphics.getClip();
                final AffineTransform originalTx = ((Graphics2D)FakeImageFactory.this.myGraphics).getTransform();
                AffineTransform inverse = null;
                try {
                    inverse = originalTx.createInverse();
                }
                catch (NoninvertibleTransformException e) {
                    LOG.error((Throwable)e);
                }
                final AffineTransform originalTxInverse = inverse;
                Graphics2DDelegate g = new Graphics2DDelegate((Graphics2D)FakeImageFactory.this.myGraphics.create()){

                    @Nullable
                    private Shape intersect(@Nullable Shape s1, @Nullable Shape s2) {
                        if (s1 == null || s2 == null) {
                            return s1 == null ? s2 : s1;
                        }
                        Area a1 = new Area(s1);
                        Area a2 = new Area(s2);
                        a1.intersect(a2);
                        return a1;
                    }

                    public void clip(@Nullable Shape s) {
                        if (s == null) {
                            this.setClip(null);
                            return;
                        }
                        super.clip(s);
                    }

                    public void setClip(@Nullable Shape sh) {
                        try {
                            super.setClip(this.intersect(this.getTransform().createInverse().createTransformedShape(originalClip), sh));
                        }
                        catch (NoninvertibleTransformException e) {
                            LOG.error((Throwable)e);
                        }
                    }

                    public void setTransform(@Nullable AffineTransform Tx) {
                        AffineTransform transform = (AffineTransform)originalTx.clone();
                        transform.concatenate(Tx);
                        super.setTransform(transform);
                    }

                    public AffineTransform getTransform() {
                        AffineTransform currentTransform = super.getTransform();
                        currentTransform.concatenate(originalTxInverse);
                        return currentTransform;
                    }
                };
                return g;
            }

            @Override
            public int getWidth() {
                return w;
            }

            @Override
            public int getHeight() {
                return h;
            }
        };
    }
}

