/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.utils.DFS;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"#\u0015\u0001Q!\u0001E\u0012\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0019Q!\u0001\u0005\u0012\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u001bMA\u0001!\u0004\u0003\n\u0005%\tA%\u0001M\u0001#\u0011!\u0001\u0001C\u0001\u0016\u0003a\r\u0011d\u0001\u0005\u0003\u001b\u0005!\u0013!U\u0002\u0002\u0011\u000b!6aA\u0007\u0011\u0011\u000fi\u0011\u0001J\u0001\u0012\t\u0011\u0001\u0001\"A\u000b\u00021\u0007I2\u0001\u0003\u0002\u000e\u0003\u0011\n\u0011kA\u0001\t\tQ\u001b1!D\u0012\t\n59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\n\u0004\u0019\fa)\u0011\u0003\u0002\u0003\u0001\u0011\u0005)\u0012\u0001g\u0001\u0012\u0005\u0011\u0005\u0001BB\r\u0004\u0011\ti\u0011\u0001J\u0001\u001a\u0013!5QbB\u0005\u0003\u0013\u0005!\u0013!\u0003\u0002\n\u0003\u00112\u0001dB)\u0004\u0003!=AkA\u0002"}, strings={"findAllReachableDeclarations", "", "Function", "Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "function", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Ljava/util/Set;", "BridgesKt", "findConcreteSuperDeclaration", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "generateBridges", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "signature", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;Lkotlin/jvm/functions/Function1;)Ljava/util/Set;"}, moduleName="kotlin-compiler")
public final class BridgesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle, Signature> Set<Bridge<Signature>> generateBridges(@NotNull Function function, @NotNull Function1<? super Function, ? extends Signature> signature) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object object;
        Collection $receiver$iv$iv2;
        void $receiver$iv2;
        HashSet hashSet;
        Iterable destination$iv;
        Object it;
        boolean fake;
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        if (function.isAbstract()) {
            return SetsKt.setOf();
        }
        boolean bl = fake = !function.isDeclaration();
        if (fake) {
            boolean bl2;
            block10: {
                Iterable<FunctionHandle> $receiver$iv4 = function.getOverridden();
                for (FunctionHandle functionHandle : $receiver$iv4) {
                    it = functionHandle;
                    if (!it.isAbstract()) continue;
                    bl2 = false;
                    break block10;
                }
                bl2 = true;
            }
            if (bl2) {
                return SetsKt.setOf();
            }
        }
        Function implementation = BridgesKt.findConcreteSuperDeclaration(function);
        Iterable iterable = BridgesKt.findAllReachableDeclarations(function);
        it = new HashSet();
        for (Object item$iv : iterable) {
            destination$iv.add(signature.invoke(item$iv));
        }
        HashSet bridgesToGenerate = (HashSet)destination$iv;
        if (fake) {
            Iterable<FunctionHandle> iterable2 = function.getOverridden();
            if (iterable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Iterable<Function>");
            }
            for (FunctionHandle functionHandle : iterable2) {
                void destination$iv$iv2;
                Object item$iv;
                if (functionHandle.isAbstract()) continue;
                Iterable $i$a$1 = BridgesKt.findAllReachableDeclarations(functionHandle);
                hashSet = bridgesToGenerate;
                item$iv = $receiver$iv2;
                Collection $i$f$mapTo = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    destination$iv$iv2.add(signature.invoke(item$iv$iv2));
                }
                object = (List)destination$iv$iv2;
                hashSet.removeAll((Collection)object);
            }
        }
        Signature Signature = signature.invoke(implementation);
        bridgesToGenerate.remove(Signature);
        destination$iv = bridgesToGenerate;
        $receiver$iv2 = $receiver$iv;
        $receiver$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it2;
            Object item$iv$iv;
            Object item$iv$iv2;
            item$iv$iv2 = item$iv$iv = iterator2.next();
            hashSet = destination$iv$iv;
            object = new Bridge<void>(it2, (void)Signature);
            hashSet.add(object);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @NotNull
    public static final <Function extends FunctionHandle> Set<Function> findAllReachableDeclarations(@NotNull Function function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        DFS.NodeHandlerWithListResult collector2 = new DFS.NodeHandlerWithListResult<Function, Function>(){

            public void afterChildren(@NotNull Function current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if (current.isDeclaration()) {
                    ((LinkedList)this.result).add(current);
                }
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(function), findAllReachableDeclarations.1.INSTANCE, collector2);
        return new HashSet((Collection)collector2.result());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle> Function findConcreteSuperDeclaration(@NotNull Function function) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Set<Function> reachable;
        Intrinsics.checkParameterIsNotNull(function, "function");
        boolean value$iv = !function.isAbstract();
        if (!value$iv) {
            String message$iv = "Only concrete functions have implementations: " + function;
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
        if (function.isDeclaration()) {
            return function;
        }
        Set<Function> result2 = BridgesKt.findAllReachableDeclarations(function);
        HashSet toRemove = new HashSet();
        for (Function declaration : result2) {
            reachable = BridgesKt.findAllReachableDeclarations(declaration);
            reachable.remove(declaration);
            toRemove.addAll(reachable);
        }
        result2.removeAll(toRemove);
        Iterable $i$f$require = result2;
        reachable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FunctionHandle it = (FunctionHandle)element$iv$iv;
            if (!(!it.isAbstract())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List concreteRelevantDeclarations = (List)destination$iv$iv;
        $receiver$iv = concreteRelevantDeclarations;
        if ($receiver$iv.size() != 1) {
            PreconditionsKt.error("Concrete fake override " + function + " should have exactly one concrete super-declaration: " + concreteRelevantDeclarations);
        }
        return (Function)((FunctionHandle)concreteRelevantDeclarations.get(0));
    }
}

