/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import java.util.Collection;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.state.TypeMappingMode;
import org.jetbrains.kotlin.codegen.state.TypeMappingUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"K\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t#\u0015\u0001Q!\u0001E\u0006\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAAG\u0014\t\u0001AQ!\u0004\u0002\r\u0002a-\u0011\u0004\u0002\u0005\u0007\u001b\ta\t\u0001\u0007\u0003\u001a\u0007!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\bQ\u001b\u0011!$\u0007\t\u00115\t\u0001\u0014C\r\u0004\u0011%i\u0011\u0001'\u0005\u001a\u0007!MQ\"\u0001M\t)\u000e\tQr\u0002\u0003\u0002\u0011)i\u0011\u0001g\u0002\u0016\u0003a9AkA\u0001\u000e\u0019!UQ\"\u0001M\u0004+\u0005Ar!'\u0003\t\u00175\t\u0001t\u0003)\u0004\u0002Q\u001b\u0011!$\u0004\t\u00195\t\u0001tA\u000b\u00021\u001d!6!A\u0007\f\t\u0005AI\"\u0004\u0002\r\u0002a\u001dQ#\u0001\r\u000e#\u000e\t\u00012\u0004+\u0004\u00035aA!\u0001E\r\u001b\ta\t\u0001g\u0002\u0016\u00051\u0005\u0001DD)\u0004\u0003!uAkA\u0001\u000e\u0017\u0011\t\u0001\u0012D\u0007\u0003\u0019\u0003A:!F\u0001\u0019\u000fE\u001b\u0011\u0001C\bU\u0007\u0005iQ\u0002\u0002\u0001\t 5\t\u00014B\u000b\u00021\u0017IJ\u0001\u0003\t\u000e\u0003a9\u0001k!\u0001U\u0007\u0005\t\n\u0002B!\t\u0011\u0001i\u0011\u0001'\u0001R\u0007\u0005)\u0001\u0001V\u0002\u0002##!\u0011\t\u0003E\u0002\u001b\u0005A\n!U\u0002\u0002\u000b\u0001!6!AI\f\t\u0005C\u0001BA\u0007\u0005\u0013\tI\u0011\u0001'\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001U\u0007\u0005\tj\u0002B\"\t\u0011\ri\u0011\u0001g\u0002\u0016\u00051\u0005\u0001\u0004\u0002\u000f$#\u000e\u0019QB\u0001\u0003\u0004\u0011\u0013!6!\u0001"}, strings={"JVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "TypeMappingUtil", "JVM_WILDCARD_ANNOTATION_FQ_NAME", "METHODS_WITH_DECLARATION_SITE_WILDCARDS", "", "isMethodWithDeclarationSiteWildcards", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "extractTypeMappingModeFromAnnotation", "Lorg/jetbrains/kotlin/codegen/state/TypeMappingMode;", "callableDescriptor", "outerType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isForAnnotationParameter", "getEffectiveVariance", "Lorg/jetbrains/kotlin/types/Variance;", "parameterVariance", "projectionKind", "canHaveSubtypesIgnoringNullability", "isMostPreciseContravariantArgument", "parameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "isMostPreciseCovariantArgument", "suppressWildcardsMode", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Ljava/lang/Boolean;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/Boolean;", "updateArgumentModeFromAnnotations", "type"}, moduleName="kotlin-compiler")
@JvmName(name="TypeMappingUtil")
public final class TypeMappingUtil {
    private static final Set<FqName> METHODS_WITH_DECLARATION_SITE_WILDCARDS = SetsKt.setOf(new FqName("kotlin.MutableCollection.addAll"), new FqName("kotlin.MutableList.addAll"), new FqName("kotlin.MutableMap.putAll"));
    private static final FqName JVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSuppressWildcards");
    private static final FqName JVM_WILDCARD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmWildcard");

    public static final boolean isMostPreciseContravariantArgument(KotlinType $receiver, @NotNull TypeParameterDescriptor parameter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return KotlinBuiltIns.isAnyOrNullableAny($receiver);
    }

    public static final boolean isMostPreciseCovariantArgument(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return !TypeMappingUtil.canHaveSubtypesIgnoringNullability($receiver);
    }

    private static final boolean canHaveSubtypesIgnoringNullability(KotlinType $receiver) {
        TypeConstructor constructor = $receiver.getConstructor();
        ClassifierDescriptor descriptor2 = constructor.getDeclarationDescriptor();
        ClassifierDescriptor object2 = descriptor2;
        if (object2 instanceof TypeParameterDescriptor) {
            return true;
        }
        if (object2 instanceof ClassDescriptor && !ModalityKt.isFinalClass((ClassDescriptor)descriptor2)) {
            return true;
        }
        Iterable iterable = constructor.getParameters();
        Iterable iterable2 = $receiver.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, "arguments");
        for (Pair pair : CollectionsKt.zip(iterable, iterable2)) {
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)pair.component1();
            TypeProjection argument = (TypeProjection)pair.component2();
            if (argument.isStarProjection()) {
                return true;
            }
            Variance projectionKind = argument.getProjectionKind();
            KotlinType type2 = argument.getType();
            Variance variance = parameter.getVariance();
            Intrinsics.checkExpressionValueIsNotNull((Object)variance, "parameter.variance");
            Variance variance2 = projectionKind;
            Intrinsics.checkExpressionValueIsNotNull((Object)variance2, "projectionKind");
            Variance effectiveVariance = TypeMappingUtil.getEffectiveVariance(variance, variance2);
            if (Intrinsics.areEqual((Object)effectiveVariance, (Object)Variance.OUT_VARIANCE) && !TypeMappingUtil.isMostPreciseCovariantArgument(type2)) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)effectiveVariance, (Object)Variance.IN_VARIANCE)) continue;
            TypeParameterDescriptor typeParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "parameter");
            if (TypeMappingUtil.isMostPreciseContravariantArgument(type2, typeParameterDescriptor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final Variance getEffectiveVariance(@NotNull Variance parameterVariance, @NotNull Variance projectionKind) {
        Intrinsics.checkParameterIsNotNull((Object)parameterVariance, "parameterVariance");
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return parameterVariance;
        }
        if (parameterVariance == projectionKind) {
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    public static final boolean isMethodWithDeclarationSiteWildcards(CallableDescriptor $receiver) {
        if (!($receiver instanceof CallableMemberDescriptor)) {
            return false;
        }
        return DescriptorUtilsKt.firstOverridden((CallableMemberDescriptor)$receiver, isMethodWithDeclarationSiteWildcards.1.INSTANCE) != null;
    }

    @NotNull
    public static final TypeMappingMode updateArgumentModeFromAnnotations(TypeMappingMode $receiver, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Boolean bl = TypeMappingUtil.suppressWildcardsMode(type2);
        if (bl != null) {
            Boolean $receiver$iv = bl;
            boolean it = $receiver$iv;
            return TypeMappingMode.Companion.createWithConstantDeclarationSiteWildcardsMode$default(TypeMappingMode.Companion, it, $receiver.isForAnnotationParameter(), null, 4);
        }
        if (type2.getAnnotations().hasAnnotation(JVM_WILDCARD_ANNOTATION_FQ_NAME)) {
            return TypeMappingMode.Companion.createWithConstantDeclarationSiteWildcardsMode(false, $receiver.isForAnnotationParameter(), $receiver);
        }
        return $receiver;
    }

    @Nullable
    public static final TypeMappingMode extractTypeMappingModeFromAnnotation(@Nullable CallableDescriptor callableDescriptor, @NotNull KotlinType outerType, boolean isForAnnotationParameter) {
        TypeMappingMode typeMappingMode;
        Intrinsics.checkParameterIsNotNull(outerType, "outerType");
        Boolean bl = TypeMappingUtil.suppressWildcardsMode(outerType);
        if (bl == null) {
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            bl = callableDescriptor2 != null ? TypeMappingUtil.suppressWildcardsMode(callableDescriptor2) : null;
        }
        if (bl != null) {
            Boolean $receiver$iv = bl;
            boolean it = $receiver$iv;
            typeMappingMode = CollectionsKt.isNotEmpty((Collection)outerType.getArguments()) ? TypeMappingMode.Companion.createWithConstantDeclarationSiteWildcardsMode$default(TypeMappingMode.Companion, it, isForAnnotationParameter, null, 4) : TypeMappingMode.DEFAULT;
        } else {
            typeMappingMode = null;
        }
        return typeMappingMode;
    }

    private static final Boolean suppressWildcardsMode(DeclarationDescriptor $receiver) {
        return TypeMappingUtil.suppressWildcardsMode((AnnotationDescriptor)SequencesKt.firstOrNull(SequencesKt.mapNotNull(DescriptorUtilsKt.getParentsWithSelf($receiver), suppressWildcardsMode.1.INSTANCE)));
    }

    private static final Boolean suppressWildcardsMode(KotlinType $receiver) {
        return TypeMappingUtil.suppressWildcardsMode($receiver.getAnnotations().findAnnotation(JVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME));
    }

    private static final Boolean suppressWildcardsMode(AnnotationDescriptor $receiver) {
        AnnotationDescriptor annotationDescriptor = $receiver;
        if (annotationDescriptor == null) {
            return null;
        }
        ConstantValue constantValue = (ConstantValue)CollectionsKt.firstOrNull((Iterable)annotationDescriptor.getAllValueArguments().values());
        Object object = constantValue != null ? constantValue.getValue() : null;
        if (!(object instanceof Boolean)) {
            object = null;
        }
        Boolean bl = (Boolean)object;
        return bl != null ? bl : true;
    }

    @NotNull
    public static final /* synthetic */ Set access$getMETHODS_WITH_DECLARATION_SITE_WILDCARDS$p() {
        return METHODS_WITH_DECLARATION_SITE_WILDCARDS;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getJVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME$p() {
        return JVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME;
    }
}

