/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q!\u0001\u0003\u0002\u000b\u0005a\u0011\u0001B\n\r\u0001e\t\u0001\u0014AQ\u000f\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015\u0002B!\u0001\u0005\u0007\u001b\u0005A\u001a!G\u0002\t\u000e5\t\u00014B\r\u0004\u0011\u001di\u0011\u0001g\u0001\u001a\u0007!=Q\"\u0001M\u0002K\u001dA\u0001\"D\u0001\u0019\u0012e\u0019\u0001RB\u0007\u00021\u0017)#\u0002C\u0005\u000e\u0003aE\u0011D\u0002E\n\u001b\u0011I!!C\u0001\u0019\u0016aQQe\u0002\u0005\f\u001b\u0005A\u001a!G\u0002\t\u000e5\t\u00014B\u0013\n\t\u0005A9\"\u0004\u0002\r\u0002a\r\u0011d\u0001E\u0007\u001b\u0005AZ!\n\u0005\u0005\u0003!aQ\"\u0001M\u00023\rAi!D\u0001\u0019\f\u0015\u001a\u0001\u0012D\u0007\u000215)s\u0001c\u0007\u000e\u0003aq\u0011d\u0001E\u0007\u001b\u0005AZ!\n\u0006\u0005%!uQB\u0001G\u00011\u0007IB\u0001C\b\u000e\u00051\u0005\u0001tD\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0004\u001b\u0005A:!U\u0002\u0002\u000b\u0001Ic\u0002B!\t\u0011\u0013i\u0001\"\u0003\u0002\n\u0003a-\u0011bA\u0005\u0003\u0019\u0003A\u001a\u0001G\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A!!D\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "inliningContext", "Lorg/jetbrains/kotlin/js/inline/context/InliningContext;", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "(Lcom/google/dart/compiler/backend/js/ast/JsFunction;Lorg/jetbrains/kotlin/js/inline/context/InliningContext;Lorg/jetbrains/kotlin/js/inline/FunctionReader;)V", "functionsWithClosure", "Ljava/util/IdentityHashMap;", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "applyCapturedArgs", "call", "inner", "outer", "declareFunctionConstructorCall", "", "declareFunctionConstructorCalls", "arguments", "", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getFunctionDefinition", "getFunctionDefinitionImpl", "getFunctionWithClosure", "getScope", "Lcom/google/dart/compiler/backend/js/ast/JsScope;", "hasFunctionDefinition", "", "lookUpStaticFunction", "functionName", "Lcom/google/dart/compiler/backend/js/ast/JsName;"}, moduleName="kotlin-compiler")
public abstract class FunctionContext {
    private final IdentityHashMap<JsInvocation, JsFunction> functionsWithClosure;
    private final JsFunction function;
    private final InliningContext inliningContext;
    private final FunctionReader functionReader;

    @Nullable
    protected abstract JsFunction lookUpStaticFunction(@Nullable JsName var1);

    @NotNull
    public final JsFunction getFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsFunction jsFunction = this.getFunctionDefinitionImpl(call);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        return jsFunction;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        return this.getFunctionDefinitionImpl(call) != null;
    }

    @NotNull
    public final JsScope getScope() {
        JsScope jsScope = this.function.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "function.getScope()");
        return jsScope;
    }

    public final void declareFunctionConstructorCalls(@NotNull List<? extends JsExpression> arguments2) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        List<JsInvocation> calls = ContainerUtil.findAll((Collection)arguments2, JsInvocation.class);
        Iterator<JsInvocation> iterator2 = calls.iterator();
        while (iterator2.hasNext()) {
            JsNode functionCalled;
            JsNode staticRef2;
            JsInvocation call;
            JsInvocation jsInvocation = call = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "call");
            JsName callName = InvocationUtilsKt.getSimpleName(jsInvocation);
            if (callName == null || !((staticRef2 = MetadataProperties.getStaticRef(callName)) instanceof JsFunction) || !FunctionUtilsKt.isFunctionCreator((JsFunction)(functionCalled = staticRef2))) continue;
            JsInvocation jsInvocation2 = call;
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation2, "call");
            this.declareFunctionConstructorCall(jsInvocation2);
        }
    }

    public final void declareFunctionConstructorCall(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        this.functionsWithClosure.put(call, null);
    }

    private final JsFunction getFunctionDefinitionImpl(JsInvocation call) {
        JsFunction jsFunction;
        JsExpression qualifier2;
        JsNode jsNode;
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call);
        if (descriptor2 != null && this.functionReader.contains(descriptor2)) {
            return this.functionReader.get(descriptor2);
        }
        JsExpression callQualifier = call.getQualifier();
        if (InvocationUtilsKt.isCallInvocation(call)) {
            JsExpression jsExpression = callQualifier;
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
            }
            JsExpression jsExpression2 = ((JsNameRef)jsExpression).getQualifier();
            if (jsExpression2 == null) {
                Intrinsics.throwNpe();
            }
            callQualifier = jsExpression2;
        }
        if (callQualifier instanceof JsNameRef) {
            JsExpression jsExpression;
            JsName jsName = ((JsNameRef)callQualifier).getName();
            JsNode staticRef2 = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
            jsNode = staticRef2;
            if (jsNode instanceof JsNameRef) {
                jsExpression = (JsExpression)staticRef2;
            } else if (jsNode instanceof JsInvocation) {
                jsExpression = (JsExpression)staticRef2;
            } else if (jsNode instanceof JsFunction || Intrinsics.areEqual(jsNode, null)) {
                jsExpression = callQualifier;
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected static reference type " + staticRef2.getClass())));
            }
            callQualifier = jsExpression;
        }
        if ((jsNode = (qualifier2 = callQualifier)) instanceof JsInvocation) {
            JsInvocation jsInvocation = (JsInvocation)qualifier2;
            Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "qualifier");
            jsFunction = this.getFunctionWithClosure(jsInvocation);
        } else {
            jsFunction = jsNode instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier2).getName()) : (JsFunction)null;
        }
        return jsFunction;
    }

    private final JsFunction getFunctionWithClosure(JsInvocation call) {
        JsFunction constructed = this.functionsWithClosure.get(call);
        if (constructed instanceof JsFunction) {
            return constructed;
        }
        JsName jsName = InvocationUtilsKt.getSimpleName(call);
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsName name = jsName;
        JsFunction jsFunction = this.lookUpStaticFunction(name);
        if (jsFunction == null) {
            Intrinsics.throwNpe();
        }
        JsFunction closureCreator = jsFunction;
        JsFunction jsFunction2 = FunctionUtilsKt.getInnerFunction(closureCreator);
        if (jsFunction2 == null) {
            Intrinsics.throwNpe();
        }
        JsFunction innerFunction = jsFunction2;
        JsFunction withCapturedArgs = this.applyCapturedArgs(call, innerFunction, closureCreator);
        this.functionsWithClosure.put(call, withCapturedArgs);
        return withCapturedArgs;
    }

    private final JsFunction applyCapturedArgs(JsInvocation call, JsFunction inner, JsFunction outer) {
        JsFunction innerClone = inner.deepCopy();
        NamingContext namingContext = this.inliningContext.newNamingContext();
        List<JsExpression> arguments2 = call.getArguments();
        List<JsParameter> parameters2 = outer.getParameters();
        List<JsExpression> list = arguments2;
        Intrinsics.checkExpressionValueIsNotNull(list, "arguments");
        List<JsParameter> list2 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "parameters");
        NamingUtilsKt.aliasArgumentsIfNeeded(namingContext, list, list2);
        JsNode jsNode = innerClone;
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "innerClone");
        namingContext.applyRenameTo(jsNode);
        JsFunction jsFunction = innerClone;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "innerClone");
        return jsFunction;
    }

    public FunctionContext(@NotNull JsFunction function, @NotNull InliningContext inliningContext, @NotNull FunctionReader functionReader) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(inliningContext, "inliningContext");
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        this.function = function;
        this.inliningContext = inliningContext;
        this.functionReader = functionReader;
        this.functionsWithClosure = new IdentityHashMap();
    }
}

