/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.prefs.AndroidLocation;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.EmulatorRunner;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.run.ExternalToolRunner;
import com.android.tools.idea.sdk.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG);
    public static final String AVD_INI_HW_LCD_DENSITY = "hw.lcd.density";
    public static final String AVD_INI_DISPLAY_NAME = "avd.ini.displayname";
    private static final AvdManagerConnection NULL_CONNECTION = new AvdManagerConnection(null);
    private AvdManager ourAvdManager;
    private Map<File, SkinLayoutDefinition> ourSkinLayoutDefinitions = Maps.newHashMap();
    private File ourEmulatorBinary;
    private static Map<LocalSdk, AvdManagerConnection> ourCache = new WeakHashMap();
    @Nullable
    private final LocalSdk myLocalSdk;

    @NotNull
    public static AvdManagerConnection getDefaultAvdManagerConnection() {
        AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        LocalSdk localSdk = null;
        if (androidSdkData != null) {
            localSdk = androidSdkData.getLocalSdk();
        }
        if (localSdk == null) {
            AvdManagerConnection avdManagerConnection = NULL_CONNECTION;
            if (avdManagerConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getDefaultAvdManagerConnection"));
            }
            return avdManagerConnection;
        }
        AvdManagerConnection avdManagerConnection = AvdManagerConnection.getAvdManagerConnection(localSdk);
        if (avdManagerConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getDefaultAvdManagerConnection"));
        }
        return avdManagerConnection;
    }

    @NotNull
    public static synchronized AvdManagerConnection getAvdManagerConnection(@NotNull LocalSdk localSdk) {
        if (localSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localSdk", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdManagerConnection"));
        }
        if (!ourCache.containsKey(localSdk)) {
            ourCache.put(localSdk, new AvdManagerConnection(localSdk));
        }
        AvdManagerConnection avdManagerConnection = ourCache.get(localSdk);
        if (avdManagerConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdManagerConnection"));
        }
        return avdManagerConnection;
    }

    private AvdManagerConnection(@Nullable LocalSdk localSdk) {
        this.myLocalSdk = localSdk;
    }

    private boolean initIfNecessary() {
        if (this.ourAvdManager == null) {
            if (this.myLocalSdk == null) {
                IJ_LOG.error("No Android SDK Found");
                return false;
            }
            try {
                this.ourAvdManager = AvdManager.getInstance((LocalSdk)this.myLocalSdk, (ILogger)SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not instantiate AVD Manager from SDK", (Throwable)e);
                return false;
            }
            this.ourEmulatorBinary = new File(this.ourAvdManager.getLocalSdk().getLocation(), FileUtil.join((String[])new String[]{SdkConstants.OS_SDK_TOOLS_FOLDER, SdkConstants.FN_EMULATOR}));
            if (!this.ourEmulatorBinary.isFile()) {
                IJ_LOG.error("No emulator binary found!");
                return false;
            }
        }
        return true;
    }

    @NotNull
    public List<AvdInfo> getAvds(boolean forceRefresh) {
        if (!this.initIfNecessary()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvds"));
            }
            return immutableList;
        }
        if (forceRefresh) {
            try {
                this.ourAvdManager.reloadAvds(SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not find Android SDK!", (Throwable)e);
            }
        }
        ArrayList avdInfos = Lists.newArrayList((Object[])this.ourAvdManager.getAllAvds());
        boolean needsRefresh = false;
        for (AvdInfo info : avdInfos) {
            if (info.getStatus() == AvdInfo.AvdStatus.ERROR_IMAGE_DIR) {
                this.updateAvdImageFolder(info);
                needsRefresh = true;
                continue;
            }
            if (info.getStatus() != AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED) continue;
            this.updateDeviceChanged(info);
            needsRefresh = true;
        }
        if (needsRefresh) {
            List<AvdInfo> list = this.getAvds(true);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvds"));
            }
            return list;
        }
        ArrayList arrayList = avdInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvds"));
        }
        return arrayList;
    }

    @Nullable
    public Dimension getAvdResolution(@NotNull AvdInfo info) {
        File layoutFile;
        File skinPath;
        File skinDir;
        Matcher m;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdResolution"));
        }
        if (!this.initIfNecessary()) {
            return null;
        }
        Map properties = info.getProperties();
        String skin = (String)properties.get("skin.name");
        if (skin != null && (m = AvdManager.NUMERIC_SKIN_SIZE.matcher(skin)).matches()) {
            int size1 = Integer.parseInt(m.group(1));
            int size2 = Integer.parseInt(m.group(2));
            return new Dimension(size1, size2);
        }
        skin = (String)properties.get("skin.path");
        if (skin != null && (skinDir = (skinPath = new File(skin)).isAbsolute() ? skinPath : new File(this.ourAvdManager.getLocalSdk().getLocation(), skin)).isDirectory() && (layoutFile = new File(skinDir, "layout")).isFile()) {
            return this.getResolutionFromLayoutFile(layoutFile);
        }
        return null;
    }

    @Nullable
    protected Dimension getResolutionFromLayoutFile(@NotNull File layoutFile) {
        SkinLayoutDefinition layoutDefinition;
        if (layoutFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutFile", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getResolutionFromLayoutFile"));
        }
        if (!this.ourSkinLayoutDefinitions.containsKey(layoutFile)) {
            this.ourSkinLayoutDefinitions.put(layoutFile, SkinLayoutDefinition.parseFile(layoutFile));
        }
        if ((layoutDefinition = this.ourSkinLayoutDefinitions.get(layoutFile)) != null) {
            String heightString = layoutDefinition.get("parts.device.display.height");
            String widthString = layoutDefinition.get("parts.device.display.width");
            if (widthString == null || heightString == null) {
                return null;
            }
            int height = Integer.parseInt(heightString);
            int width = Integer.parseInt(widthString);
            return new Dimension(width, height);
        }
        return null;
    }

    @Nullable
    public static Density getAvdDensity(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdDensity"));
        }
        Map properties = info.getProperties();
        String densityString = (String)properties.get(AVD_INI_HW_LCD_DENSITY);
        if (densityString != null) {
            int density = Integer.parseInt(densityString);
            Density[] knownDensities = Density.values();
            int i = 0;
            while (density < knownDensities[i].getDpiValue()) {
                ++i;
            }
            if (i < knownDensities.length) {
                return knownDensities[i];
            }
            return null;
        }
        return null;
    }

    public void deleteAvd(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "deleteAvd"));
        }
        if (!this.initIfNecessary()) {
            return;
        }
        this.ourAvdManager.deleteAvd(info, SDK_LOG);
    }

    public boolean isAvdRunning(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "isAvdRunning"));
        }
        return this.ourAvdManager.isAvdRunning(info);
    }

    public void stopAvd(@NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "stopAvd"));
        }
        this.ourAvdManager.stopAvd(info);
    }

    public void startAvd(final @Nullable Project project, final @NotNull AvdInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/avdmanager/AvdManagerConnection", "startAvd"));
        }
        if (!this.initIfNecessary()) {
            return;
        }
        final String avdName = info.getName();
        if (this.ourAvdManager.isAvdRunning(info)) {
            String baseFolder;
            try {
                baseFolder = this.ourAvdManager.getBaseAvdFolder();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                baseFolder = "$HOME";
            }
            String message = String.format("AVD %1$s is already running.\nIf that is not the case, delete the files at\n   %2$s/%1$s.avd/*.lock\nand try again.", avdName, baseFolder);
            Messages.showErrorDialog((Project)project, (String)message, (String)"AVD Manager");
            return;
        }
        Map properties = info.getProperties();
        final String scaleFactor = (String)properties.get("runtime.scalefactor");
        final String netDelay = (String)properties.get("runtime.network.latency");
        final String netSpeed = (String)properties.get("runtime.network.speed");
        final ProgressWindow p = new ProgressWindow(false, true, project);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProcessHandler processHandler;
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(AvdManagerConnection.this.ourEmulatorBinary.getPath());
                if (scaleFactor != null && !"auto".equals(scaleFactor)) {
                    commandLine.addParameters(new String[]{"-scale", scaleFactor});
                }
                if (netDelay != null) {
                    commandLine.addParameters(new String[]{"-netdelay", netDelay});
                }
                if (netSpeed != null) {
                    commandLine.addParameters(new String[]{"-netspeed", netSpeed});
                }
                commandLine.addParameters(new String[]{"-avd", avdName});
                EmulatorRunner runner = new EmulatorRunner(project, "AVD: " + avdName, commandLine, info);
                try {
                    processHandler = runner.start();
                }
                catch (ExecutionException e) {
                    IJ_LOG.error("Error launching emulator", (Throwable)e);
                    return;
                }
                ExternalToolRunner.ProcessOutputCollector collector = new ExternalToolRunner.ProcessOutputCollector();
                processHandler.addProcessListener((ProcessListener)collector);
                try {
                    p.start();
                    p.setText("Starting AVD...");
                    for (double d = 0.0; d < 1.0; d += 0.0125) {
                        p.setFraction(d);
                        Thread.sleep(100L);
                        if (!processHandler.isProcessTerminated()) continue;
                        break;
                    }
                }
                catch (InterruptedException d) {
                }
                finally {
                    p.stop();
                }
                processHandler.removeProcessListener((ProcessListener)collector);
                final String message = collector.getText();
                if (message.toLowerCase().contains("error") || processHandler.isProcessTerminated() && !message.trim().isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Cannot launch AVD in emulator.\nOutput:\n" + message), (String)avdName);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public AvdInfo createOrUpdateAvd(@Nullable AvdInfo currentInfo, @NotNull String avdName, @NotNull Device device, @NotNull SystemImageDescription systemImageDescription, @NotNull ScreenOrientation orientation, boolean isCircular, @Nullable String sdCard, @Nullable File skinFolder, @NotNull Map<String, String> hardwareProperties, boolean createSnapshot) {
        boolean success;
        File avdFolder;
        if (avdName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdName", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (systemImageDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemImageDescription", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (hardwareProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareProperties", "com/android/tools/idea/avdmanager/AvdManagerConnection", "createOrUpdateAvd"));
        }
        if (!this.initIfNecessary()) {
            return null;
        }
        try {
            avdFolder = currentInfo != null ? new File(currentInfo.getDataFolderPath()) : AvdInfo.getDefaultAvdFolder((AvdManager)this.ourAvdManager, (String)avdName, (boolean)true);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            IJ_LOG.error("Could not create AVD " + avdName, (Throwable)e);
            return null;
        }
        Dimension resolution = device.getScreenSize(orientation);
        assert (resolution != null);
        String skinName = null;
        if (skinFolder == null && isCircular) {
            skinFolder = AvdManagerConnection.getRoundSkin(systemImageDescription);
        }
        if (FileUtil.filesEqual((File)skinFolder, (File)AvdWizardConstants.NO_SKIN)) {
            skinFolder = null;
            hardwareProperties.remove("skin.path");
        }
        if (skinFolder == null) {
            skinName = String.format("%dx%d", Math.round(resolution.getWidth()), Math.round(resolution.getHeight()));
        }
        if (orientation == ScreenOrientation.LANDSCAPE) {
            hardwareProperties.put("hw.initialOrientation", ScreenOrientation.LANDSCAPE.getShortDisplayValue().toLowerCase());
        }
        if (currentInfo != null && !avdName.equals(currentInfo.getName()) && !(success = this.ourAvdManager.moveAvd(currentInfo, avdName, currentInfo.getDataFolderPath(), SDK_LOG))) {
            return null;
        }
        return this.ourAvdManager.createAvd(avdFolder, avdName, systemImageDescription.getTarget(), systemImageDescription.getTag(), systemImageDescription.getAbiType(), skinFolder, skinName, sdCard, hardwareProperties, device.getBootProps(), createSnapshot, false, currentInfo != null, SDK_LOG);
    }

    @Nullable
    private static File getRoundSkin(SystemImageDescription systemImageDescription) {
        File[] skins;
        for (File skin : skins = systemImageDescription.getSkins()) {
            if (!skin.getName().contains("Round")) continue;
            return skin;
        }
        return null;
    }

    public boolean avdExists(String candidate) {
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.ourAvdManager.getAvd(candidate, false) != null;
    }

    static boolean isAvdRepairable(AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_MISSING || avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_MISSING;
    }

    public boolean updateAvdImageFolder(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "updateAvdImageFolder"));
        }
        if (this.initIfNecessary()) {
            try {
                this.ourAvdManager.updateAvd(avdInfo, SDK_LOG);
                return true;
            }
            catch (IOException e) {
                IJ_LOG.error("Could not update AVD " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean updateDeviceChanged(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "updateDeviceChanged"));
        }
        if (this.initIfNecessary()) {
            try {
                this.ourAvdManager.updateDeviceChanged(avdInfo, SDK_LOG);
                return true;
            }
            catch (IOException e) {
                IJ_LOG.error("Could not update AVD Device " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean wipeUserData(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "wipeUserData"));
        }
        if (this.initIfNecessary()) {
            File userdataImage = new File(avdInfo.getDataFolderPath(), "userdata-qemu.img");
            if (userdataImage.isFile()) {
                return userdataImage.delete();
            }
            return true;
        }
        return false;
    }

    public static String getAvdDisplayName(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdManagerConnection", "getAvdDisplayName"));
        }
        String displayName = (String)avdInfo.getProperties().get(AVD_INI_DISPLAY_NAME);
        if (displayName == null) {
            displayName = avdInfo.getName().replaceAll("[_-]+", " ");
        }
        return displayName;
    }
}

