/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureService {
    public static final String FD_CAPTURES = "captures";
    @NotNull
    private final Project myProject;
    @NotNull
    private Multimap<CaptureType, Capture> myCaptures;
    private List<CaptureListener> myListeners;

    public CaptureService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/capture/CaptureService", "<init>"));
        }
        this.myProject = project;
        this.myCaptures = LinkedListMultimap.create();
        this.myListeners = new LinkedList<CaptureListener>();
        this.update();
    }

    @NotNull
    public static CaptureService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/capture/CaptureService", "getInstance"));
        }
        CaptureService captureService = (CaptureService)ServiceManager.getService((Project)project, CaptureService.class);
        if (captureService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getInstance"));
        }
        return captureService;
    }

    private static Set<VirtualFile> findCaptureFiles(@NotNull VirtualFile[] files, @NotNull CaptureType type) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/profiling/capture/CaptureService", "findCaptureFiles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/profiling/capture/CaptureService", "findCaptureFiles"));
        }
        HashSet set = new HashSet();
        for (VirtualFile file : files) {
            if (!type.isValidCapture(file)) continue;
            set.add(file);
        }
        return set;
    }

    public void update() {
        CaptureTypeService service = CaptureTypeService.getInstance();
        VirtualFile dir = this.getCapturesDirectory();
        LinkedListMultimap updated = LinkedListMultimap.create();
        if (dir != null) {
            VirtualFile[] children = VfsUtil.getChildren((VirtualFile)dir);
            for (CaptureType type : service.getCaptureTypes()) {
                Set<VirtualFile> files = CaptureService.findCaptureFiles(children, type);
                for (Capture capture : this.myCaptures.get((Object)type)) {
                    if (!files.remove(capture.getFile())) continue;
                    updated.put((Object)type, (Object)capture);
                }
                for (VirtualFile newFile : files) {
                    updated.put((Object)type, (Object)type.createCapture(newFile));
                }
            }
        }
        this.myCaptures = updated;
    }

    @NotNull
    public VirtualFile createCapturesDirectory() throws IOException {
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        if (projectDir != null) {
            VirtualFile dir = projectDir.findChild(FD_CAPTURES);
            if (dir == null) {
                dir = projectDir.createChildDirectory(null, FD_CAPTURES);
            }
            VirtualFile virtualFile = dir;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "createCapturesDirectory"));
            }
            return virtualFile;
        }
        throw new IOException("Unable to create the captures directory: Project directory not found.");
    }

    @Nullable
    public VirtualFile getCapturesDirectory() {
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        return projectDir != null ? projectDir.findChild(FD_CAPTURES) : null;
    }

    @NotNull
    public Multimap<CaptureType, Capture> getCapturesByType() {
        Multimap<CaptureType, Capture> multimap = this.myCaptures;
        if (multimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getCapturesByType"));
        }
        return multimap;
    }

    @NotNull
    public Collection<Capture> getCaptures() {
        Collection collection = this.myCaptures.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getCaptures"));
        }
        return collection;
    }

    @NotNull
    public Collection<CaptureType> getTypes() {
        Set set = this.myCaptures.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getTypes"));
        }
        return set;
    }

    public Capture createCapture(Class<? extends CaptureType> clazz, byte[] data) throws IOException {
        CaptureType type = CaptureTypeService.getInstance().getType(clazz);
        assert (type != null);
        UsageTracker.getInstance().trackEvent("profiling", "captureCreated", type.getName(), null);
        VirtualFile dir = this.createCapturesDirectory();
        File file = new File(dir.createChildData(null, type.createCaptureFileName()).getPath());
        FileUtil.writeToFile((File)file, (byte[])data);
        VirtualFile vf = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (vf == null) {
            throw new IOException("Cannot find virtual file for capture file " + file.getPath());
        }
        Capture capture = type.createCapture(vf);
        this.myCaptures.put((Object)type, (Object)capture);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, capture.getFile());
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        for (CaptureListener listener : this.myListeners) {
            listener.onCreate(capture);
        }
        return capture;
    }

    public void addListener(CaptureListener listener) {
        this.myListeners.add(listener);
    }

    public static interface CaptureListener {
        public void onCreate(Capture var1);
    }
}

