/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 j2\u00020\u0001:\u0001jB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001fH\u0002J\u0018\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.2\u0006\u0010 \u001a\u00020$H\u0002J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020$H\u0002J\u0018\u00100\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020$H\u0002J\u0016\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0018\u00106\u001a\u00020\u00102\u0006\u00102\u001a\u0002072\u0006\u00104\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020\u00102\u0006\u0010)\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u00020\u00102\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020\u00102\u0006\u0010)\u001a\u00020G2\u0006\u0010 \u001a\u00020!H\u0002J \u0010H\u001a\u00020\u00102\u0006\u0010;\u001a\u00020I2\u0006\u0010)\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010N\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020$H\u0002J\u0018\u0010O\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010P\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020$H\u0002J\u0018\u0010Q\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010R\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010S\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020:2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010T\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0012H\u0002J\u0018\u0010U\u001a\u00020\u00102\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020\u00102\u0006\u0010[\u001a\u00020LH\u0002J\u0010\u0010\\\u001a\u00020\u00102\u0006\u0010[\u001a\u00020LH\u0002J\u0010\u0010]\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010^\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010_\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010`\u001a\u00020<H\u0002J\u000e\u0010a\u001a\u00020\u00102\u0006\u0010b\u001a\u00020cJ$\u0010d\u001a\u00020\u00102\f\u0010e\u001a\b\u0012\u0004\u0012\u00020Y0f2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020Y0hH\u0002J\n\u0010i\u001a\u00020\u0010*\u00020*R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\u000b0\rR\u00020\u0005\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "Lorg/jetbrains/annotations/NotNull;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkAnnotationClassWithBody", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassExposedType", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkClassOrObjectMembers", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkConstructorInInterface", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "checkExposedParameterBounds", "checkExposedSupertypes", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkFunctionExposedType", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkMemberReceiverExposedType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkProperty", "checkPropertyAbstractness", "checkPropertyExposedType", "checkPropertyInitializer", "checkPropertyLateInit", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "checkTypeReferences", "Companion", "frontend"})
public final class DeclarationsChecker {
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    public static final Companion Companion;

    public final void checkTypeReferences(KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationsCheckerKt.checkTypeReferences($receiver, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        Object propertyDescriptor;
        Object functionDescriptor;
        void $receiver$iv;
        Object classDescriptor;
        KtClassOrObject $receiver$iv2;
        Map.Entry $i$f$component1;
        Intrinsics.checkParameterIsNotNull((Object)bodiesResolveContext, (String)"bodiesResolveContext");
        Iterator<Object> iterator2 = bodiesResolveContext.getFiles().iterator();
        while (iterator2.hasNext()) {
            KtFile entry;
            KtFile ktFile = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            KtAnnotated ktAnnotated = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotated, (String)"file");
            this.annotationChecker.check(ktAnnotated, this.trace, null);
        }
        iterator2 = bodiesResolveContext.getDeclaredClasses().entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv22;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            KtClassOrObject classOrObject = (KtClassOrObject)$receiver$iv22.getKey();
            $i$f$component1 = entry;
            classDescriptor = (ClassDescriptorWithResolutionScopes)$receiver$iv2.getValue();
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"classDescriptor");
            PsiElement psiElement2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"classOrObject");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement2);
            KtClassOrObject ktClassOrObject = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject, (String)"classOrObject");
            this.checkTypesInClassHeader(ktClassOrObject);
            Object object = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"classDescriptor");
            this.checkClassOrObjectMembers((ClassDescriptorWithResolutionScopes)object);
            $receiver$iv2 = classOrObject;
            if ($receiver$iv2 instanceof KtClass) {
                KtClass ktClass = (KtClass)classOrObject;
                Object object2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"classDescriptor");
                this.checkClassButNotObject(ktClass, (ClassDescriptorWithResolutionScopes)object2);
                this.descriptorResolver.checkNamesInConstraints(classOrObject, (DeclarationDescriptor)classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
            } else if ($receiver$iv2 instanceof KtObjectDeclaration) {
                KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)classOrObject;
                Object object3 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"classDescriptor");
                this.checkObject(ktObjectDeclaration, (ClassDescriptorWithResolutionScopes)object3);
            }
            KtClassOrObject ktClassOrObject2 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject2, (String)"classOrObject");
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
            this.checkPrimaryConstructor(ktClassOrObject2, classDescriptor2);
            this.checkTypeReferences(classOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, (MemberDescriptor)classDescriptor);
            KtDeclaration ktDeclaration = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"classOrObject");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
            KtClassOrObject ktClassOrObject3 = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject3, (String)"classOrObject");
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"classDescriptor");
            this.checkClassExposedType(ktClassOrObject3, classDescriptor3);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            classDescriptor = entry;
            KtNamedFunction function2 = (KtNamedFunction)$receiver$iv.getKey();
            $i$f$component1 = entry;
            functionDescriptor = (SimpleFunctionDescriptor)$receiver$iv2.getValue();
            KtNamedFunction ktNamedFunction = function2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedFunction, (String)"function");
            Object object = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"functionDescriptor");
            this.checkFunction(ktNamedFunction, (SimpleFunctionDescriptor)object);
            this.checkTypeReferences(function2);
            this.modifiersChecker.checkModifiersForDeclaration(function2, (MemberDescriptor)functionDescriptor);
            KtDeclaration ktDeclaration = function2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"function");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            functionDescriptor = entry;
            KtProperty property2 = (KtProperty)$receiver$iv.getKey();
            $i$f$component1 = entry;
            propertyDescriptor = (PropertyDescriptor)$receiver$iv2.getValue();
            KtProperty ktProperty = property2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"property");
            Object object = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"propertyDescriptor");
            this.checkProperty(ktProperty, (PropertyDescriptor)object);
            this.checkTypeReferences(property2);
            this.modifiersChecker.checkModifiersForDeclaration(property2, (MemberDescriptor)propertyDescriptor);
            KtDeclaration ktDeclaration = property2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"property");
            this.identifierChecker.checkDeclaration(ktDeclaration, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor;
            propertyDescriptor = entry;
            KtSecondaryConstructor declaration = (KtSecondaryConstructor)$receiver$iv.getKey();
            $i$f$component1 = entry;
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = (ConstructorDescriptor)$receiver$iv2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)constructorDescriptor2, (String)"constructorDescriptor");
            KtDeclaration ktDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"declaration");
            this.checkConstructorDeclaration(constructorDescriptor2, ktDeclaration);
            KtFunction ktFunction = declaration;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction, (String)"declaration");
            FunctionDescriptor functionDescriptor2 = constructorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"constructorDescriptor");
            this.checkFunctionExposedType(ktFunction, functionDescriptor2);
        }
    }

    private final void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        this.checkTypeReferences(declaration);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file) {
        KtPackageDirective ktPackageDirective = file.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            Unit unit;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() != null) {
                void $receiver$iv;
                KtSimpleNameExpression it = (KtSimpleNameExpression)$receiver$iv;
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        KtAnnotated ktAnnotated = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotated, (String)"packageDirective");
        this.annotationChecker.check(ktAnnotated, this.trace, null);
        KtModifierListOwner ktModifierListOwner = packageDirective;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierListOwner, (String)"packageDirective");
        ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, this.trace, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        Function1<KtTypeReference, KotlinType> type$ = new Function1<KtTypeReference, KotlinType>(this){
            final /* synthetic */ DeclarationsChecker this$0;

            @Nullable
            public final KotlinType invoke(KtTypeReference $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (KotlinType)DeclarationsChecker.access$getTrace$p(this.this$0).getBindingContext().get(BindingContext.TYPE, $receiver);
            }
            {
                this.this$0 = declarationsChecker;
                super(1);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            Unit unit;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference2) != null) {
                void $receiver$iv;
                KotlinType it = (KotlinType)$receiver$iv;
                DescriptorResolver.checkBounds(typeReference2, it, this.trace);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            DeclarationsCheckerKt.checkNotEnumEntry(typeReference2, this.trace);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter.getExtendsBound() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            if (constraint.getBoundTypeReference() == null) {
                continue;
            }
            if (type$.invoke(typeReference) == null) {
                continue;
            }
            Object object = constraint.getSubjectTypeParameterName();
            if (object == null || (object = object.getReferencedNameAsName()) == null) {
                continue;
            }
            Object name2 = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name2, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            DescriptorResolver.checkBounds(request.upperBound, request.upperBoundType, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        block14: {
            KtElement ktElement;
            void otherBounds;
            void boundsWhichAreTypeParameters;
            Object pair2;
            TypeConstructor typeConstructor2;
            Collection collection;
            block13: {
                void $receiver$iv;
                void destination$iv$iv;
                void $receiver$iv$iv;
                Iterable $receiver$iv2;
                List<KotlinType> upperBounds = descriptor2.getUpperBounds();
                Iterable iterable = upperBounds;
                void var9_6 = $receiver$iv2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void type2;
                    KotlinType kotlinType = (KotlinType)item$iv$iv;
                    collection = destination$iv$iv;
                    typeConstructor2 = type2.getConstructor();
                    collection.add(typeConstructor2);
                }
                $receiver$iv2 = (List)destination$iv$iv;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv2 : $receiver$iv2) {
                    TypeConstructor constructor = (TypeConstructor)element$iv2;
                    if (constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                        first$iv.add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                $receiver$iv2 = new Pair(first$iv, second$iv);
                pair2 = (Pair)$receiver$iv2;
                Object object = TuplesKt.to((Object)CollectionsKt.toSet((Iterable)((Iterable)pair2.getFirst())), (Object)CollectionsKt.toSet((Iterable)((Iterable)pair2.getSecond())));
                Set set = (Set)object.component1();
                Set set2 = (Set)object.component2();
                object = null;
                if (boundsWhichAreTypeParameters.size() > 1) break block13;
                if (boundsWhichAreTypeParameters.size() != 1) break block14;
                object = (Collection)otherBounds;
                if (!(!$receiver$iv.isEmpty())) break block14;
            }
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object;
                Object v3;
                block12: {
                    void $receiver$iv;
                    Object element$iv$iv$iv;
                    Iterator $receiver$iv$iv$iv;
                    Collection destination$iv$iv;
                    Object element$iv$iv2;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv3;
                    Object element$iv2;
                    pair2 = owner.getTypeConstraints();
                    void $i$a$3 = $receiver$iv3;
                    Collection $i$f$let = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv) {
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv2;
                        KtSimpleNameExpression ktSimpleNameExpression = constraint.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)declaration.getNameAsName())) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    $receiver$iv3 = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv3;
                    destination$iv$iv = new ArrayList();
                    element$iv2 = $receiver$iv$iv;
                    element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        Boolean bl;
                        element$iv$iv$iv = element$iv$iv2.next();
                        Object element$iv$iv3 = element$iv$iv$iv;
                        KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv3;
                        if (constraint.getBoundTypeReference() != null) {
                            void $receiver$iv$iv$iv2;
                            void it$iv$iv = $receiver$iv$iv$iv2;
                            bl = destination$iv$iv.add(it$iv$iv);
                            continue;
                        }
                        bl = null;
                    }
                    $receiver$iv3 = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv3;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void typeReference;
                        element$iv$iv$iv = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv;
                        typeConstructor2 = TuplesKt.to((Object)typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                        collection.add(typeConstructor2);
                    }
                    List allBounds = (List)destination$iv$iv;
                    $receiver$iv$iv = allBounds;
                    for (Object element$iv2 : $receiver$iv) {
                        Pair bound = (Pair)element$iv2;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(Intrinsics.areEqual((Object)(kotlinType != null ? kotlinType.getConstructor() : null), (Object)((TypeConstructor)CollectionsKt.first((Iterable)((Iterable)boundsWhichAreTypeParameters)))) ^ true)) continue;
                        v3 = element$iv2;
                        break block12;
                    }
                    v3 = null;
                }
                ktElement = (object = (problematicBound = (Pair)v3)) != null && (object = (KtTypeReference)object.getFirst()) != null ? (KtElement)object : (KtElement)declaration;
            } else {
                ktElement = declaration;
            }
            KtElement reportOn = ktElement;
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        void $receiver$iv;
        Annotated annotated;
        Map map2;
        Map destination$iv$iv;
        Iterator iterator2;
        Object object;
        if (classifier2 instanceof TypeParameterDescriptor) {
            void $receiver$iv$iv;
            void $receiver$iv2;
            object = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            iterator2 = $receiver$iv2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                map2 = destination$iv$iv;
                annotated = it.getConstructor();
                map2.add(annotated);
            }
            List immediateUpperBounds = (List)((Object)destination$iv$iv);
            if (immediateUpperBounds.size() != CollectionsKt.toSet((Iterable)immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        destination$iv$iv = multiMap.asMap();
        iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor containingDeclaration;
            void destination$iv$iv2;
            void $receiver$iv$iv;
            void $receiver$iv3;
            void $receiver$iv4;
            void $receiver$iv5;
            Object $i$f$iterator = object = iterator2.next();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)$receiver$iv5.getKey();
            Object $i$f$component1 = object;
            Collection projections = (Collection)$receiver$iv4.getValue();
            if (projections.size() <= 1) continue;
            Iterable $i$f$component2 = projections;
            void $i$a$1 = $receiver$iv3;
            Collection $i$f$mapTo = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                map2 = destination$iv$iv2;
                annotated = it.getType();
                map2.add(annotated);
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor declarationDescriptor = typeParameterDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkClassExposedType(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        this.checkExposedSupertypes(klass, classDescriptor);
        this.checkExposedParameterBounds(klass, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor constructor = ktPrimaryConstructor;
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor constructorDescriptor2 = constructorDescriptor;
        KtFunction ktFunction = constructor;
        FunctionDescriptor functionDescriptor = constructorDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"constructorDescriptor");
        this.checkFunctionExposedType(ktFunction, functionDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExposedParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        void $receiver$iv;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        List<KtTypeParameter> typeParameterList = klass.getTypeParameters();
        Iterable iterable = classDescriptor.getDeclaredTypeParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void typeParameterDescriptor;
            int n = index$iv++;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            if (i >= typeParameterList.size()) {
                return;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                EffectiveVisibility upperBoundVisibility = EffectiveVisibilityKt.effectiveVisibility(upperBound);
                if (upperBoundVisibility.sameOrMorePermissive(classVisibility)) continue;
                this.trace.report(Errors.EXPOSED_TYPE_PARAMETER_BOUND.on((KtTypeParameter)((PsiElement)typeParameterList.get(i)), classVisibility, upperBoundVisibility));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExposedSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        void $receiver$iv;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        boolean isInterface = Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE));
        List<KtSuperTypeListEntry> delegationList = klass.getSuperTypeListEntries();
        Iterable iterable = classDescriptor.getTypeConstructor().getSupertypes();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            EffectiveVisibility superTypeVisibility;
            ClassDescriptor superDescriptor;
            void superType;
            int n = index$iv++;
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            if (i >= delegationList.size()) {
                return;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) {
                continue;
            }
            boolean superIsInterface = Intrinsics.areEqual((Object)((Object)superDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE));
            if (superIsInterface != isInterface || (superTypeVisibility = EffectiveVisibilityKt.effectiveVisibility((KotlinType)superType)).sameOrMorePermissive(classVisibility)) continue;
            if (isInterface) {
                this.trace.report(Errors.EXPOSED_SUPER_INTERFACE.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
                continue;
            }
            this.trace.report(Errors.EXPOSED_SUPER_CLASS.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, superTypeVisibility));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClassButNotObject(KtClass aClass2, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass2);
        this.checkTypeParameterConstraints(aClass2);
        FiniteBoundRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        if (aClass2.isInterface()) {
            this.checkConstructorInInterface(aClass2);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass2.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass2), classDescriptor));
            }
        } else if (Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.ANNOTATION_CLASS))) {
            this.checkAnnotationClassWithBody(aClass2);
            this.checkValOnAnnotationParameter(aClass2);
        } else if (aClass2 instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass2, classDescriptor);
        }
    }

    private final void checkClassOrObjectMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtFunction member;
            if (Intrinsics.areEqual((Object)((Object)memberDescriptor.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"memberDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement2 instanceof KtFunction)) {
                psiElement2 = null;
            }
            if ((member = (KtFunction)psiElement2) == null || !(memberDescriptor instanceof FunctionDescriptor)) continue;
            this.checkFunctionExposedType(member, (FunctionDescriptor)memberDescriptor);
            this.checkVarargParameters(this.trace, memberDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor primaryConstructor2 = constructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtElementImplStub parameter : declaration.getValueParameters()) {
            Unit unit;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) != null) {
                void $receiver$iv;
                PropertyDescriptor it = (PropertyDescriptor)$receiver$iv;
                this.modifiersChecker.checkModifiersForDeclaration((KtDeclaration)((Object)parameter), it);
                KtCallableDeclaration ktCallableDeclaration = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktCallableDeclaration, (String)"parameter");
                PropertyDescriptor propertyDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"it");
                this.checkPropertyLateInit(ktCallableDeclaration, propertyDescriptor);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        if (!declaration.hasConstructorKeyword()) {
            Unit unit;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                void $receiver$iv;
                KtElementImplStub parameter;
                parameter = ktModifierList;
                KtModifierList it = (KtModifierList)$receiver$iv;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)((PsiElement)it)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        ConstructorDescriptor constructorDescriptor2 = primaryConstructor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)constructorDescriptor2, (String)"primaryConstructor");
        this.checkConstructorDeclaration(constructorDescriptor2, declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            Unit unit;
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) != null) {
                void $receiver$iv;
                TypeParameterDescriptor it = (TypeParameterDescriptor)$receiver$iv;
                DescriptorResolver.checkConflictingUpperBounds(this.trace, it, jetTypeParameter);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter.getExtendsBound() != null) {
                KtTypeParameter ktTypeParameter = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameter, (String)"typeParameter");
                List<KtTypeConstraint> list2 = constraints;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constraints");
                if (DeclarationsChecker.Companion.hasConstraints(ktTypeParameter, list2)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) {
                continue;
            }
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"typeParameterDescriptor");
            PsiElement psiElement2 = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"typeParameter");
            this.checkSupertypesForConsistency(classifierDescriptor, psiElement2);
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor2, (String)"typeParameterDescriptor");
            KtTypeParameter ktTypeParameter = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameter, (String)"typeParameter");
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor2, ktTypeParameter, typeParameterListOwner);
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        Unit unit;
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            KtPrimaryConstructor $receiver$iv = ktPrimaryConstructor;
            KtPrimaryConstructor it = $receiver$iv;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassWithBody(KtClassOrObject classOrObject) {
        Unit unit;
        KtClassBody ktClassBody = classOrObject.getBody();
        if (ktClassBody != null) {
            KtClassBody $receiver$iv = ktClassBody;
            KtClassBody it = $receiver$iv;
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on((PsiElement)it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass2) {
        for (KtParameter parameter : aClass2.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            KtNamedDeclaration member;
            if (Intrinsics.areEqual((Object)((Object)memberDescriptor.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = memberDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"memberDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                psiElement2 = null;
            }
            if ((member = (KtNamedDeclaration)psiElement2) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.OBJECT))) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"containingDeclaration");
            this.checkPropertyAbstractness(property2, propertyDescriptor, classDescriptor);
        }
        this.checkPropertyLateInit(property2, propertyDescriptor);
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkTypeParameterConstraints(property2);
        this.checkPropertyExposedType(property2, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property2, propertyDescriptor);
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        Set allTypeParameters = CollectionsKt.toSet((Iterable)descriptor2.getTypeParameters());
        HashSet allAccessibleTypeParameters = new HashSet();
        Function1<KotlinType, Unit> addAccessibleTypeParametersFromType$ = new Function1<KotlinType, Unit>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set $allTypeParameters;
            final /* synthetic */ HashSet $allAccessibleTypeParameters;

            public final void invoke(@Nullable KotlinType type2) {
                TypeUtils.contains(type2, (Function1<KotlinType, Boolean>)((Function1)new Function1<KotlinType, Boolean>(this){
                    final /* synthetic */ checkPropertyTypeParametersAreUsedInReceiverType.1 this$0;

                    public final boolean invoke(KotlinType it) {
                        ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                        if (declarationDescriptor instanceof TypeParameterDescriptor && this.this$0.$allTypeParameters.contains(declarationDescriptor) && this.this$0.$allAccessibleTypeParameters.add(declarationDescriptor)) {
                            Iterable $receiver$iv = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                            for (T element$iv : $receiver$iv) {
                                KotlinType it2 = (KotlinType)element$iv;
                                this.this$0.invoke(it2);
                            }
                        }
                        return false;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$allTypeParameters = set;
                this.$allAccessibleTypeParameters = hashSet;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        addAccessibleTypeParametersFromType$.invoke(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        Set typeParametersInaccessibleFromReceiver = SetsKt.minus((Set)allTypeParameters, (Iterable)allAccessibleTypeParameters);
        for (TypeParameterDescriptor typeParameter : typeParametersInaccessibleFromReceiver) {
            DeclarationDescriptor declarationDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkPropertyLateInit(KtCallableDeclaration property2, PropertyDescriptor propertyDescriptor) {
        boolean hasBackingField;
        boolean isAbstract;
        KtModifierList ktModifierList = property2.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList = ktModifierList;
        PsiElement psiElement2 = modifierList.getModifier(KtTokens.LATEINIT_KEYWORD);
        if (psiElement2 == null) {
            return;
        }
        PsiElement modifier = psiElement2;
        if (!propertyDescriptor.isVar()) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is allowed only on mutable properties"));
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        KotlinType returnType2 = propertyDescriptor.getReturnType();
        if (returnType2 != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType2);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType2);
        }
        if (returnTypeIsNullable) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on nullable properties"));
        }
        if (returnTypeIsPrimitive) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primitive type properties"));
        }
        if (isAbstract = Intrinsics.areEqual((Object)((Object)propertyDescriptor.getModality()), (Object)((Object)Modality.ABSTRACT))) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on abstract properties"));
        }
        if (property2 instanceof KtParameter) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on primary constructor parameters"));
        }
        boolean hasDelegateExpressionOrInitializer = false;
        if (property2 instanceof KtProperty && ((KtProperty)property2).hasDelegateExpressionOrInitializer()) {
            hasDelegateExpressionOrInitializer = true;
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with initializer or on delegated properties"));
        }
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        if (!hasDelegateExpressionOrInitializer && hasAccessorImplementation) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties with a custom getter or setter"));
        }
        Boolean bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl2 = hasBackingField = bl != null ? bl : false;
        if (!(isAbstract || hasAccessorImplementation || hasDelegateExpressionOrInitializer || hasBackingField)) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on properties without backing field"));
        }
        if (propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier, "is not allowed on extension properties"));
        }
    }

    private final void checkPropertyAbstractness(KtProperty property2, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList = property2.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                PsiElement psiElement2 = property2;
                String string = property2.getName();
                if (string == null) {
                    string = "";
                }
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement2, string, classDescriptor));
                return;
            }
            if (Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property2)));
            }
        }
        if (Intrinsics.areEqual((Object)((Object)propertyDescriptor.getModality()), (Object)((Object)Modality.ABSTRACT))) {
            KtPropertyAccessor setter;
            Unit unit;
            Unit unit2;
            KtElement it;
            KtPropertyDelegate $receiver$iv;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression != null) {
                KtExpression ktExpression2 = ktExpression;
                it = (KtExpression)((Object)$receiver$iv);
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)((PsiElement)it)));
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
            if (ktPropertyDelegate != null) {
                $receiver$iv = ktPropertyDelegate;
                it = $receiver$iv;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)((PsiElement)it)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            KtPropertyAccessor getter = property2.getGetter();
            if (getter != null && getter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
            }
            if ((setter = property2.getSetter()) != null && setter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkPropertyInitializer(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        boolean backingFieldRequired;
        boolean inTrait;
        boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean bl = inTrait = containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)containingDeclaration).getKind()), (Object)((Object)ClassKind.INTERFACE));
        if (Intrinsics.areEqual((Object)((Object)propertyDescriptor.getModality()), (Object)((Object)Modality.ABSTRACT))) {
            if (!property2.hasDelegateExpressionOrInitializer() && property2.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property2)));
            }
            if (!inTrait) return;
            if (!property2.hasModifier(KtTokens.PRIVATE_KEYWORD)) return;
            if (property2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) return;
            this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property2)));
            return;
        }
        Boolean bl2 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl3 = backingFieldRequired = bl2 != null ? bl2 : false;
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property2)));
        }
        KtExpression initializer2 = property2.getInitializer();
        KtPropertyDelegate delegate2 = property2.getDelegate();
        if (initializer2 != null) {
            if (inTrait) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer2)));
                return;
            }
            if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
                return;
            }
            if (property2.getReceiverTypeReference() == null) return;
            this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            return;
        }
        if (delegate2 != null) {
            if (!inTrait) return;
            this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate2)));
            return;
        }
        if (backingFieldRequired && !inTrait && !propertyDescriptor.isLateInit()) {
            Boolean bl4 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            if (bl4 != null ? bl4 : false) {
                if (containingDeclaration instanceof ClassDescriptor && !hasAccessorImplementation) {
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property2)));
                    return;
                }
                this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property2)));
                return;
            }
        }
        if (property2.getTypeReference() != null) return;
        this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property2)));
    }

    private final void checkMemberReceiverExposedType(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityKt.effectiveVisibility(memberDescriptor);
        EffectiveVisibility receiverTypeVisibility = EffectiveVisibilityKt.effectiveVisibility(receiverParameterDescriptor2.getType());
        if (!receiverTypeVisibility.sameOrMorePermissive(memberVisibility)) {
            this.trace.report(Errors.EXPOSED_RECEIVER_TYPE.on((KtTypeReference)((PsiElement)typeReference), memberVisibility, receiverTypeVisibility));
        }
    }

    private final void checkPropertyExposedType(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        EffectiveVisibility propertyVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor);
        EffectiveVisibility typeVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor.getType());
        if (!typeVisibility.sameOrMorePermissive(propertyVisibility)) {
            PsiElement psiElement2 = property2.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = property2;
            }
            this.trace.report(Errors.EXPOSED_PROPERTY_TYPE.on(psiElement2, propertyVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(property2.getReceiverTypeReference(), propertyDescriptor);
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function2);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = function2.hasModifier(KtTokens.EXTERNAL_KEYWORD);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait = Intrinsics.areEqual((Object)((Object)((ClassDescriptor)containingDescriptor).getKind()), (Object)((Object)ClassKind.INTERFACE));
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inTrait && function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            return;
        }
        if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier)) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        this.checkImplicitCallableType(function2, functionDescriptor);
        this.checkFunctionExposedType(function2, functionDescriptor);
        this.checkVarargParameters(this.trace, functionDescriptor);
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        Unit unit;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            if (declaration.getTypeReference() == null) {
                PsiElement target;
                PsiElement psiElement2 = declaration.getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = target = (PsiElement)declaration;
                }
                if (TypeUtilsKt.isNothing(it)) {
                    this.trace.report((declaration instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (it.getConstructor() instanceof IntersectionTypeConstructor) {
                    this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunctionExposedType(KtFunction function2, FunctionDescriptor functionDescriptor) {
        void $receiver$iv;
        Object returnTypeVisibility;
        EffectiveVisibility functionVisibility = EffectiveVisibilityKt.effectiveVisibility(functionDescriptor);
        if (!(function2 instanceof KtConstructor)) {
            KotlinType kotlinType = functionDescriptor.getReturnType();
            Object object = returnTypeVisibility = kotlinType != null ? EffectiveVisibilityKt.effectiveVisibility(kotlinType) : null;
            if (returnTypeVisibility != null && !((EffectiveVisibility)returnTypeVisibility).sameOrMorePermissive(functionVisibility)) {
                PsiElement psiElement2 = function2.getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = function2;
                }
                this.trace.report(Errors.EXPOSED_FUNCTION_RETURN_TYPE.on(psiElement2, functionVisibility, (EffectiveVisibility)returnTypeVisibility));
            }
        }
        returnTypeVisibility = functionDescriptor.getValueParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void parameterDescriptor;
            int n = index$iv++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            EffectiveVisibility typeVisibility = EffectiveVisibilityKt.effectiveVisibility(parameterDescriptor.getType());
            if (typeVisibility.sameOrMorePermissive(functionVisibility) || i >= function2.getValueParameters().size()) continue;
            this.trace.report(Errors.EXPOSED_PARAMETER_TYPE.on((KtParameter)((PsiElement)function2.getValueParameters().get(i)), functionVisibility, typeVisibility));
        }
        this.checkMemberReceiverExposedType(function2.getReceiverTypeReference(), functionDescriptor);
    }

    private final void checkAccessors(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property2.getGetter() : property2.getSetter();
            if (accessor != null) {
                this.checkTypeReferences(accessor);
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property2, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property2.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property2.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens2, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement2 : tokens2) {
            this.trace.report(diagnostic.on(psiElement2));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> tokens2 = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, Sets.newHashSet((Object[])new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD}));
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens2.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens2.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)Visibilities.PRIVATE) && Intrinsics.areEqual((Object)propertyDescriptor.getVisibility(), (Object)Visibilities.PRIVATE) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)propertyDescriptor.getModality()), (Object)((Object)Modality.ABSTRACT))) {
                Collection<PsiElement> collection = tokens2.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens2.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = Visibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || ((Number)compare).intValue() > 0) {
                Collection<PsiElement> collection = tokens2.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.SETTER_VISIBILITY\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor classDescriptor) {
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isEnumClass(declaration)) {
            if (!enumEntry.hasInitializer()) {
                DeclarationDescriptor declarationDescriptor = declaration;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                if (!DeclarationsChecker.Companion.hasDefaultConstructor((ClassDescriptor)declarationDescriptor)) {
                    this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on((KtClass)((PsiElement)enumEntry)));
                }
            }
        } else {
            Unit unit;
            boolean bl = DescriptorUtils.isInterface(declaration);
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Enum entry should be declared in enum class: " + classDescriptor;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        void $receiver$iv;
        Iterable iterable = callableDescriptor.getValueParameters();
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it.getVarargElementType() != null)) continue;
            ++count$iv;
        }
        int numberOfVarargParameters = count$iv;
        if (numberOfVarargParameters > 1) {
            for (ValueParameterDescriptor parameter : callableDescriptor.getValueParameters()) {
                if (parameter.getVarargElementType() == null) continue;
                DeclarationDescriptor declarationDescriptor = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"parameter");
                PsiElement parameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (!(parameterDeclaration instanceof KtParameter)) continue;
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)parameterDeclaration));
            }
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkParameterIsNotNull((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkParameterIsNotNull((Object)annotationChecker, (String)"annotationChecker");
        Intrinsics.checkParameterIsNotNull((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.modifiersChecker = modifiersChecker.withTrace(this.trace);
    }

    static {
        Companion = new Companion(null);
        METHOD_OF_ANY_NAMES = ImmutableSet.of((Object)"toString", (Object)"hashCode", (Object)"equals");
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(DeclarationsChecker $this) {
        return $this.trace;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0002J\f\u0010\u001e\u001a\u00020\n*\u00020\u001fH\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "getMETHOD_OF_ANY_NAMES", "()Lcom/google/common/collect/ImmutableSet;", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "hasDefaultConstructor", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
    public static final class Companion {
        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block2: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $receiver$iv = constraints;
                for (Object element$iv : $receiver$iv) {
                    KtTypeConstraint it = (KtTypeConstraint)element$iv;
                    KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)typeParameter.getName())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private final ImmutableSet<String> getMETHOD_OF_ANY_NAMES() {
            return METHOD_OF_ANY_NAMES;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!this.getMETHOD_OF_ANY_NAMES().contains((Object)member.getName().asString())) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((Object)member.getModality()), (Object)((Object)Modality.ABSTRACT))) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual((Object)DescriptorUtils.getFqName(containingDeclaration), (Object)KotlinBuiltIns.FQ_NAMES.any)) {
                    return true;
                }
                CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"overridden");
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor2)) continue;
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration");
                visitedClasses.add((ClassDescriptor)declarationDescriptor);
                CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor3, (String)"overridden");
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor3, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement2 instanceof KtNamedDeclaration)) {
                psiElement2 = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement2;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList = ktModifierList;
            return !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean hasDefaultConstructor(ClassDescriptor classDescriptor) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = classDescriptor.getConstructors();
                for (Object element$iv : $receiver$iv) {
                    ConstructorDescriptor it = (ConstructorDescriptor)element$iv;
                    if (!it.getValueParameters().isEmpty()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasAccessorImplementation(PropertyDescriptor $receiver) {
            Unit unit;
            Unit unit2;
            PropertyAccessorDescriptor it;
            PropertyAccessorDescriptor $receiver$iv;
            PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
            if (propertyGetterDescriptor != null) {
                $receiver$iv = propertyGetterDescriptor;
                it = $receiver$iv;
                if (it.hasBody()) {
                    return true;
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
            if (propertySetterDescriptor != null) {
                $receiver$iv = propertySetterDescriptor;
                it = (PropertySetterDescriptor)$receiver$iv;
                if (it.hasBody()) {
                    return true;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

