/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import com.google.protobuf.GeneratedMessageLite;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "annotationSerializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "getStringTable", "serializeClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Builder;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor$Builder;", "serializeEnumEntry", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$EnumEntry$Builder;", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property$Builder;", "serializeType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Builder;", "serializeTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeParameter$Builder;", "serializeValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$ValueParameter$Builder;", "serialization"})
public class KotlinSerializerExtensionBase
extends SerializerExtension {
    private final StringTableImpl stringTable;
    private final AnnotationSerializer annotationSerializer;
    private final SerializerExtensionProtocol protocol;

    @Override
    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getClassAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getConstructorAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getFunctionAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getPropertyAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
        ConstantValue<?> constantValue = descriptor2.getCompileTimeInitializer();
        if (constantValue == null) {
            return;
        }
        ConstantValue<?> constantInitializer = constantValue;
        if (!(constantInitializer instanceof NullValue)) {
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, ProtoBuf.Annotation.Argument.Value> generatedExtension = this.protocol.getCompileTimeValue();
            ConstantValue<?> constantValue2 = constantInitializer;
            Intrinsics.checkExpressionValueIsNotNull(constantValue2, (String)"constantInitializer");
            proto.setExtension(generatedExtension, this.annotationSerializer.valueProto(constantValue2).build());
        }
    }

    @Override
    public void serializeEnumEntry(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.EnumEntry.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getEnumEntryAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
            proto.addExtension(this.protocol.getParameterAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(this.protocol.getTypeAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        for (AnnotationDescriptor annotation2 : typeParameter.getAnnotations()) {
            proto.addExtension(this.protocol.getTypeParameterAnnotation(), this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    public KotlinSerializerExtensionBase(@NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
        this.protocol = protocol;
        this.stringTable = new StringTableImpl();
        this.annotationSerializer = new AnnotationSerializer(this.stringTable);
    }
}

