/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "localVariableResolver", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;)V", "defineLocalVariablesFromMultiDeclaration", "", "writableScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "reportErrorsOn", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getExpectedTypeForComponent", "Lorg/jetbrains/kotlin/types/KotlinType;", "entry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "kotlin-compiler"})
public final class DestructuringDeclarationResolver {
    private final FakeCallResolver fakeCallResolver;
    private final LocalVariableResolver localVariableResolver;
    private final TypeResolver typeResolver;
    private final SymbolUsageValidator symbolUsageValidator;

    public final void defineLocalVariablesFromMultiDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull KtExpression reportErrorsOn, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(writableScope, "writableScope");
        Intrinsics.checkParameterIsNotNull(destructuringDeclaration, "destructuringDeclaration");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        Intrinsics.checkParameterIsNotNull(reportErrorsOn, "reportErrorsOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)destructuringDeclaration.getEntries())) {
            int componentIndex = indexedValue.component1();
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)indexedValue.component2();
            Name componentName = DataClassUtilsKt.createComponentName(componentIndex + 1);
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclarationEntry, "entry");
            KotlinType expectedType = this.getExpectedTypeForComponent(context, ktDestructuringDeclarationEntry);
            ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)context.replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "context.replaceExpectedType(expectedType)");
            KtExpression ktExpression = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "entry");
            OverloadResolutionResults results = FakeCallResolver.resolveFakeCall$default(this.fakeCallResolver, expressionTypingContext, receiver, componentName, ktExpression, reportErrorsOn, FakeCallKind.COMPONENT, null, 64, null);
            KotlinType componentType = null;
            if (results.isSuccess()) {
                context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)results.getResultingDescriptor();
                ResolvedCall resolvedCall = null;
                CallableDescriptor callableDescriptor = functionDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "functionDescriptor");
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                PsiElement psiElement = entry;
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "entry");
                this.symbolUsageValidator.validateCall(resolvedCall, callableDescriptor, bindingTrace, psiElement);
                componentType = functionDescriptor.getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(componentType, expectedType)) {
                    context.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)reportErrorsOn), componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on((KtExpression)((PsiElement)reportErrorsOn), componentName, results.getResultingCalls()));
            } else {
                context.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on((KtExpression)((PsiElement)reportErrorsOn), componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            LexicalScope lexicalScope = writableScope;
            KtVariableDeclaration ktVariableDeclaration = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktVariableDeclaration, "entry");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$kotlin_compiler(lexicalScope, ktVariableDeclaration, componentType, bindingTrace);
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context.trace, variableDescriptor);
            writableScope.addVariableDescriptor(variableDescriptor);
        }
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            KotlinType kotlinType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.NO_EXPECTED_TYPE");
            return kotlinType;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        KtTypeReference ktTypeReference2 = entryTypeRef;
        Intrinsics.checkExpressionValueIsNotNull(ktTypeReference2, "entryTypeRef");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        return this.typeResolver.resolveType(lexicalScope, ktTypeReference2, bindingTrace, true);
    }

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkParameterIsNotNull(localVariableResolver, "localVariableResolver");
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
        this.symbolUsageValidator = symbolUsageValidator;
    }
}

