/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundUpdaterTask<T>
extends Task.Backgroundable {
    protected AbstractPopup myPopup;
    protected T myComponent;
    private Ref<UsageView> myUsageView;
    private final List<PsiElement> myData = new ArrayList<PsiElement>();
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Object lock = new Object();
    private volatile boolean myCanceled = false;

    public BackgroundUpdaterTask(Project project, String title, boolean canBeCancelled) {
        super(project, title, canBeCancelled);
    }

    public BackgroundUpdaterTask(Project project, String title) {
        super(project, title);
    }

    public BackgroundUpdaterTask(Project project, String title, boolean canBeCancelled, PerformInBackgroundOption backgroundOption) {
        super(project, title, canBeCancelled, backgroundOption);
    }

    public void init(@NotNull AbstractPopup popup, @NotNull T component, @NotNull Ref<UsageView> usageView) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInsight/navigation/BackgroundUpdaterTask", "init"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/codeInsight/navigation/BackgroundUpdaterTask", "init"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/codeInsight/navigation/BackgroundUpdaterTask", "init"));
        }
        this.myPopup = popup;
        this.myComponent = component;
        this.myUsageView = usageView;
    }

    public abstract String getCaption(int var1);

    protected abstract void replaceModel(@NotNull List<PsiElement> var1);

    protected abstract void paintBusy(boolean var1);

    public boolean setCanceled() {
        boolean canceled = this.myCanceled;
        this.myCanceled = true;
        return canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(final PsiElement element, final @Nullable Comparator comparator2) {
        final UsageView view = (UsageView)this.myUsageView.get();
        if (view != null && !((UsageViewImpl)view).isDisposed()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    view.appendUsage((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element)));
                }
            });
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        JComponent content = this.myPopup.getContent();
        if (content == null || this.myPopup.isDisposed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.contains(element)) {
                return true;
            }
            this.myData.add(element);
        }
        this.myAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BackgroundUpdaterTask.this.myAlarm.cancelAllRequests();
                if (BackgroundUpdaterTask.this.myCanceled) {
                    return;
                }
                if (BackgroundUpdaterTask.this.myPopup.isDisposed()) {
                    return;
                }
                ArrayList<PsiElement> data = new ArrayList<PsiElement>();
                Object object = BackgroundUpdaterTask.this.lock;
                synchronized (object) {
                    if (comparator2 != null) {
                        Collections.sort(BackgroundUpdaterTask.this.myData, comparator2);
                    }
                    data.addAll(BackgroundUpdaterTask.this.myData);
                }
                BackgroundUpdaterTask.this.replaceModel(data);
                BackgroundUpdaterTask.this.myPopup.setCaption(BackgroundUpdaterTask.this.getCaption(BackgroundUpdaterTask.this.getCurrentSize()));
                BackgroundUpdaterTask.this.myPopup.pack(true, true);
            }
        }, 200, ModalityState.stateForComponent((Component)content));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.size();
        }
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/navigation/BackgroundUpdaterTask", "run"));
        }
        this.paintBusy(true);
    }

    public void onSuccess() {
        this.myPopup.setCaption(this.getCaption(this.getCurrentSize()));
        this.paintBusy(false);
    }
}

