/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.execution.console.CustomizableConsoleFoldingBean;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@State(name="ConsoleFoldingSettings", storages={@Storage(file="$APP_CONFIG$/consoleFolding.xml")})
public class ConsoleFoldingSettings
implements PersistentStateComponent<MyBean> {
    private final List<String> myPositivePatterns = new ArrayList<String>();
    private final List<String> myNegativePatterns = new ArrayList<String>();

    public ConsoleFoldingSettings() {
        for (CustomizableConsoleFoldingBean regexp : (CustomizableConsoleFoldingBean[])CustomizableConsoleFoldingBean.EP_NAME.getExtensions()) {
            this.patternList(regexp.negate).add(regexp.substring);
        }
    }

    public static ConsoleFoldingSettings getSettings() {
        return (ConsoleFoldingSettings)ServiceManager.getService(ConsoleFoldingSettings.class);
    }

    public boolean shouldFoldLine(String line) {
        return ConsoleFoldingSettings.containsAny(line, this.myPositivePatterns) && !ConsoleFoldingSettings.containsAny(line, this.myNegativePatterns);
    }

    private static boolean containsAny(String line, List<String> patterns) {
        for (String pattern : patterns) {
            if (!line.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public List<String> getPositivePatterns() {
        return this.myPositivePatterns;
    }

    public List<String> getNegativePatterns() {
        return this.myNegativePatterns;
    }

    public MyBean getState() {
        MyBean result2 = new MyBean();
        this.writeDiff(result2.addedPositive, result2.removedPositive, false);
        this.writeDiff(result2.addedNegative, result2.removedNegative, true);
        return result2;
    }

    private void writeDiff(List<String> added, List<String> removed, boolean negated) {
        THashSet baseline = ContainerUtil.newTroveSet();
        for (CustomizableConsoleFoldingBean regexp : (CustomizableConsoleFoldingBean[])CustomizableConsoleFoldingBean.EP_NAME.getExtensions()) {
            if (regexp.negate != negated) continue;
            baseline.add(regexp.substring);
        }
        List<String> current = this.patternList(negated);
        added.addAll(current);
        added.removeAll((Collection<?>)baseline);
        baseline.removeAll(current);
        removed.addAll((Collection<String>)baseline);
    }

    private List<String> patternList(boolean negated) {
        return negated ? this.myNegativePatterns : this.myPositivePatterns;
    }

    private Collection<String> filterEmptyStringsFromCollection(Collection<String> collection) {
        return Collections2.filter(collection, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return !StringUtil.isEmpty((String)input);
            }
        });
    }

    public void loadState(MyBean state) {
        this.myPositivePatterns.clear();
        this.myNegativePatterns.clear();
        HashSet<String> removedPositive = new HashSet<String>(state.removedPositive);
        HashSet<String> removedNegative = new HashSet<String>(state.removedNegative);
        for (CustomizableConsoleFoldingBean regexp : (CustomizableConsoleFoldingBean[])CustomizableConsoleFoldingBean.EP_NAME.getExtensions()) {
            if ((regexp.negate ? removedNegative : removedPositive).contains(regexp.substring)) continue;
            this.patternList(regexp.negate).add(regexp.substring);
        }
        this.myPositivePatterns.addAll(this.filterEmptyStringsFromCollection(state.addedPositive));
        this.myNegativePatterns.addAll(this.filterEmptyStringsFromCollection(state.addedNegative));
    }

    public static class MyBean {
        public List<String> addedPositive = new ArrayList<String>();
        public List<String> addedNegative = new ArrayList<String>();
        public List<String> removedPositive = new ArrayList<String>();
        public List<String> removedNegative = new ArrayList<String>();
    }
}

