/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHelper {
    public static <T extends PsiElement> void openFilesInEditor(@NotNull T[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/EditorHelper", "openFilesInEditor"));
        }
        int limit = UISettings.getInstance().EDITOR_TAB_LIMIT;
        int max = Math.min(limit, elements.length);
        for (int i = 0; i < max; ++i) {
            EditorHelper.openInEditor(elements[i], true);
        }
    }

    public static Editor openInEditor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/EditorHelper", "openInEditor"));
        }
        FileEditor editor = EditorHelper.openInEditor(element, true);
        return editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null;
    }

    @Nullable
    public static FileEditor openInEditor(@NotNull PsiElement element, boolean switchToText) {
        int offset;
        PsiFile file2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/EditorHelper", "openInEditor"));
        }
        if (element instanceof PsiFile) {
            file2 = (PsiFile)element;
            offset = -1;
        } else {
            file2 = element.getContainingFile();
            offset = element.getTextOffset();
        }
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(element.getProject(), virtualFile, offset);
        Project project = element.getProject();
        if (offset == -1 && !switchToText) {
            FileEditorManager.getInstance((Project)project).openEditor(descriptor, false);
        } else {
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, false);
        }
        return FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
    }
}

