/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.impl.FragmentNumberGutterIconRenderer;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighterImpl;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NumberedFragmentHighlighter
extends FragmentHighlighterImpl {
    private final boolean myDrawNumber;
    private final Map<Integer, Pair<String, TextDiffTypeEnum>> myLeftPrecalculated;
    private final Map<Integer, Pair<String, TextDiffTypeEnum>> myRightPrecalculated;
    private int myPreviousLineLeft;
    private int myPreviousLineRight;
    private MyPropertyChangeListener myPropertyChangeListener;

    public NumberedFragmentHighlighter(DiffMarkup appender1, DiffMarkup appender2, boolean drawNumber) {
        super(appender1, appender2);
        this.myDrawNumber = drawNumber;
        this.myLeftPrecalculated = new HashMap<Integer, Pair<String, TextDiffTypeEnum>>();
        this.myRightPrecalculated = new HashMap<Integer, Pair<String, TextDiffTypeEnum>>();
        this.myPreviousLineLeft = -1;
        this.myPreviousLineRight = -1;
    }

    private TextAttributesKey getColorAttributesKey(TextDiffTypeEnum textDiffTypeEnum) {
        if (TextDiffTypeEnum.CHANGED.equals((Object)textDiffTypeEnum)) {
            return DiffColors.DIFF_MODIFIED;
        }
        if (TextDiffTypeEnum.INSERT.equals((Object)textDiffTypeEnum)) {
            return DiffColors.DIFF_INSERTED;
        }
        if (TextDiffTypeEnum.DELETED.equals((Object)textDiffTypeEnum)) {
            return DiffColors.DIFF_DELETED;
        }
        if (TextDiffTypeEnum.CONFLICT.equals((Object)textDiffTypeEnum)) {
            return DiffColors.DIFF_CONFLICT;
        }
        return null;
    }

    @Override
    protected void highlightFragmentImpl(Fragment fragment) {
        if (!this.myDrawNumber || fragment.getType() == null || TextDiffTypeEnum.NONE.equals((Object)fragment.getType())) {
            this.myAppender1.highlightText(fragment, null);
            this.myAppender2.highlightText(fragment, null);
            return;
        }
        int lineLeft = this.myAppender1.getDocument().getLineNumber(fragment.getRange(FragmentSide.SIDE1).getStartOffset());
        int lineRight = this.myAppender2.getDocument().getLineNumber(fragment.getRange(FragmentSide.SIDE2).getStartOffset());
        Pair<String, TextDiffTypeEnum> left = this.myLeftPrecalculated.get(lineLeft);
        if (this.myPreviousLineLeft == lineLeft || left == null) {
            this.myAppender1.highlightText(fragment, null);
        } else {
            this.myAppender1.highlightText(fragment, new FragmentNumberGutterIconRenderer((String)left.getFirst(), this.getColorAttributesKey((TextDiffTypeEnum)left.getSecond()), this.myAppender1.getEditor().getScrollPane(), this.myAppender1.getEditor()));
            this.myPreviousLineLeft = lineLeft;
        }
        Pair<String, TextDiffTypeEnum> right = this.myRightPrecalculated.get(lineRight);
        if (this.myPreviousLineRight == lineRight || right == null) {
            this.myAppender2.highlightText(fragment, null);
        } else {
            this.myAppender2.highlightText(fragment, new FragmentNumberGutterIconRenderer((String)right.getFirst(), this.getColorAttributesKey((TextDiffTypeEnum)right.getSecond()), this.myAppender1.getEditor().getScrollPane(), this.myAppender1.getEditor()));
            this.myPreviousLineRight = lineRight;
        }
    }

    public void addRangeHighlighter(boolean left, int start, int end, TextAttributes attributes) {
        if (left) {
            this.myAppender1.getEditor().getMarkupModel().addRangeHighlighter(start, end, 5997, attributes, HighlighterTargetArea.EXACT_RANGE);
        } else {
            this.myAppender2.getEditor().getMarkupModel().addRangeHighlighter(start, end, 5997, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    public void reset() {
        this.myLeftPrecalculated.clear();
        this.myRightPrecalculated.clear();
        this.myPreviousLineLeft = -1;
        this.myPreviousLineRight = -1;
    }

    public void precalculateNumbers(List<LineFragment> lines) {
        if (this.myPropertyChangeListener == null) {
            this.myPropertyChangeListener = new MyPropertyChangeListener();
            this.myAppender1.getEditor().addPropertyChangeListener(this.myPropertyChangeListener);
        }
        MultiMap leftMap = new MultiMap();
        MultiMap rightMap = new MultiMap();
        int cnt = 1;
        for (LineFragment line : lines) {
            if (line.getType() == null || TextDiffTypeEnum.NONE.equals((Object)line.getType())) continue;
            Iterator iterator = line.getChildrenIterator();
            if (iterator == null) {
                TextRange left = line.getRange(FragmentSide.SIDE1);
                TextRange right = line.getRange(FragmentSide.SIDE2);
                leftMap.putValue((Object)this.myAppender1.getDocument().getLineNumber(left.getStartOffset()), (Object)new Pair((Object)cnt, (Object)line.getType()));
                rightMap.putValue((Object)this.myAppender2.getDocument().getLineNumber(right.getStartOffset()), (Object)new Pair((Object)cnt, (Object)line.getType()));
                ++cnt;
                continue;
            }
            while (iterator.hasNext()) {
                Fragment next = (Fragment)iterator.next();
                if (next.getType() == null || TextDiffTypeEnum.NONE.equals((Object)next.getType())) continue;
                TextRange left = next.getRange(FragmentSide.SIDE1);
                TextRange right = next.getRange(FragmentSide.SIDE2);
                leftMap.putValue((Object)this.myAppender1.getDocument().getLineNumber(left.getStartOffset()), (Object)new Pair((Object)cnt, (Object)next.getType()));
                rightMap.putValue((Object)this.myAppender2.getDocument().getLineNumber(right.getStartOffset()), (Object)new Pair((Object)cnt, (Object)next.getType()));
                ++cnt;
            }
        }
        this.merge((MultiMap<Integer, Pair<Integer, TextDiffTypeEnum>>)leftMap, this.myLeftPrecalculated);
        this.merge((MultiMap<Integer, Pair<Integer, TextDiffTypeEnum>>)rightMap, this.myRightPrecalculated);
    }

    private void merge(MultiMap<Integer, Pair<Integer, TextDiffTypeEnum>> leftMap, Map<Integer, Pair<String, TextDiffTypeEnum>> whereTo) {
        for (Map.Entry entry : leftMap.entrySet()) {
            List value = (List)entry.getValue();
            if (value.size() > 1) {
                Pair pair1 = (Pair)value.iterator().next();
                Pair pair2 = (Pair)value.get(value.size() - 1);
                TextDiffTypeEnum type = this.mergeDiffType(value);
                whereTo.put((Integer)entry.getKey(), (Pair<String, TextDiffTypeEnum>)Pair.create((Object)(String.valueOf(pair1.getFirst()) + "-" + String.valueOf(pair2.getFirst())), (Object)type));
                continue;
            }
            Pair pair = (Pair)value.iterator().next();
            whereTo.put((Integer)entry.getKey(), (Pair<String, TextDiffTypeEnum>)Pair.create((Object)String.valueOf(pair.getFirst()), (Object)pair.getSecond()));
        }
    }

    private TextDiffTypeEnum mergeDiffType(List<Pair<Integer, TextDiffTypeEnum>> value) {
        TextDiffTypeEnum previous = null;
        for (Pair<Integer, TextDiffTypeEnum> pair : value) {
            if (previous == null) {
                previous = (TextDiffTypeEnum)pair.getSecond();
                continue;
            }
            if (previous.equals(pair.getSecond())) continue;
            return TextDiffTypeEnum.CHANGED;
        }
        return previous;
    }

    public List<Integer> getLeftLines() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.myLeftPrecalculated.keySet());
        Collections.sort(list);
        return list;
    }

    public List<Integer> getRightLines() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.myRightPrecalculated.keySet());
        Collections.sort(list);
        return list;
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            RangeHighlighter[] allHighlighters = NumberedFragmentHighlighter.this.myAppender1.getEditor().getMarkupModel().getAllHighlighters();
            this.resetFont(allHighlighters);
            RangeHighlighter[] allHighlighters2 = NumberedFragmentHighlighter.this.myAppender2.getEditor().getMarkupModel().getAllHighlighters();
            this.resetFont(allHighlighters2);
        }

        private void resetFont(RangeHighlighter[] allHighlighters) {
            for (RangeHighlighter highlighter : allHighlighters) {
                GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
                if (!(renderer instanceof FragmentNumberGutterIconRenderer)) continue;
                ((FragmentNumberGutterIconRenderer)renderer).resetFont(NumberedFragmentHighlighter.this.myAppender1.getEditor());
            }
        }
    }
}

