/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;

public class IncrementalFindAction
extends EditorAction {
    public IncrementalFindAction() {
        super((EditorActionHandler)new Handler(false));
    }

    public static class Handler
    extends EditorActionHandler {
        private final boolean myReplace;

        public Handler(boolean isReplace) {
            this.myReplace = isReplace;
        }

        public void execute(Editor editor, DataContext dataContext) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (!editor.isOneLineMode()) {
                EditorSearchSession search = EditorSearchSession.get(editor);
                if (search != null) {
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)search.getComponent(), true);
                    FindUtil.configureFindModel(this.myReplace, editor, search.getFindModel(), false);
                } else {
                    FindModel model;
                    FindManager findManager = FindManager.getInstance((Project)project);
                    if (this.myReplace) {
                        model = findManager.createReplaceInFileModel();
                    } else {
                        model = new FindModel();
                        model.copyFrom(findManager.getFindInFileModel());
                    }
                    FindUtil.configureFindModel(this.myReplace, editor, model, true);
                    EditorSearchSession.start(editor, model, project).getComponent().requestFocus();
                }
            }
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            if (this.myReplace && ConsoleViewUtil.isConsoleViewEditor(editor)) {
                return false;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            return project != null && !editor.isOneLineMode();
        }
    }
}

