/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableText;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.DocumentImpl");
    private final Ref<DocumentListener[]> myCachedDocumentListeners;
    private final List<DocumentListener> myDocumentListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private ReadonlyFragmentModificationHandler myReadonlyFragmentModificationHandler;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableText myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<EditReadOnlyListener> myReadOnlyListeners;
    private volatile boolean myMightContainTabs;
    private int myTabTrackingRequestors;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private boolean myUpdatingBulkModeStatus;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;

    public DocumentImpl(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(text, false);
    }

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this.myCachedDocumentListeners = Ref.create(null);
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myPersistentRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.myIsReadOnly = false;
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMightContainTabs = true;
        this.myTabTrackingRequestors = 0;
        this.myCheckGuardedBlocks = 0;
        this.myGuardsSuppressed = false;
        this.myEventsHandling = false;
        this.myDoingBulkUpdate = false;
        this.myAcceptSlashR = false;
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index) {
                return DocumentImpl.this.myText.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string = DocumentImpl.this.doGetText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
                }
                return string;
            }
        };
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = ImmutableText.valueOf((Object)chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    public boolean acceptsSlashR() {
        return this.myAcceptSlashR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet((CharSequence)this.myText);
                }
            }
        }
        return lineSet;
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.myText);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getChars"));
        }
        return cArray;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.isStripTrailingSpacesEnabled = isEnabled;
    }

    public boolean stripTrailingSpaces(Project project) {
        return this.stripTrailingSpaces(project, false);
    }

    public boolean stripTrailingSpaces(Project project, boolean inChangedLinesOnly) {
        return this.stripTrailingSpaces(project, inChangedLinesOnly, false, new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stripTrailingSpaces(@Nullable Project project, boolean inChangedLinesOnly, boolean virtualSpaceEnabled, @NotNull int[] caretOffsets) {
        if (caretOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsets", "com/intellij/openapi/editor/impl/DocumentImpl", "stripTrailingSpaces"));
        }
        if (!this.isStripTrailingSpacesEnabled) {
            return true;
        }
        boolean markAsNeedsStrippingLater = false;
        ImmutableText text = this.myText;
        TIntObjectHashMap caretMarkers = new TIntObjectHashMap(caretOffsets.length);
        try {
            if (!virtualSpaceEnabled) {
                for (int caretOffset : caretOffsets) {
                    if (caretOffset < 0 || caretOffset > this.getTextLength()) continue;
                    int line = this.getLineNumber(caretOffset);
                    ArrayList<RangeMarker> markers = (ArrayList<RangeMarker>)caretMarkers.get(line);
                    if (markers == null) {
                        markers = new ArrayList<RangeMarker>();
                        caretMarkers.put(line, markers);
                    }
                    RangeMarker marker = this.createRangeMarker(caretOffset, caretOffset);
                    markers.add(marker);
                }
            }
            block3: for (int line = 0; line < this.getLineCount(); ++line) {
                List markers;
                char c;
                LineSet lineSet = this.getLineSet();
                if (inChangedLinesOnly && !lineSet.isModified(line)) continue;
                int whiteSpaceStart = -1;
                final int lineEnd = lineSet.getLineEnd(line) - lineSet.getSeparatorLength(line);
                int lineStart = lineSet.getLineStart(line);
                int offset = lineEnd - 1;
                while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                    whiteSpaceStart = offset--;
                }
                if (whiteSpaceStart == -1) continue;
                if (!virtualSpaceEnabled && (markers = (List)caretMarkers.get(line)) != null) {
                    for (RangeMarker marker : markers) {
                        if (marker.getStartOffset() < 0 || whiteSpaceStart >= marker.getStartOffset()) continue;
                        markAsNeedsStrippingLater = true;
                        continue block3;
                    }
                }
                final int finalStart = whiteSpaceStart;
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new DocumentRunnable(this, project){

                    public void run() {
                        DocumentImpl.this.deleteString(finalStart, lineEnd);
                    }
                });
                text = this.myText;
            }
        }
        catch (Throwable throwable) {
            caretMarkers.forEachValue((TObjectProcedure)new TObjectProcedure<List<RangeMarker>>(){

                public boolean execute(List<RangeMarker> markerList) {
                    if (markerList != null) {
                        for (RangeMarker marker : markerList) {
                            try {
                                marker.dispose();
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                    return true;
                }
            });
            throw throwable;
        }
        caretMarkers.forEachValue((TObjectProcedure)new /* invalid duplicate definition of identical inner class */);
        return markAsNeedsStrippingLater;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentModificationHandler;
    }

    void setReadonlyFragmentModificationHandler(ReadonlyFragmentModificationHandler readonlyFragmentModificationHandler) {
        this.myReadonlyFragmentModificationHandler = readonlyFragmentModificationHandler;
    }

    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "treeFor"));
        }
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "removeRangeMarker"));
        }
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "registerRangeMarker"));
        }
        this.treeFor(rangeMarker).addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
    }

    int getRangeMarkersSize() {
        return this.myRangeMarkers.size() + this.myPersistentRangeMarkers.size();
    }

    int getRangeMarkersNodeSize() {
        return this.myRangeMarkers.nodeSize() + this.myPersistentRangeMarkers.nodeSize();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, (Object)"Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createGuardedBlock"));
        }
        return rangeMarker;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/openapi/editor/impl/DocumentImpl", "removeGuardedBlock"));
        }
        this.myGuardedBlocks.remove(block);
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = this.myGuardedBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getGuardedBlocks"));
        }
        return list;
    }

    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, true, block.getStartOffset(), block.isGreedyToLeft(), end, true, block.getEndOffset(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, (Object)"Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangesIntersect(int start0, boolean leftInclusive0, int start1, boolean leftInclusive1, int end0, boolean rightInclusive0, int end1, boolean rightInclusive1) {
        if (start0 > start1 || start0 == start1 && !leftInclusive0) {
            return DocumentImpl.rangesIntersect(start1, leftInclusive1, start0, leftInclusive0, end1, rightInclusive1, end0, rightInclusive0);
        }
        if (end0 == start1) {
            return leftInclusive1 && rightInclusive0;
        }
        return end0 > start1;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset, false);
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        RangeMarkerImpl rangeMarkerImpl = surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset, true) : new RangeMarkerImpl(this, startOffset, endOffset, true);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarkerImpl;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceText"));
        }
        this.replaceString(0, this.getTextLength(), chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    @Override
    public int getListenersCount() {
        return this.myDocumentListeners.size();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "insertString"));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, s.length() - 20), s.length()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, null, s.toString());
        }
        this.myText = this.myText.ensureChunked();
        ImmutableText newText = this.myText.insert(offset, ImmutableText.valueOf((Object)s));
        this.updateText(newText, offset, null, (CharSequence)newText.subtext(offset, offset + s.length()), false, LocalTimeCounter.currentTime(), offset, 0);
        this.trimToSize();
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset).toString(), null);
        }
        this.myText = this.myText.ensureChunked();
        this.updateText(this.myText.delete(startOffset, endOffset), startOffset, (CharSequence)this.myText.subtext(startOffset, endOffset), null, false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset);
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        this.assertBounds(srcStart, srcEnd);
        if (dstOffset == srcEnd) {
            return;
        }
        ProperTextRange srcRange = new ProperTextRange(srcStart, srcEnd);
        assert (!srcRange.containsOffset(dstOffset)) : "Can't perform text move from range [" + srcStart + "; " + srcEnd + ") to offset " + dstOffset;
        String replacement = this.getCharsSequence().subSequence(srcStart, srcEnd).toString();
        this.insertString(dstOffset, replacement);
        int shift = 0;
        if (dstOffset < srcStart) {
            shift = srcEnd - srcStart;
        }
        this.fireMoveText(srcStart + shift, srcEnd + shift, dstOffset);
        this.deleteString(srcStart + shift, srcEnd + shift);
    }

    private void fireMoveText(int start, int end, int newBase) {
        for (DocumentListener listener : this.getCachedListeners()) {
            if (!(listener instanceof PrioritizedInternalDocumentListener)) continue;
            ((PrioritizedInternalDocumentListener)listener).moveTextHappened(start, end, newBase);
        }
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), false);
    }

    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean bl) {
        ImmutableText newText;
        boolean wholeTextReplaced;
        int newStartInString;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableText chars = this.myText;
        int newEndInString = newStringLength;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        while (endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1)) {
            --newEndInString;
            --endOffset;
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableText sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, sToDelete.toString(), changedPart.toString());
        }
        if (wholeTextReplaced && s instanceof ImmutableText) {
            newText = (ImmutableText)s;
        } else {
            this.myText = this.myText.ensureChunked();
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        this.updateText(newText, startOffset, (CharSequence)sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "assertValidSeparators"));
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators((CharSequence)s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset, String oldString, String newString) {
        if (guard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guard", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException((DocumentEvent)event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    @Override
    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    public void clearLineModificationFlags(int startLine, int endLine) {
        this.myLineSet = this.getLineSet().clearModificationFlags(startLine, endLine);
        this.myFrozen = null;
    }

    void clearLineModificationFlagsExcept(@NotNull int[] caretLines) {
        if (caretLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretLines", "com/intellij/openapi/editor/impl/DocumentImpl", "clearLineModificationFlagsExcept"));
        }
        IntArrayList modifiedLines = new IntArrayList(caretLines.length);
        LineSet lineSet = this.getLineSet();
        for (int line : caretLines) {
            if (line < 0 || line >= lineSet.getLineCount() || !lineSet.isModified(line)) continue;
            modifiedLines.add(line);
        }
        lineSet = lineSet.clearModificationFlags();
        for (int i = 0; i < modifiedLines.size(); ++i) {
            lineSet = lineSet.setModified(modifiedLines.get(i));
        }
        this.myLineSet = lineSet;
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateText(@NotNull ImmutableText newText, int offset, @Nullable CharSequence oldString, @Nullable CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int n) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        this.assertNotNestedModification();
        boolean enableRecursiveModifications = Registry.is((String)"enable.recursive.document.changes");
        this.myChangeInProgress = true;
        try {
            void initialOldLength;
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, (int)initialOldLength);
            try {
                this.doBeforeChangedUpdate(event);
            }
            finally {
                if (enableRecursiveModifications) {
                    this.myChangeInProgress = false;
                }
            }
            this.myTextString = null;
            ImmutableText prevText = this.myText;
            this.myText = newText;
            this.changedUpdate(event, newModificationStamp, prevText);
        }
        finally {
            if (!enableRecursiveModifications) {
                this.myChangeInProgress = false;
            }
        }
    }

    private void doBeforeChangedUpdate(DocumentEvent event) {
        FileDocumentManager manager;
        VirtualFile file2;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file2 = (manager = FileDocumentManager.getInstance()).getFile((Document)this)) != null && !file2.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getCachedListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, ImmutableText immutableText) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        try {
            void prevText;
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            this.myLineSet = this.getLineSet().update((CharSequence)prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            this.myFrozen = null;
            if (this.myTabTrackingRequestors > 0) {
                this.updateMightContainTabs(event.getNewFragment());
            }
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getCachedListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @NotNull
    public String getText() {
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return DocumentImpl.this.doGetText();
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    @NotNull
    private String doGetText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doGetText"));
        }
        return string;
    }

    @NotNull
    public String getText(final @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return DocumentImpl.this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myMutableCharSequence;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCharsSequence"));
        }
        return charSequence;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableText immutableText = this.myText;
        if (immutableText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getImmutableCharSequence"));
        }
        return immutableText;
    }

    @NotNull
    public ImmutableText getImmutableText() {
        ImmutableText immutableText = this.myText;
        if (immutableText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getImmutableText"));
        }
        return immutableText;
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        this.myCachedDocumentListeners.set(null);
        if (this.myDocumentListeners.contains(listener)) {
            LOG.error("Already registered: " + listener);
        }
        boolean added = this.myDocumentListeners.add(listener);
        LOG.assertTrue(added, (Object)listener);
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        this.addDocumentListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new DocumentListenerDisposable(listener, this.myCachedDocumentListeners, this.myDocumentListeners));
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeDocumentListener"));
        }
        DocumentImpl.doRemoveDocumentListener(listener, this.myCachedDocumentListeners, this.myDocumentListeners);
    }

    private static void doRemoveDocumentListener(@NotNull DocumentListener listener, @NotNull Ref<DocumentListener[]> cachedDocumentListenersRef, @NotNull List<DocumentListener> documentListeners) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        if (cachedDocumentListenersRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedDocumentListenersRef", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        if (documentListeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentListeners", "com/intellij/openapi/editor/impl/DocumentImpl", "doRemoveDocumentListener"));
        }
        cachedDocumentListenersRef.set(null);
        boolean success = documentListeners.remove(listener);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener + "). Registered listeners: " + documentListeners);
        }
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.getLineSet().createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createLineIterator"));
        }
        return lineIterator;
    }

    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getCachedListeners() {
        DocumentListener[] cachedListeners = (DocumentListener[])this.myCachedDocumentListeners.get();
        if (cachedListeners == null) {
            DocumentListener[] listeners = (DocumentListener[])ArrayUtil.stripTrailingNulls((Object[])this.myDocumentListeners.toArray(new DocumentListener[this.myDocumentListeners.size()]));
            Arrays.sort(listeners, PrioritizedDocumentListener.COMPARATOR);
            cachedListeners = listeners;
            this.myCachedDocumentListeners.set((Object)cachedListeners);
        }
        if (cachedListeners == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCachedListeners"));
        }
        return cachedListeners;
    }

    public void fireReadOnlyModificationAttempt() {
        for (EditReadOnlyListener listener : this.myReadOnlyListeners) {
            listener.readOnlyModificationAttempt(this);
        }
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addEditReadOnlyListener"));
        }
        this.myReadOnlyListeners.add(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeEditReadOnlyListener"));
        }
        this.myReadOnlyListeners.remove(listener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    public void setText(final @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "setText"));
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.replaceString(0, DocumentImpl.this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
            }
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable2.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)this));
        }
        this.clearLineModificationFlags();
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    @Override
    public final void setInBulkUpdate(boolean value) {
        if (this.myAssertThreading) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        if (this.myUpdatingBulkModeStatus) {
            throw new IllegalStateException("Detected bulk mode status update from DocumentBulkUpdateListener");
        }
        if (this.myDoingBulkUpdate == value) {
            return;
        }
        this.myUpdatingBulkModeStatus = true;
        try {
            if (value) {
                DocumentImpl.getPublisher().updateStarted(this);
                this.myDoingBulkUpdate = true;
            } else {
                this.myDoingBulkUpdate = false;
                DocumentImpl.getPublisher().updateFinished(this);
            }
        }
        finally {
            this.myUpdatingBulkModeStatus = false;
        }
    }

    @NotNull
    private static DocumentBulkUpdateListener getPublisher() {
        DocumentBulkUpdateListener documentBulkUpdateListener = DocumentBulkUpdateListenerHolder.ourBulkChangePublisher;
        if (documentBulkUpdateListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getPublisher"));
        }
        return documentBulkUpdateListener;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/DocumentImpl", "processRangeMarkers"));
        }
        return this.processRangeMarkersOverlappingWith(0, this.getTextLength(), processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/DocumentImpl", "processRangeMarkersOverlappingWith"));
        }
        TextRangeInterval interval = new TextRangeInterval(start, end);
        IntervalTreeImpl.PeekableIterator<RangeMarkerEx> iterator = IntervalTreeImpl.mergingOverlappingIterator(this.myRangeMarkers, interval, this.myPersistentRangeMarkers, interval, RangeMarker.BY_START_OFFSET);
        try {
            boolean bl = ContainerUtil.process(iterator, processor2);
            return bl;
        }
        finally {
            iterator.dispose();
        }
    }

    @NotNull
    public String dumpState() {
        StringBuilder result2 = new StringBuilder();
        result2.append(", intervals:\n");
        for (int line = 0; line < this.getLineCount(); ++line) {
            result2.append(line).append(": ").append(this.getLineStartOffset(line)).append("-").append(this.getLineEndOffset(line)).append(", ");
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - 1);
        }
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile((Document)this) + "]";
    }

    void requestTabTracking() {
        if (this.myAssertThreading) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        if (this.myTabTrackingRequestors++ == 0) {
            this.myMightContainTabs = false;
            this.updateMightContainTabs((CharSequence)this.myText);
        }
    }

    void giveUpTabTracking() {
        if (this.myAssertThreading) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        if (--this.myTabTrackingRequestors == 0) {
            this.myMightContainTabs = true;
        }
    }

    boolean mightContainTabs() {
        return this.myMightContainTabs;
    }

    private void updateMightContainTabs(CharSequence text) {
        if (!this.myMightContainTabs) {
            this.myMightContainTabs = StringUtil.contains((CharSequence)text, (int)0, (int)text.length(), (char)'\t');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    frozen = new FrozenDocument(this.myText, this.getLineSet(), this.myModificationStamp, (String)SoftReference.dereference(this.myTextString));
                }
            }
        }
        FrozenDocument frozenDocument = frozen;
        if (frozenDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "freeze"));
        }
        return frozenDocument;
    }

    private static class DocumentBulkUpdateListenerHolder {
        private static final DocumentBulkUpdateListener ourBulkChangePublisher = (DocumentBulkUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DocumentBulkUpdateListener.TOPIC);

        private DocumentBulkUpdateListenerHolder() {
        }
    }

    private static class DocumentListenerDisposable
    implements Disposable {
        private final DocumentListener myListener;
        private final Ref<DocumentListener[]> myCachedDocumentListenersRef;
        private final List<DocumentListener> myDocumentListeners;

        private DocumentListenerDisposable(@NotNull DocumentListener listener, @NotNull Ref<DocumentListener[]> cachedDocumentListenersRef, @NotNull List<DocumentListener> documentListeners) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            if (cachedDocumentListenersRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedDocumentListenersRef", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            if (documentListeners == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentListeners", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            this.myListener = listener;
            this.myCachedDocumentListenersRef = cachedDocumentListenersRef;
            this.myDocumentListeners = documentListeners;
        }

        public void dispose() {
            DocumentImpl.doRemoveDocumentListener(this.myListener, (Ref<DocumentListener[]>)this.myCachedDocumentListenersRef, this.myDocumentListeners);
        }
    }
}

