/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingUtil {
    static Magic8 isSafeToReloadIn(@NotNull VirtualFile virtualFile, @NotNull String text, @NotNull byte[] bytes, @NotNull Charset charset) {
        byte[] bytesToSave;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)charset, (byte[])bom)) {
            return Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)charset);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return Magic8.NO_WAY;
        }
        String loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, charset).toString();
        String separator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        String toSave = StringUtil.convertLineSeparators((String)loaded, (String)separator);
        String failReason = LoadTextUtil.wasCharsetDetectedFromBytes(virtualFile);
        if (failReason != null && CharsetToolkit.UTF8_CHARSET.equals(virtualFile.getCharset()) && !CharsetToolkit.UTF8_CHARSET.equals(charset)) {
            return Magic8.NO_WAY;
        }
        try {
            bytesToSave = toSave.getBytes(charset);
        }
        catch (UnsupportedOperationException e) {
            return Magic8.NO_WAY;
        }
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        return !Arrays.equals(bytesToSave, bytes) ? Magic8.NO_WAY : (loaded.equals(text) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
    }

    static Magic8 isSafeToConvertTo(@NotNull VirtualFile virtualFile, @NotNull String text, @NotNull byte[] bytesOnDisk, @NotNull Charset charset) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        if (bytesOnDisk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytesOnDisk", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        try {
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
            String textToSave = lineSeparator.equals("\n") ? text : StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
            Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(virtualFile.getCharset(), charset, textToSave);
            byte[] saved = (byte[])chosen.second;
            CharSequence textLoadedBack = LoadTextUtil.getTextByBinaryPresentation(saved, charset);
            return !text.equals(textLoadedBack.toString()) ? Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            return Magic8.NO_WAY;
        }
    }

    public static void saveIn(final @NotNull Document document, Editor editor, final @NotNull VirtualFile virtualFile, final @NotNull Charset charset) {
        boolean writable;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vfs/encoding/EncodingUtil", "saveIn"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "saveIn"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "saveIn"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        documentManager.saveDocument(document);
        final Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        boolean bl = writable = project == null ? virtualFile.isWritable() : ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        if (!writable) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot save the file " + virtualFile.getPresentableUrl()), (String)"Unable to Save", null);
            return;
        }
        try {
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Object, IOException>(){

                public Object compute() throws IOException {
                    virtualFile.setCharset(charset);
                    LoadTextUtil.write(project, virtualFile, virtualFile, document.getText(), document.getModificationStamp());
                    return null;
                }
            });
        }
        catch (IOException io) {
            Messages.showErrorDialog((Project)project, (String)io.getMessage(), (String)"Error Writing File");
        }
        EncodingProjectManagerImpl.suppressReloadDuring(new Runnable(){

            @Override
            public void run() {
                EncodingManager.getInstance().setEncoding(virtualFile, charset);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadIn(final @NotNull VirtualFile virtualFile, final @NotNull Charset charset) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "reloadIn"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "reloadIn"));
        }
        final FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.getCachedDocument(virtualFile) == null) {
            EncodingManager.getInstance().setEncoding(virtualFile, charset);
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void beforeFileContentReload(VirtualFile file2, @NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vfs/encoding/EncodingUtil$3", "beforeFileContentReload"));
                }
                if (!file2.equals(virtualFile)) {
                    return;
                }
                Disposer.dispose((Disposable)disposable);
                EncodingManager.getInstance().setEncoding(file2, charset);
                LoadTextUtil.setCharsetWasDetectedFromBytes(file2, null);
            }
        });
        try {
            EncodingProjectManagerImpl.suppressReloadDuring(new Runnable(){

                @Override
                public void run() {
                    ((VirtualFileListener)documentManager).contentsChanged(new VirtualFileEvent(null, virtualFile, virtualFile.getName(), virtualFile.getParent()));
                }
            });
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    @NotNull
    static Pair<Charset, String> checkHardcodedCharsetFileType(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType.isBinary()) {
            Pair pair = Pair.create(null, (Object)"binary file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == FileTypes.PLAIN_TEXT) {
            Pair pair = Pair.create(null, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == StdFileTypes.GUI_DESIGNER_FORM) {
            Pair pair = Pair.create((Object)CharsetToolkit.UTF8_CHARSET, (Object)"IDEA GUI Designer form");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == StdFileTypes.IDEA_MODULE) {
            Pair pair = Pair.create((Object)CharsetToolkit.UTF8_CHARSET, (Object)"IDEA module file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == StdFileTypes.IDEA_PROJECT) {
            Pair pair = Pair.create((Object)CharsetToolkit.UTF8_CHARSET, (Object)"IDEA project file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == StdFileTypes.IDEA_WORKSPACE) {
            Pair pair = Pair.create((Object)CharsetToolkit.UTF8_CHARSET, (Object)"IDEA workspace file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == StdFileTypes.PROPERTIES) {
            Pair pair = Pair.create((Object)virtualFile.getCharset(), (Object)".properties file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        if (fileType == StdFileTypes.XML || fileType == StdFileTypes.JSPX) {
            Pair pair = Pair.create((Object)virtualFile.getCharset(), (Object)"XML file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
            }
            return pair;
        }
        Pair pair = Pair.create(null, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
        }
        return pair;
    }

    @NotNull
    public static Pair<Charset, String> checkCanReload(@NotNull VirtualFile virtualFile) {
        Charset charsetFromContent;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
        }
        if (virtualFile.isDirectory()) {
            Pair pair = Pair.create(null, (Object)"file is a directory");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
            }
            return pair;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            Pair pair = Pair.create(null, (Object)"binary file");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
            }
            return pair;
        }
        Charset existing = charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        String failReason = LoadTextUtil.wasCharsetDetectedFromBytes(virtualFile);
        if (failReason != null) {
            existing = virtualFile.getCharset();
        } else if (charsetFromContent != null) {
            failReason = "hard coded in text";
        } else {
            Pair<Charset, String> fileTypeCheck = EncodingUtil.checkHardcodedCharsetFileType(virtualFile);
            if (fileTypeCheck.second != null) {
                failReason = (String)fileTypeCheck.second;
                existing = (Charset)fileTypeCheck.first;
            }
        }
        if (failReason != null) {
            Pair pair = Pair.create((Object)existing, (Object)failReason);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)virtualFile.getCharset(), null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
        }
        return pair;
    }

    @Nullable(value="null means enabled, notnull means disabled and contains error message")
    public static String checkCanConvert(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanConvert"));
        }
        if (virtualFile.isDirectory()) {
            return "file is a directory";
        }
        String failReason = null;
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        if (charsetFromContent != null) {
            failReason = "Encoding is hard-coded in the text";
        } else {
            Pair<Charset, String> check = EncodingUtil.checkHardcodedCharsetFileType(virtualFile);
            if (check.second != null) {
                failReason = (String)check.second;
            }
        }
        if (failReason != null) {
            return failReason;
        }
        return null;
    }

    @Nullable
    public static Pair<Charset, String> checkSomeActionEnabled(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkSomeActionEnabled"));
        }
        String saveError = EncodingUtil.checkCanConvert(selectedFile);
        if (saveError == null) {
            return null;
        }
        Pair<Charset, String> reloadError = EncodingUtil.checkCanReload(selectedFile);
        if (reloadError.second == null) {
            return null;
        }
        return Pair.create((Object)reloadError.first, (Object)saveError);
    }

    static enum Magic8 {
        ABSOLUTELY,
        WELL_IF_YOU_INSIST,
        NO_WAY;

    }
}

