/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.PsiElementRenameHandler;

public class RenameFileAction
extends AnAction
implements DumbAware {
    public static final String RENAME_FILE = "Rename File...";

    public void actionPerformed(AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file2 != null);
        VirtualFile virtualFile = file2.getVirtualFile();
        assert (virtualFile != null);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        PsiElementRenameHandler.invoke((PsiElement)file2, project, (PsiElement)file2, null);
    }

    public void update(AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Presentation presentation = e.getPresentation();
        String place = e.getPlace();
        boolean enabled = file2 != null && (file2 instanceof PsiClassOwner || "EditorTabPopup".equals(place)) && place != "EditorPopup" && e.getData(CommonDataKeys.PROJECT) != null;
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
        if (enabled) {
            presentation.setText(RENAME_FILE);
            presentation.setDescription("Rename selected file");
        }
    }
}

