/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;

class FindInFilesOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final MyFileProcessor myFileProcessor;
    private THashSet<PsiFile> filesToScan;
    private THashSet<PsiFile> filesToScan2;
    private final boolean myFindMatchingFiles;
    private final Project myProject;

    FindInFilesOptimizingSearchHelper(CompileContext context, boolean findMatchingFiles, Project project) {
        super(context);
        this.myFindMatchingFiles = findMatchingFiles;
        this.myProject = project;
        if (this.myFindMatchingFiles && this.filesToScan == null) {
            this.filesToScan = new THashSet();
            this.filesToScan2 = new THashSet();
        }
        this.myFileProcessor = new MyFileProcessor();
    }

    @Override
    public boolean doOptimizing() {
        return this.myFindMatchingFiles;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.filesToScan != null) {
            this.filesToScan.clear();
            this.filesToScan2.clear();
        }
    }

    @Override
    protected void doAddSearchWordInCode(String refname) {
        MatchOptions options = this.context.getOptions();
        CacheManager.SERVICE.getInstance(this.myProject).processFilesWithWord(this.myFileProcessor, refname, (short)1, (GlobalSearchScope)options.getScope(), options.isCaseSensitiveMatch());
    }

    @Override
    protected void doAddSearchWordInText(String refname) {
        MatchOptions options = this.context.getOptions();
        CacheManager.SERVICE.getInstance(this.myProject).processFilesWithWord(this.myFileProcessor, refname, (short)16, (GlobalSearchScope)options.getScope(), options.isCaseSensitiveMatch());
    }

    @Override
    protected void doAddSearchWordInComments(String refname) {
        MatchOptions options = this.context.getOptions();
        CacheManager.SERVICE.getInstance(this.myProject).processFilesWithWord(this.myFileProcessor, refname, (short)2, (GlobalSearchScope)options.getScope(), options.isCaseSensitiveMatch());
    }

    @Override
    protected void doAddSearchWordInLiterals(String refname) {
        MatchOptions options = this.context.getOptions();
        CacheManager.SERVICE.getInstance(this.myProject).processFilesWithWord(this.myFileProcessor, refname, (short)4, (GlobalSearchScope)options.getScope(), options.isCaseSensitiveMatch());
    }

    @Override
    public void endTransaction() {
        super.endTransaction();
        THashSet<PsiFile> map = this.filesToScan;
        if (map.size() > 0) {
            map.clear();
        }
        this.filesToScan = this.filesToScan2;
        this.filesToScan2 = map;
    }

    @Override
    public Set<PsiFile> getFilesSetToScan() {
        return this.filesToScan;
    }

    private class MyFileProcessor
    implements Processor<PsiFile> {
        private MyFileProcessor() {
        }

        public boolean process(PsiFile file2) {
            if (FindInFilesOptimizingSearchHelper.this.scanRequest == 0 || FindInFilesOptimizingSearchHelper.this.filesToScan.contains((Object)file2)) {
                FindInFilesOptimizingSearchHelper.this.filesToScan2.add((Object)file2);
            }
            return true;
        }
    }
}

