/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.export.HTMLExporter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HTMLExportUtil {
    public static void writeFile(final String folder, final @NonNls String fileName, CharSequence buf, final Project project) {
        try {
            HTMLExporter.writeFileImpl(folder, fileName, buf);
        }
        catch (IOException e) {
            Runnable showError = new Runnable(){

                @Override
                public void run() {
                    String fullPath = folder + File.separator + fileName;
                    Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.export.error.writing.to", (Object[])new Object[]{fullPath}), (String)InspectionsBundle.message((String)"inspection.export.results.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().invokeLater(showError, ModalityState.NON_MODAL);
            throw new ProcessCanceledException();
        }
    }

    public static void runExport(final Project project, @NotNull ThrowableRunnable<IOException> runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/codeInspection/export/HTMLExportUtil", "runExport"));
        }
        try {
            runnable2.run();
        }
        catch (IOException e) {
            Runnable showError = new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.export.error.writing.to", (Object[])new Object[]{"export file"}), (String)InspectionsBundle.message((String)"inspection.export.results.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().invokeLater(showError, ModalityState.NON_MODAL);
            throw new ProcessCanceledException();
        }
    }
}

