/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultStorageAnnotation;
import com.intellij.configurationStore.ProjectStateStorageManager;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.ConstantsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0012\u0018\u0000 *2\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eH\u0014JH\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u00132\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0014J\b\u0010\u0017\u001a\u00020\u0005H\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J9\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\"\u001a\u00020#H\u0014\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Lcom/intellij/configurationStore/ProjectStoreImpl;", "Lcom/intellij/configurationStore/ProjectStoreBase;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;Lcom/intellij/openapi/components/PathMacroManager;)V", "storageManager", "Lcom/intellij/configurationStore/ProjectStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ProjectStateStorageManager;", "beforeSave", "", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSave", "", "", "saveSessions", "prevErrors", "getPathMacroManagerForDefaults", "getProjectName", "", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Lcom/intellij/openapi/components/State;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "selectDefaultStorages", "storages", "([Lcom/intellij/openapi/components/Storage;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "setPath", "filePath", "Companion", "configuration-store-impl"})
class ProjectStoreImpl
extends ProjectStoreBase {
    @NotNull
    private final ProjectStateStorageManager storageManager;
    private final PathMacroManager pathMacroManager;
    private static final DefaultStorageAnnotation DEFAULT_STORAGE_ANNOTATION;
    public static final Companion Companion;

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    public ProjectStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setPath(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.setPath(filePath, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getProjectName() {
        int i;
        int endIndex$iv;
        if (Intrinsics.areEqual((Object)this.getScheme(), (Object)StorageScheme.DIRECTORY_BASED)) {
            String baseDir = this.getProjectBasePath();
            File nameFile = new File(new File(this.getProjectBasePath(), ".idea"), ".name");
            if (nameFile.exists()) {
                try {
                    BufferedReader it$iv;
                    void $receiver$iv$iv;
                    Closeable $receiver$iv;
                    File file2 = nameFile;
                    $receiver$iv = new FileInputStream((File)((Object)$receiver$iv));
                    Object $i$f$inputStream = null;
                    boolean bl = true;
                    Object var7_12 = null;
                    if (var7_12 != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
                    }
                    if (bl & true) {
                        $i$f$inputStream = Charsets.UTF_8;
                    }
                    $receiver$iv = new InputStreamReader((InputStream)$receiver$iv, (Charset)$i$f$inputStream);
                    $i$f$inputStream = $receiver$iv;
                    int $i$f$reader = 0;
                    boolean bl2 = true;
                    Object var8_17 = null;
                    if (var8_17 != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
                    }
                    if (bl2 & true) {
                        $i$f$reader = ConstantsKt.DEFAULT_BUFFER_SIZE;
                    }
                    $i$f$inputStream = $i$f$inputStream instanceof BufferedReader ? (BufferedReader)$i$f$inputStream : new BufferedReader((Reader)$i$f$inputStream, $i$f$reader);
                    boolean closed$iv$iv = false;
                    try {
                        String string;
                        Object v0;
                        String $receiver$iv2;
                        block25: {
                            Sequence it;
                            it$iv = (BufferedReader)$receiver$iv$iv;
                            Sequence sequence = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            Iterator iterator = $receiver$iv2.iterator();
                            while (iterator.hasNext()) {
                                void $receiver$iv3;
                                Object element$iv = iterator.next();
                                String it2 = (String)element$iv;
                                CharSequence charSequence = it2;
                                if (!(!($receiver$iv3.length() == 0))) continue;
                                v0 = element$iv;
                                break block25;
                            }
                            v0 = null;
                        }
                        String string2 = v0;
                        if (string2 != null) {
                            $receiver$iv2 = string2;
                            String string3 = $receiver$iv2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        } else {
                            string = null;
                        }
                        it$iv = string;
                    }
                    catch (Exception e$iv$iv) {
                        closed$iv$iv = true;
                        try {
                            $receiver$iv$iv.close();
                        }
                        catch (Exception closeException$iv$iv) {
                            // empty catch block
                        }
                        throw (Throwable)e$iv$iv;
                    }
                    finally {
                        if (!closed$iv$iv) {
                            $receiver$iv$iv.close();
                        }
                    }
                    String name = (String)((Object)it$iv);
                    if (name != null) {
                        return name;
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return StringsKt.replace$default((String)PathUtilRt.getFileName((String)baseDir), (String)":", (String)"", (boolean)false, (int)4, null);
        }
        String temp = PathUtilRt.getFileName((String)this.getProjectFilePath());
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(temp);
        if (fileType instanceof ProjectFileType) {
            void startIndex$iv2;
            void $receiver$iv;
            String ignored = temp;
            boolean $receiver$iv4 = false;
            int $receiver$iv$iv = temp.length() - ((ProjectFileType)fileType).getDefaultExtension().length() - 1;
            void v4 = $receiver$iv;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)v4).substring((int)startIndex$iv2, endIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            temp = string;
        }
        if ((i = StringsKt.lastIndexOf$default((CharSequence)temp, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null)) >= 0) {
            void endIndex$iv2;
            void startIndex$iv;
            void $receiver$iv;
            String startIndex$iv2 = temp;
            endIndex$iv = i + 1;
            int $i$f$substring = temp.length() - i + 1;
            void v6 = $receiver$iv;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)v6).substring((int)startIndex$iv, (int)endIndex$iv2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            temp = string;
        }
        String string = temp;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"temp");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected List<Throwable> doSave(@NotNull List<? extends StateStorage.SaveSession> saveSessions, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> prevErrors) {
        ReadonlyStatusHandler.OperationStatus status;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(saveSessions, (String)"saveSessions");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List<Throwable> errors = prevErrors;
        this.beforeSave(readonlyFiles);
        super.doSave(saveSessions, readonlyFiles, errors);
        ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, (Project)this.getProject());
        if (readonlyFiles.isEmpty()) {
            for (int i = 0; i < notifications.length; ++i) {
                ProjectManagerImpl.UnableToSaveProjectNotification notification = notifications[i];
                notification.expire();
            }
            return errors;
        }
        Object[] notification = (Object[])notifications;
        if (!(((void)$receiver$iv).length == 0)) {
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        AccessToken token = ReadAction.start();
        try {
            VirtualFile[] virtualFileArray = ProjectStoreImpl.Companion.getFilesList(readonlyFiles);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)operationStatus, (String)"ReadonlyStatusHandler.ge\u2026FilesList(readonlyFiles))");
            status = operationStatus;
        }
        finally {
            token.finish();
        }
        if (status.hasReadonlyFiles()) {
            Project project = this.getProject();
            VirtualFile[] virtualFileArray = status.getReadonlyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"status.readonlyFiles");
            ProjectStoreImpl.Companion.dropUnableToSaveProjectNotification(project, virtualFileArray);
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        ArrayList oldList = new ArrayList(readonlyFiles);
        readonlyFiles.clear();
        for (Pair entry : oldList) {
            StateStorage.SaveSession saveSession = (StateStorage.SaveSession)entry.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)saveSession, (String)"entry.first");
            errors = ComponentStoreImplKt.executeSave(saveSession, readonlyFiles, errors);
        }
        if (errors != null) {
            CompoundRuntimeException.throwIfNotEmpty(errors);
        }
        if (!readonlyFiles.isEmpty()) {
            ProjectStoreImpl.Companion.dropUnableToSaveProjectNotification(this.getProject(), ProjectStoreImpl.Companion.getFilesList(readonlyFiles));
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        return errors;
    }

    protected void beforeSave(@NotNull List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected <T> Storage[] getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        void size$iv;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Storage[] result2 = super.getStorageSpecs(component, stateSpec, operation);
        for (int i = 0; i < result2.length; ++i) {
            Storage storage2 = result2[i];
            if (!Intrinsics.areEqual((Object)storage2.file(), (Object)"$PROJECT_FILE$")) continue;
            return result2;
        }
        int storage2 = ((Object[])result2).length + 1;
        Storage[] result$iv = new Storage[size$iv];
        boolean bl = false;
        void var8_10 = size$iv - true;
        if (bl <= var8_10) {
            void i$iv;
            do {
                void it;
                Storage storage3;
                void var9_11 = ++i$iv;
                void var13_13 = i$iv;
                Storage[] storageArray = result$iv;
                storageArray[var13_13] = storage3 = it == ((Object[])result2).length ? (Storage)ProjectStoreImpl.Companion.getDEFAULT_STORAGE_ANNOTATION() : result2[it];
            } while (i$iv != var8_10);
        }
        return (Storage[])((Object[])result$iv);
    }

    @Override
    @NotNull
    protected Storage[] selectDefaultStorages(@NotNull Storage[] storages, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)storages, (String)"storages");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        return ProjectStoreImplKt.selectDefaultStorages(storages, operation, this.getScheme());
    }

    public ProjectStoreImpl(@NotNull ProjectImpl project, @NotNull PathMacroManager pathMacroManager) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        super(project);
        this.pathMacroManager = pathMacroManager;
        boolean value$iv = !project.isDefault();
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.pathMacroManager.createTrackingSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)trackingPathMacroSubstitutor, (String)"pathMacroManager.createTrackingSubstitutor()");
        this.storageManager = new ProjectStateStorageManager(trackingPathMacroSubstitutor, project);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_STORAGE_ANNOTATION = new DefaultStorageAnnotation();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ5\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\r0\r0\f2\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/ProjectStoreImpl$Companion;", "", "()V", "DEFAULT_STORAGE_ANNOTATION", "Lcom/intellij/configurationStore/DefaultStorageAnnotation;", "getDEFAULT_STORAGE_ANNOTATION", "()Lcom/intellij/configurationStore/DefaultStorageAnnotation;", "dropUnableToSaveProjectNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "readOnlyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFilesList", "kotlin.jvm.PlatformType", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "(Ljava/util/List;)[Lcom/intellij/openapi/vfs/VirtualFile;", "configuration-store-impl"})
    public static final class Companion {
        private final DefaultStorageAnnotation getDEFAULT_STORAGE_ANNOTATION() {
            return DEFAULT_STORAGE_ANNOTATION;
        }

        /*
         * WARNING - void declaration
         */
        private final void dropUnableToSaveProjectNotification(Project project, VirtualFile[] readOnlyFiles) {
            void $receiver$iv;
            ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, project);
            Object[] objectArray = (Object[])notifications;
            if (((void)$receiver$iv).length == 0) {
                Notifications.Bus.notify((Notification)new ProjectManagerImpl.UnableToSaveProjectNotification(project, readOnlyFiles), (Project)project);
            } else {
                notifications[0].myFiles = readOnlyFiles;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final VirtualFile[] getFilesList(List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
            int size$iv = readonlyFiles.size();
            VirtualFile[] result$iv = new VirtualFile[size$iv];
            int n = 0;
            int n2 = size$iv - 1;
            if (n <= n2) {
                void i$iv;
                do {
                    void it;
                    VirtualFile virtualFile;
                    void var6_6 = ++i$iv;
                    void var10_8 = i$iv;
                    VirtualFile[] virtualFileArray = result$iv;
                    virtualFileArray[var10_8] = virtualFile = (VirtualFile)readonlyFiles.get((int)it).second;
                } while (i$iv != n2);
            }
            return (VirtualFile[])((Object[])result$iv);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

