/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.FileContentQueue");
    private static final long MAX_SIZE_OF_BYTES_IN_QUEUE = 0x100000L;
    private static final long PROCESSED_FILE_BYTES_THRESHOLD = 0x300000L;
    private static final long LARGE_SIZE_REQUEST_THRESHOLD = 2838528L;
    private static final FileContent TOMBSTONE = new FileContent((VirtualFile)NullVirtualFile.INSTANCE);
    private final LinkedBlockingDeque<FileContent> myLoadedContentsQueue = new LinkedBlockingDeque();
    private final LinkedBlockingQueue<VirtualFile> myFilesToLoadQueue = new LinkedBlockingQueue();
    private volatile boolean myContentLoadingThreadTerminated = false;
    private volatile long myLoadedBytesInQueue;
    private final Object myProceedWithLoadingLock = new Object();
    private volatile long myBytesBeingProcessed;
    private volatile boolean myLargeSizeRequested;
    private final Object myProceedWithProcessingLock = new Object();
    private static final boolean ourAllowParallelFileReading = SystemProperties.getBooleanProperty((String)"idea.allow.parallel.file.reading", (boolean)true);

    public void queue(@NotNull Collection<VirtualFile> files, final @NotNull ProgressIndicator indicator) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/project/FileContentQueue", "queue"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "queue"));
        }
        this.myFilesToLoadQueue.addAll(files);
        Runnable contentLoadingRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file2 = (VirtualFile)FileContentQueue.this.myFilesToLoadQueue.poll();
                    while (file2 != null) {
                        indicator.checkCanceled();
                        FileContentQueue.this.addLast(file2, indicator);
                        file2 = (VirtualFile)FileContentQueue.this.myFilesToLoadQueue.poll();
                    }
                    try {
                        FileContentQueue.this.myLoadedContentsQueue.put(TOMBSTONE);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
                catch (ProcessCanceledException file2) {
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    FileContentQueue.this.myContentLoadingThreadTerminated = true;
                }
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(contentLoadingRunnable);
    }

    private void addLast(@NotNull VirtualFile file2, @NotNull ProgressIndicator indicator) throws InterruptedException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/FileContentQueue", "addLast"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "addLast"));
        }
        FileContent content = new FileContent(file2);
        if (FileContentQueue.isValidFile(file2)) {
            if (!this.doLoadContent(content, indicator)) {
                content.setEmptyContent();
            }
        } else {
            content.setEmptyContent();
        }
        this.myLoadedContentsQueue.put(content);
    }

    private static boolean isValidFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/FileContentQueue", "isValidFile"));
        }
        return file2.isValid() && !file2.isDirectory() && !file2.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink((VirtualFile)file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLoadContent(@NotNull FileContent content, @NotNull ProgressIndicator indicator) throws InterruptedException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/FileContentQueue", "doLoadContent"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "doLoadContent"));
        }
        long contentLength = content.getLength();
        boolean counterUpdated = false;
        try {
            Object object = this.myProceedWithLoadingLock;
            synchronized (object) {
                while (this.myLoadedBytesInQueue > 0x100000L) {
                    indicator.checkCanceled();
                    this.myProceedWithLoadingLock.wait(300L);
                }
                this.myLoadedBytesInQueue += contentLength;
                counterUpdated = true;
            }
            content.getBytes();
            return true;
        }
        catch (Throwable e) {
            if (counterUpdated) {
                Object object = this.myProceedWithLoadingLock;
                synchronized (object) {
                    this.myLoadedBytesInQueue -= contentLength;
                }
            }
            if (e instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof IOException || e instanceof InvalidVirtualFileAccessException) {
                LOG.info(e);
            } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                e.printStackTrace();
            } else {
                LOG.error(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileContent take(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/FileContentQueue", "take"));
        }
        FileContent content = this.doTake();
        if (content == null) {
            return null;
        }
        long length = content.getLength();
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                this.pushback(content);
                throw e;
            }
            Object object = this.myProceedWithProcessingLock;
            synchronized (object) {
                boolean requestingLargeSize;
                boolean bl = requestingLargeSize = length > 2838528L;
                if (requestingLargeSize) {
                    this.myLargeSizeRequested = true;
                }
                try {
                    if ((!this.myLargeSizeRequested || requestingLargeSize) && this.myBytesBeingProcessed + length <= Math.max(0x300000L, length)) {
                        this.myBytesBeingProcessed += length;
                        if (requestingLargeSize) {
                            this.myLargeSizeRequested = false;
                        }
                        return content;
                    }
                    this.myProceedWithProcessingLock.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileContent doTake() {
        FileContent result2 = null;
        while (result2 == null) {
            if (ourAllowParallelFileReading) {
                result2 = this.myLoadedContentsQueue.poll();
                if (result2 == null) {
                    VirtualFile virtualFileToLoad = this.myFilesToLoadQueue.poll();
                    if (virtualFileToLoad != null) {
                        FileContent content = new FileContent(virtualFileToLoad);
                        if (FileContentQueue.isValidFile(virtualFileToLoad)) {
                            try {
                                content.getBytes();
                                return content;
                            }
                            catch (IOException e) {
                                LOG.info(virtualFileToLoad + ": " + e);
                            }
                            catch (InvalidVirtualFileAccessException e) {
                                LOG.info(virtualFileToLoad + ": " + (Object)((Object)e));
                            }
                            catch (Throwable t) {
                                LOG.error(virtualFileToLoad + ": " + t);
                            }
                        }
                        content.setEmptyContent();
                        return content;
                    }
                    do {
                        try {
                            result2 = this.myLoadedContentsQueue.poll(10L, TimeUnit.MILLISECONDS);
                            if (result2 == null) continue;
                            break;
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                    } while (!this.myContentLoadingThreadTerminated);
                }
            } else {
                try {
                    result2 = this.myLoadedContentsQueue.poll(300L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (result2 != null || !this.myContentLoadingThreadTerminated) continue;
            return null;
        }
        if (result2 == TOMBSTONE) {
            try {
                this.myLoadedContentsQueue.put(result2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        Object object = this.myProceedWithLoadingLock;
        synchronized (object) {
            this.myLoadedBytesInQueue -= result2.getLength();
            if (this.myLoadedBytesInQueue < 0x100000L) {
                this.myProceedWithLoadingLock.notifyAll();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NotNull FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/FileContentQueue", "release"));
        }
        Object object = this.myProceedWithProcessingLock;
        synchronized (object) {
            this.myBytesBeingProcessed -= content.getLength();
            this.myProceedWithProcessingLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushback(@NotNull FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/project/FileContentQueue", "pushback"));
        }
        Object object = this.myProceedWithLoadingLock;
        synchronized (object) {
            this.myLoadedBytesInQueue += content.getLength();
        }
        this.myLoadedContentsQueue.addFirst(content);
    }
}

