/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantValueVariableUseInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new ReplaceReferenceWithExpressionFix(expression.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read;
        private boolean written;
        private PsiReferenceExpression reference;

        VariableReadVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor", "<init>"));
            }
            this.read = false;
            this.written = false;
            this.reference = null;
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor", "visitElement"));
            }
            if (this.read || this.written) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.read || this.written) {
                return;
            }
            PsiElement target = expression.resolve();
            if (this.variable.equals(target)) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                    this.written = true;
                    return;
                }
                if (PsiUtil.isAccessedForReading((PsiExpression)expression)) {
                    this.reference = expression;
                    this.read = true;
                    return;
                }
            }
            super.visitReferenceExpression(expression);
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getThenBranch();
            this.checkCondition(condition, body);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getBody();
            this.checkCondition(condition, body);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition = statement.getCondition();
            PsiStatement body = statement.getBody();
            this.checkCondition(condition, body);
        }

        private boolean checkCondition(@Nullable PsiExpression condition, @Nullable PsiStatement body) {
            if (body == null) {
                return false;
            }
            if (!(condition instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND == tokenType) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!this.checkCondition(operand, body)) continue;
                    return true;
                }
                return false;
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length != 2) {
                return false;
            }
            PsiExpression lhs = operands[0];
            PsiExpression rhs = operands[1];
            if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, (PsiElement)body);
            }
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, (PsiElement)body);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression, @NotNull PsiExpression constantExpression, @NotNull PsiElement body) {
            if (constantExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpression", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor", "checkConstantValueVariableUse"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor", "checkConstantValueVariableUse"));
            }
            PsiType constantType = constantExpression.getType();
            if (PsiType.DOUBLE.equals((Object)constantType)) {
                Object result2 = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result2) || Double.valueOf(-0.0).equals(result2)) {
                    return false;
                }
            }
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            if (target instanceof PsiField) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            VariableReadVisitor visitor = new VariableReadVisitor(variable);
            body.accept((PsiElementVisitor)visitor);
            if (!visitor.isRead()) {
                return false;
            }
            this.registerError((PsiElement)visitor.getReference(), constantExpression);
            return true;
        }
    }

    private static class ReplaceReferenceWithExpressionFix
    extends InspectionGadgetsFix {
        private final String myText;

        ReplaceReferenceWithExpressionFix(String text) {
            this.myText = text;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("replace.reference.with.expression.quickfix", this.myText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression, this.myText);
        }
    }
}

