/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame", "script-debugger-ui"})
public final class ExecutionStackImpl
extends XExecutionStack {
    private CallFrameView topCallFrameView;
    private final SuspendContext<? extends CallFrame> suspendContext;
    private final DebuggerViewSupport viewSupport;
    private final Script topFrameScript;
    private final SourceInfo topFrameSourceInfo;

    @Nullable
    public CallFrameView getTopFrame() {
        block5: {
            CallFrame topCallFrame;
            block4: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block4;
                CallFrameView callFrameView = this.topCallFrameView;
                if (callFrameView == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)callFrameView.getCallFrame(), (Object)topCallFrame) ^ true)) break block5;
            }
            this.topCallFrameView = topCallFrame == null ? (CallFrameView)null : new CallFrameView(topCallFrame, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, 16, null);
        }
        return this.topCallFrameView;
    }

    /*
     * WARNING - void declaration
     */
    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Vm vm = this.viewSupport.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContext<? extends CallFrame> suspendContext = vm.getSuspendContextManager().getContext();
        if (suspendContext == null) {
            return;
        }
        SuspendContext<? extends CallFrame> suspendContext2 = suspendContext;
        Promise<CallFrame[]> promise2 = suspendContext2.getFrames();
        void v2 = $receiver$iv;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T>");
        }
        ((Promise)v2).done((Consumer)new ContextDependentAsyncResultConsumer<CallFrame[]>(suspendContext2, this, firstFrameIndex, container){
            final /* synthetic */ ExecutionStackImpl this$0;
            final /* synthetic */ int $firstFrameIndex$inlined;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void consume(Object result2, Vm vm) {
                List result3;
                CallFrame[] frames = (CallFrame[])result2;
                int count = ((Object[])frames).length - this.$firstFrameIndex$inlined;
                if (count < 1) {
                    result3 = CollectionsKt.emptyList();
                } else {
                    result3 = new ArrayList<E>(count);
                    int n = this.$firstFrameIndex$inlined;
                    int n2 = ((Object[])frames).length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            if (i == false) {
                                ArrayList arrayList = (ArrayList)result3;
                                CallFrameView callFrameView = this.this$0.getTopFrame();
                                if (callFrameView == null) {
                                    Intrinsics.throwNpe();
                                }
                                arrayList.add(callFrameView);
                            } else {
                                Script script;
                                CallFrame frame = frames[i];
                                Object object = ExecutionStackImpl.access$getViewSupport$p(this.this$0).getVm();
                                Script script2 = object != null && (object = object.getScriptManager()) != null ? object.getScript(frame) : (script = null);
                                if (script != null) {
                                    boolean isInLibraryContent;
                                    SourceInfo sourceInfo = ExecutionStackImpl.access$getViewSupport$p(this.this$0).getSourceInfo(script, frame);
                                    boolean bl = isInLibraryContent = sourceInfo != null && ExecutionStackImpl.access$getViewSupport$p(this.this$0).isInLibraryContent(sourceInfo, script);
                                    if (!isInLibraryContent || XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                                        ((ArrayList)result3).add(new CallFrameView(frame, ExecutionStackImpl.access$getViewSupport$p(this.this$0), script, sourceInfo, isInLibraryContent));
                                    }
                                }
                            }
                            if (i == n2) break;
                            ++i;
                        }
                    }
                }
                this.$container$inlined.addStackFrames(result3, true);
            }
            {
                void $super_call_param$1;
                this.this$0 = executionStackImpl;
                this.$firstFrameIndex$inlined = n;
                this.$container$inlined = xStackFrameContainer;
                super((SuspendContext<?>)$super_call_param$1);
            }
        });
    }

    public ExecutionStackImpl(@NotNull SuspendContext<? extends CallFrame> suspendContext, @NotNull DebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        super("");
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackImpl(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo);
    }

    @NotNull
    public static final /* synthetic */ DebuggerViewSupport access$getViewSupport$p(ExecutionStackImpl $this) {
        return $this.viewSupport;
    }
}

