/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputReferences {
    private final List<String> relativePaths = Lists.newArrayList();
    private final List<Integer> relativePathLineNumbers = Lists.newArrayList();
    private final List<String> absolutePaths = Lists.newArrayList();
    private final List<Integer> absolutePathLineNumbers = Lists.newArrayList();

    public List<String> getAbsolutePaths() {
        return this.absolutePaths;
    }

    public List<Integer> getAbsolutePathLineNumbers() {
        return this.absolutePathLineNumbers;
    }

    public List<String> getRelativePaths() {
        return this.relativePaths;
    }

    public List<Integer> getRelativePathLineNumbers() {
        return this.relativePathLineNumbers;
    }

    public void relativePath(String path, int lineNumber) {
        this.relativePaths.add(path);
        this.relativePathLineNumbers.add(lineNumber);
    }

    public void absolutePath(String path, int lineNumber) {
        this.absolutePaths.add(path);
        this.absolutePathLineNumbers.add(lineNumber);
    }

    public boolean isEmpty() {
        return this.relativePaths.isEmpty() && this.absolutePaths.isEmpty();
    }

    public void absolutePaths(String[] paths, int[] lineNumbers) {
        this.absolutePaths.addAll(Arrays.asList(paths));
        for (int lineNumber : lineNumbers) {
            this.absolutePathLineNumbers.add(lineNumber);
        }
    }

    public void relativePaths(String[] paths, int[] lineNumbers) {
        this.relativePaths.addAll(Arrays.asList(paths));
        for (int lineNumber : lineNumbers) {
            this.relativePathLineNumbers.add(lineNumber);
        }
    }
}

