/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/asJava/KotlinCodeBlockModificationListener;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "modificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "(Lcom/intellij/psi/util/PsiModificationTracker;)V", "myModificationTracker", "Lcom/intellij/psi/impl/PsiModificationTrackerImpl;", "processChange", "", "parent", "Lcom/intellij/psi/PsiElement;", "child1", "child2", "treeChanged", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "Companion", "light-classes"})
public final class KotlinCodeBlockModificationListener
implements PsiTreeChangePreprocessor {
    private final PsiModificationTrackerImpl myModificationTracker;
    private static final Logger LOG;
    private static final Class<? extends KtDeclaration>[] BLOCK_DECLARATION_TYPES;
    public static final Companion Companion;

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!(event.getFile() instanceof KtFile)) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        if (!(Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL))) {
            if (Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED)) {
                this.processChange(event.getParent(), event.getOldChild(), event.getChild());
            } else if (Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED)) {
                if (!event.isGenericChange()) {
                    this.processChange(event.getParent(), event.getParent(), null);
                }
            } else if (Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED) || Intrinsics.areEqual((Object)psiEventType, (Object)PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED)) {
                this.myModificationTracker.incCounter();
            } else {
                KotlinCodeBlockModificationListener.Companion.getLOG().error("Unknown code:" + event.getCode());
            }
        }
    }

    private final void processChange(PsiElement parent2, PsiElement child1, PsiElement child2) {
        try {
            if (!Companion.isInsideCodeBlock(parent2)) {
                if (parent2 != null && parent2.getContainingFile() instanceof KtFile) {
                    this.myModificationTracker.incCounter();
                } else {
                    this.myModificationTracker.incOutOfCodeBlockModificationCounter();
                }
                return;
            }
            if (KotlinCodeBlockModificationListener.Companion.containsClassesInside(child1) || Intrinsics.areEqual((Object)child2, (Object)child1) ^ true && KotlinCodeBlockModificationListener.Companion.containsClassesInside(child2)) {
                this.myModificationTracker.incCounter();
            }
        }
        catch (PsiInvalidElementAccessException e) {
            this.myModificationTracker.incCounter();
        }
    }

    public KotlinCodeBlockModificationListener(@NotNull PsiModificationTracker modificationTracker2) {
        Intrinsics.checkParameterIsNotNull((Object)modificationTracker2, (String)"modificationTracker");
        PsiModificationTracker psiModificationTracker = modificationTracker2;
        if (psiModificationTracker == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiModificationTrackerImpl");
        }
        this.myModificationTracker = (PsiModificationTrackerImpl)psiModificationTracker;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.asJava.KotlinCodeBlockModificationListener");
        Class[] elements$iv = new Class[]{KtProperty.class, KtNamedFunction.class};
        BLOCK_DECLARATION_TYPES = (Class[])((Object[])elements$iv);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/asJava/KotlinCodeBlockModificationListener$Companion;", "", "()V", "BLOCK_DECLARATION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getBLOCK_DECLARATION_TYPES", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "containsClassesInside", "", "element", "Lcom/intellij/psi/PsiElement;", "isBlockDeclaration", "declaration", "isInsideCodeBlock", "light-classes"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final boolean containsClassesInside(PsiElement element2) {
            if (element2 == null) {
                return false;
            }
            if (element2 instanceof PsiClass) {
                return true;
            }
            for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!this.containsClassesInside(child)) continue;
                return true;
            }
            return false;
        }

        public final boolean isInsideCodeBlock(@Nullable PsiElement element2) {
            boolean bl;
            PsiElement blockDeclaration;
            block12: {
                if (element2 instanceof PsiFileSystemItem) {
                    return false;
                }
                if (element2 == null || element2.getParent() == null) {
                    return true;
                }
                Class<? extends KtDeclaration>[] classArray = this.getBLOCK_DECLARATION_TYPES();
                PsiElement psiElement2 = KtPsiUtil.getTopmostParentOfTypes(element2, Arrays.copyOf(classArray, classArray.length));
                if (psiElement2 == null) {
                    return false;
                }
                blockDeclaration = psiElement2;
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents(blockDeclaration);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(!(it instanceof KtClassBody) && !(it instanceof KtClassOrObject) && !(it instanceof KtFile))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            PsiElement psiElement3 = blockDeclaration;
            if (psiElement3 instanceof KtNamedFunction) {
                if (((KtNamedFunction)blockDeclaration).hasBlockBody()) {
                    return PsiUtilsKt.isAncestor$default((PsiElement)((KtNamedFunction)blockDeclaration).getBodyExpression(), element2, false, 2, null);
                }
                if (((KtNamedFunction)blockDeclaration).hasDeclaredReturnType()) {
                    return PsiUtilsKt.isAncestor$default((PsiElement)((KtNamedFunction)blockDeclaration).getInitializer(), element2, false, 2, null);
                }
            } else if (psiElement3 instanceof KtProperty) {
                for (KtPropertyAccessor accessor : ((KtProperty)blockDeclaration).getAccessors()) {
                    if (!PsiUtilsKt.isAncestor$default((PsiElement)accessor.getInitializer(), element2, false, 2, null) && !PsiUtilsKt.isAncestor$default((PsiElement)accessor.getBodyExpression(), element2, false, 2, null)) continue;
                    return true;
                }
            } else {
                throw (Throwable)new IllegalStateException();
            }
            return false;
        }

        public final boolean isBlockDeclaration(@NotNull KtDeclaration declaration) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Object[] $receiver$iv = this.getBLOCK_DECLARATION_TYPES();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    Class it = (Class)element$iv;
                    if (!it.isInstance(declaration)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final Class<? extends KtDeclaration>[] getBLOCK_DECLARATION_TYPES() {
            return BLOCK_DECLARATION_TYPES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

