/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.JsProjectDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;

public class KotlinSourceFilterScope
extends DelegatingGlobalSearchScope {
    private final ProjectFileIndex index;
    private final Project project;
    private final boolean includeProjectSourceFiles;
    private final boolean includeLibrarySourceFiles;
    private final boolean includeClassFiles;
    private final boolean isJsProject;

    @NotNull
    public static GlobalSearchScope sourcesAndLibraries(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sourcesAndLibraries"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sourcesAndLibraries"));
        }
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.create(delegate2, true, true, true, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sourcesAndLibraries"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope sourceAndClassFiles(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sourceAndClassFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sourceAndClassFiles"));
        }
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.create(delegate2, true, false, true, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sourceAndClassFiles"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope sources(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sources"));
        }
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.create(delegate2, true, false, false, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "sources"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope librarySources(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "librarySources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "librarySources"));
        }
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.create(delegate2, false, true, false, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "librarySources"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope libraryClassFiles(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "libraryClassFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "libraryClassFiles"));
        }
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.create(delegate2, false, false, true, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "libraryClassFiles"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope create(@NotNull GlobalSearchScope delegate2, boolean includeProjectSourceFiles, boolean includeLibrarySourceFiles, boolean includeClassFiles, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "create"));
        }
        if (delegate2 == GlobalSearchScope.EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = delegate2;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "create"));
            }
            return globalSearchScope;
        }
        if (delegate2 instanceof KotlinSourceFilterScope) {
            KotlinSourceFilterScope wrappedDelegate = (KotlinSourceFilterScope)delegate2;
            boolean doIncludeProjectSourceFiles = wrappedDelegate.includeProjectSourceFiles && includeProjectSourceFiles;
            boolean doIncludeLibrarySourceFiles = wrappedDelegate.includeLibrarySourceFiles && includeLibrarySourceFiles;
            boolean doIncludeClassFiles = wrappedDelegate.includeClassFiles && includeClassFiles;
            KotlinSourceFilterScope kotlinSourceFilterScope = new KotlinSourceFilterScope(wrappedDelegate.myBaseScope, doIncludeProjectSourceFiles, doIncludeLibrarySourceFiles, doIncludeClassFiles, project);
            if (kotlinSourceFilterScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "create"));
            }
            return kotlinSourceFilterScope;
        }
        KotlinSourceFilterScope kotlinSourceFilterScope = new KotlinSourceFilterScope(delegate2, includeProjectSourceFiles, includeLibrarySourceFiles, includeClassFiles, project);
        if (kotlinSourceFilterScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "create"));
        }
        return kotlinSourceFilterScope;
    }

    private KotlinSourceFilterScope(@NotNull GlobalSearchScope delegate2, boolean includeProjectSourceFiles, boolean includeLibrarySourceFiles, boolean includeClassFiles, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "<init>"));
        }
        super(delegate2);
        this.project = project;
        this.includeProjectSourceFiles = includeProjectSourceFiles;
        this.includeLibrarySourceFiles = includeLibrarySourceFiles;
        this.includeClassFiles = includeClassFiles;
        this.index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.isJsProject = JsProjectDetector.isJsProject(project);
    }

    public Project getProject() {
        return this.project;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/stubindex/KotlinSourceFilterScope", "contains"));
        }
        if (!super.contains(file)) {
            return false;
        }
        return ProjectRootsUtil.isInContent(this.project, file, this.includeProjectSourceFiles, this.includeLibrarySourceFiles, this.includeClassFiles, this.index, this.isJsProject);
    }
}

