/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class XsltIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("xslt" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltIncludeProvider", "getId"));
        }
        return "xslt";
    }

    public boolean acceptFile(VirtualFile file) {
        return file.getFileType() == XmlFileType.INSTANCE;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "org/intellij/lang/xpath/xslt/impl/XsltIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)XmlFileType.INSTANCE);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        CharSequence contentAsText = content.getContentAsText();
        if (CharArrayUtil.indexOf((CharSequence)contentAsText, (CharSequence)"http://www.w3.org/1999/XSL/Transform", (int)0) == -1) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList infos = new ArrayList();
        NanoXmlUtil.IXMLBuilderAdapter builder = new NanoXmlUtil.IXMLBuilderAdapter(){
            boolean isXslt;
            boolean isInclude;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                boolean isXsltTag = "http://www.w3.org/1999/XSL/Transform".equals(nsURI);
                if (!this.isXslt) {
                    if (!isXsltTag) {
                        1.stop();
                    } else {
                        this.isXslt = true;
                    }
                }
                this.isInclude = isXsltTag && ("include".equals(name) || "import".equals(name));
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (this.isInclude && "href".equals(key)) {
                    infos.add(new FileIncludeInfo(value));
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                this.isInclude = false;
            }
        };
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)contentAsText), (IXMLBuilder)builder);
        FileIncludeInfo[] fileIncludeInfoArray = infos.toArray(new FileIncludeInfo[infos.size()]);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }
}

