/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.providers.http.httpclient.HttpEntity;
import org.apache.maven.wagon.providers.http.httpclient.HttpException;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.CloseableHttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpGet;
import org.apache.maven.wagon.providers.http.wagon.shared.HtmlFileListParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpWagon
extends AbstractHttpClientWagon {
    public List<String> getFileList(String destinationDirectory) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        return this.getFileList(this.getInitialBackoffSeconds(), destinationDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getFileList(int wait, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        HttpGet getMethod = new HttpGet(url);
        try {
            CloseableHttpResponse response = this.execute(getMethod);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                this.fireTransferDebug(url + " - Status code: " + statusCode);
                switch (statusCode) {
                    case 200: {
                        break;
                    }
                    case 403: {
                        throw new AuthorizationException("Access denied to: " + url);
                    }
                    case 401: {
                        throw new AuthorizationException("Not authorized.");
                    }
                    case 407: {
                        throw new AuthorizationException("Not authorized by proxy.");
                    }
                    case 404: {
                        throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                    }
                    case 429: {
                        List<String> list = this.getFileList(this.backoff(wait, url), destinationDirectory);
                        return list;
                    }
                    default: {
                        throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                    }
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    List<String> list = HtmlFileListParser.parseFileList(url, entity.getContent());
                    return list;
                }
                List<String> list = Collections.emptyList();
                return list;
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Could not read response body.", (Throwable)e);
        }
        catch (HttpException e) {
            throw new TransferFailedException("Could not read response body.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("Unable to wait for resource.", (Throwable)e);
        }
    }
}

