/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "url", "", "messageParent", "Ljava/awt/Container;", "checkUrl", "uriString", "isValidRepository", "file", "Ljava/io/File;", "settings-repository"})
public interface RepositoryService {
    public boolean checkUrl(@NotNull String var1, @Nullable Container var2);

    public boolean checkFileRepo(@NotNull String var1, @NotNull Container var2);

    public boolean isValidRepository(@NotNull File var1);

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=3)
    public static final class DefaultImpls {
        public static boolean checkUrl(@NotNull RepositoryService $this, @Nullable String uriString, Container messageParent) {
            boolean isFile;
            Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
            URIish uri = new URIish(uriString);
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                isFile = true;
            } else {
                boolean bl = isFile = uri.getScheme() == null && uri.getHost() == null;
            }
            return messageParent == null || !isFile || $this.checkFileRepo(uriString, messageParent);
        }

        public static /* bridge */ /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, Container container, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkUrl");
            }
            if ((n & 2) != 0) {
                container = null;
            }
            return repositoryService.checkUrl(string, container);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean checkFileRepo(@NotNull RepositoryService $this, @NotNull String url, Container messageParent) {
            String string;
            File file;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)messageParent, (String)"messageParent");
            String suffix = "/" + ".git";
            File file2 = file;
            File file3 = file;
            if (StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2, null)) {
                void endIndex$iv;
                void startIndex$iv;
                void $receiver$iv;
                String string2 = url;
                boolean bl = false;
                int n = url.length() - suffix.length();
                File file4 = file2;
                File file5 = file3;
                void v3 = $receiver$iv;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)v3).substring((int)startIndex$iv, (int)endIndex$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string3;
                file3 = file5;
                file2 = file4;
                string = string4;
            } else {
                string = url;
            }
            file2(string);
            File file6 = file3;
            if (file6.exists()) {
                if (!file6.isDirectory()) {
                    Messages.showErrorDialog((Component)messageParent, (String)"Specified path is not a directory", (String)"Specified Path is Invalid");
                    return false;
                }
                if ($this.isValidRepository(file6)) {
                    return true;
                }
            } else if (!file6.isAbsolute()) {
                Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]), (String)"");
                return false;
            }
            if (Messages.showYesNoDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.dialog.message", new Object[0]), (String)IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                try {
                    GitExKt.createBareRepository(file6);
                    return true;
                }
                catch (IOException e) {
                    Messages.showErrorDialog((Component)messageParent, (String)IcsBundleKt.icsMessage("init.failed.message", e.getMessage()), (String)IcsBundleKt.icsMessage("init.failed.title", new Object[0]));
                    return false;
                }
            }
            return false;
        }
    }
}

