/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.behavior.EncodeEachSymbolPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlCopyPastePreProcessor
implements CopyPastePreProcessor {
    private static final EncodeEachSymbolPolicy ENCODE_EACH_SYMBOL_POLICY = new EncodeEachSymbolPolicy();

    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)caretOffset);
        ASTNode node = element.getNode();
        if (node != null) {
            boolean hasMarkup;
            boolean bl = hasMarkup = text.indexOf(62) >= 0 || text.indexOf(60) >= 0;
            if (element.getTextOffset() == caretOffset && node.getElementType() == XmlTokenType.XML_END_TAG_START && node.getTreePrev().getElementType() == XmlTokenType.XML_TAG_END) {
                String string = hasMarkup ? text : XmlCopyPastePreProcessor.encode(text, element);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlCopyPastePreProcessor", "preprocessOnPaste"));
                }
                return string;
            }
            XmlElement parent = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{XmlText.class, XmlAttributeValue.class});
            if (parent != null) {
                if (parent instanceof XmlText && hasMarkup) {
                    String string = text;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlCopyPastePreProcessor", "preprocessOnPaste"));
                    }
                    return string;
                }
                if (TreeUtil.findParent(node, XmlElementType.XML_CDATA) == null && TreeUtil.findParent(node, XmlElementType.XML_COMMENT) == null) {
                    String string = XmlCopyPastePreProcessor.encode(text, element);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlCopyPastePreProcessor", "preprocessOnPaste"));
                    }
                    return string;
                }
            }
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlCopyPastePreProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    private static String encode(String text, PsiElement element) {
        ASTNode astNode = ENCODE_EACH_SYMBOL_POLICY.encodeXmlTextContents(text, element);
        return astNode.getTreeParent().getText();
    }
}

