/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u001aB\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b0\u00062\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0000\u001a\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a#\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0000\u00a2\u0006\u0002\u0010\u0014\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "executeSave", "", "", "session", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "readonlyFiles", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "previousErrors", "findNonDeprecated", "Lcom/intellij/openapi/components/Storage;", "storages", "", "([Lcom/intellij/openapi/components/Storage;)Lcom/intellij/openapi/components/Storage;", "sortStoragesByDeprecated", "([Lcom/intellij/openapi/components/Storage;)[Lcom/intellij/openapi/components/Storage;", "configuration-store-impl"})
public final class ComponentStoreImplKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @Nullable
    public static final List<Throwable> executeSave(@NotNull StateStorage.SaveSession session, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> previousErrors) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List errors = previousErrors;
        try {
            session.save();
        }
        catch (ReadOnlyModificationException e) {
            LOG.warn((Throwable)e);
            StateStorage.SaveSession saveSession = e.getSession();
            if (saveSession == null) {
                saveSession = session;
            }
            Pair pair = Pair.create((Object)saveSession, (Object)e.getFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"JBPair.create<SaveSessio\u2026ssion ?: session, e.file)");
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)pair);
        }
        catch (Exception e) {
            if (errors == null) {
                errors = (List)new SmartList();
            }
            errors.add((Throwable)e);
        }
        return errors;
    }

    private static final Storage findNonDeprecated(Storage[] storages) {
        for (int i = 0; i < storages.length; ++i) {
            Storage storage2 = storages[i];
            if (storage2.deprecated()) continue;
            return storage2;
        }
        throw (Throwable)((Object)new AssertionError((Object)"All storages are deprecated"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Storage[] sortStoragesByDeprecated(@NotNull Storage[] storages) {
        Intrinsics.checkParameterIsNotNull((Object)storages, (String)"storages");
        Object[] $receiver$iv = storages;
        if ($receiver$iv.length == 0) {
            return storages;
        }
        if (!storages[0].deprecated()) {
            boolean othersAreDeprecated = true;
            int $i$f$isEmpty = 1;
            int n = ((Object[])storages).length - 1;
            if ($i$f$isEmpty <= n) {
                while (true) {
                    void i;
                    if (!storages[i].deprecated()) {
                        othersAreDeprecated = false;
                        break;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (othersAreDeprecated) {
                return storages;
            }
        }
        return (Storage[])ArraysKt.sortedArrayWith((Object[])storages, (Comparator)sortStoragesByDeprecated.1.INSTANCE);
    }

    @NotNull
    public static final /* synthetic */ Storage access$findNonDeprecated(@NotNull Storage[] storages) {
        return ComponentStoreImplKt.findNonDeprecated(storages);
    }
}

