/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectCollectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerContextCommandImpl
extends SuspendContextCommandImpl {
    private static final Logger LOG = Logger.getInstance(DebuggerContextCommandImpl.class);
    private final DebuggerContextImpl myDebuggerContext;
    private final ThreadReferenceProxyImpl myCustomThread;
    private SuspendContextImpl myCustomSuspendContext;

    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext) {
        if (debuggerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/engine/events/DebuggerContextCommandImpl", "<init>"));
        }
        this(debuggerContext, null);
    }

    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext, @Nullable ThreadReferenceProxyImpl customThread) {
        if (debuggerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/engine/events/DebuggerContextCommandImpl", "<init>"));
        }
        super(debuggerContext.getSuspendContext());
        this.myDebuggerContext = debuggerContext;
        this.myCustomThread = customThread;
    }

    @Override
    @Nullable
    public SuspendContextImpl getSuspendContext() {
        if (this.myCustomSuspendContext == null) {
            this.myCustomSuspendContext = super.getSuspendContext();
            ThreadReferenceProxyImpl thread = this.getThread();
            if (this.myCustomThread != null && (this.myCustomSuspendContext == null || this.myCustomSuspendContext.isResumed() || !this.myCustomSuspendContext.suspends(thread))) {
                this.myCustomSuspendContext = SuspendManagerUtil.findContextByThread(this.myDebuggerContext.getDebugProcess().getSuspendManager(), thread);
            }
        }
        return this.myCustomSuspendContext;
    }

    private ThreadReferenceProxyImpl getThread() {
        return this.myCustomThread != null ? this.myCustomThread : this.myDebuggerContext.getThreadProxy();
    }

    public final DebuggerContextImpl getDebuggerContext() {
        return this.myDebuggerContext;
    }

    @Override
    public final void contextAction() throws Exception {
        boolean isSuspendedByContext;
        if (this.myCustomThread != null) {
            this.threadAction();
            return;
        }
        SuspendManager suspendManager = this.myDebuggerContext.getDebugProcess().getSuspendManager();
        try {
            isSuspendedByContext = suspendManager.isSuspended(this.getThread());
        }
        catch (ObjectCollectedException ignored) {
            this.notifyCancelled();
            return;
        }
        if (isSuspendedByContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Context thread " + this.getSuspendContext().getThread());
                LOG.debug("Debug thread" + this.getThread());
            }
            this.threadAction();
        } else {
            SuspendContextImpl suspendContextForThread = SuspendManagerUtil.findContextByThread(suspendManager, this.getThread());
            if (suspendContextForThread != null) {
                suspendContextForThread.postponeCommand(this);
            } else {
                this.notifyCancelled();
            }
        }
    }

    public abstract void threadAction();
}

