/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.rt.debugger.ImageSerializer;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static ClassLoaderReference getClassLoader(EvaluationContext context, DebugProcess process) throws EvaluateException {
        try {
            ClassType loaderClass = (ClassType)process.findClass(context, "java.net.URLClassLoader", context.getClassLoader());
            Method ctorMethod = loaderClass.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
            ClassLoaderReference reference = (ClassLoaderReference)process.newInstance(context, loaderClass, ctorMethod, Arrays.asList(ClassLoadingUtils.createURLArray(context), context.getClassLoader()));
            DebuggerUtilsEx.keep(reference, context);
            return reference;
        }
        catch (Exception e) {
            throw new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
    }

    public static void defineClass(String name, byte[] bytes, EvaluationContext context, DebugProcess process, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process.getVirtualMachineProxy();
            Method defineMethod = ((ClassType)classLoader.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            StringReference nameObj = proxy.mirrorOf(name);
            DebuggerUtilsEx.keep(nameObj, context);
            process.invokeMethod(context, (ObjectReference)classLoader, defineMethod, Arrays.asList(nameObj, ClassLoadingUtils.mirrorOf(bytes, context, process), proxy.mirrorOf(0), proxy.mirrorOf(bytes.length)));
        }
        catch (Exception e) {
            throw new EvaluateException("Error during class " + name + " definition: " + e, (Throwable)e);
        }
    }

    @Nullable
    public static ClassType getHelperClass(String name, EvaluationContext evaluationContext, DebugProcess process) throws EvaluateException {
        try {
            ClassLoaderReference classLoader = evaluationContext.getClassLoader();
            return (ClassType)process.findClass(evaluationContext, name, classLoader);
        }
        catch (EvaluateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationException && "java.lang.ClassNotFoundException".equals(((InvocationException)cause).exception().type().name())) {
                ClassType classType;
                ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(evaluationContext, process);
                InputStream stream = ImageSerializer.class.getResourceAsStream("/" + name.replaceAll("[.]", "/") + ".class");
                try {
                    if (stream == null) {
                        ClassType classType2 = null;
                        return classType2;
                    }
                    ClassLoadingUtils.defineClass(name, StreamUtil.loadFromStream((InputStream)stream), evaluationContext, process, classLoader);
                    ((EvaluationContextImpl)evaluationContext).setClassLoader(classLoader);
                    classType = (ClassType)process.findClass(evaluationContext, name, classLoader);
                }
                catch (IOException ioe) {
                    throw new EvaluateException("Unable to read " + name + " class bytes", (Throwable)ioe);
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return classType;
            }
            throw e;
        }
    }

    private static ArrayReference createURLArray(EvaluationContext context) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        DebugProcess process = context.getDebugProcess();
        ArrayType arrayType = (ArrayType)process.findClass(context, "java.net.URL[]", context.getClassLoader());
        ArrayReference arrayRef = arrayType.newInstance(1);
        DebuggerUtilsEx.keep(arrayRef, context);
        ClassType classType = (ClassType)process.findClass(context, "java.net.URL", context.getClassLoader());
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)process.getVirtualMachineProxy();
        StringReference url = proxy.mirrorOf("file:a");
        DebuggerUtilsEx.keep(url, context);
        ObjectReference reference = process.newInstance(context, classType, classType.concreteMethodByName("<init>", "(Ljava/lang/String;)V"), Collections.singletonList(url));
        DebuggerUtilsEx.keep(reference, context);
        arrayRef.setValues(Collections.singletonList(reference));
        return arrayRef;
    }

    private static ArrayReference mirrorOf(byte[] bytes, EvaluationContext context, DebugProcess process) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        ArrayType arrayClass = (ArrayType)process.findClass(context, "byte[]", context.getClassLoader());
        ArrayReference reference = process.newInstance(arrayClass, bytes.length);
        DebuggerUtilsEx.keep(reference, context);
        for (int i = 0; i < bytes.length; ++i) {
            reference.setValue(i, (Value)((VirtualMachineProxyImpl)process.getVirtualMachineProxy()).mirrorOf(bytes[i]));
        }
        return reference;
    }
}

